/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.listeners.message;

import org.jboss.soa.esb.message.Message;

/**
 * Bean that stores data on the message status.    Since the Observer/Observable
 * java scheme only allows us to pass a single object, we store all the required 
 * data and metadata for reporting here.
 * 
 * @author <a href="mailto:tcunning@redhat.com">tcunning@redhat.com</a> 
 *
 */
public class MessageStatusBean {
	private Message m_msg;
	private String m_status;
	private long m_messageTime;
	private long m_processTime;
	
	public static final String MESSAGE_SENT = "SENT";
	public static final String MESSAGE_FAILED = "FAILED";
	
	/**
	 * Constructor.
	 */
	public MessageStatusBean() {
	}
	
	/**
	 * Constructor.
	 * 
	 * @param f_processTime  Time it takes to process message.
	 * @param f_msg the message
	 * @param f_status status 
	 */
	public MessageStatusBean(long f_processTime, Message f_msg, String f_status) {
		this.m_processTime = f_processTime;
		this.m_msg = f_msg;
		this.m_status = f_status;
		this.m_messageTime = System.currentTimeMillis();
	}
	
	/**
	 * Message getter.
	 * @return the Message
	 */
	public Message getMessage() {
		return m_msg;
	}
	
	/**
	 * Message mutator.
	 * @param f_msg the Message
	 */
	public void setMessage(Message f_msg) {
		this.m_msg = f_msg;
	}
	
	/**
	 * Message status getter.
	 * @return message status
	 */
	public String getMessageStatus() {
		return m_status;
	}
	
	/**
	 * Message status mutator.
	 * @param f_status message status 
	 */
	public void setMessageStatus(String f_status) {
		this.m_status = f_status;
	}
	
	/**
	 * Message time getter.
	 * @return the time when the message was sent
	 */
	public long getMessageTime() {
		return m_messageTime;
	}
	
	/**
	 * Message time mutator.
	 * @param f_messageTime the time the message was sent 
	 */
	public void setMessageTime(long f_messageTime) {
		m_messageTime = f_messageTime;
	}
	
	/**
	 * Process time getter.
	 * @return processing time of the message
	 */
	public long getProcessTime() {
		return m_processTime;
	}
	
	/**
	 * Process time mutator.
	 * @param f_processTime processing time of the message
	 */
	public void setProcessTime(long f_processTime) {
		this.m_processTime = f_processTime;
	}
}
