/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.message;

import java.lang.reflect.Constructor;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.ActionLifecycleException;
import org.jboss.soa.esb.actions.ActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.util.BeanConfigurator;

public class BeanConfigActionProcessor implements ActionPipelineProcessor {

	/** Config tree for processor */
	private final ConfigTree config;

	/** No-argument constructor for action class */
	private final Constructor constructor;

	/** Method info on action class */
	private final ActionProcessorMethodInfo methodInfo;

	/**
	 * Construct the overridden action processor.
	 * 
	 * @param config The action config.
	 * @param actionClass The action class.
	 * @throws ConfigurationException for errors during configuration.
	 */
	BeanConfigActionProcessor(final ConfigTree config, final Class actionClass)
			throws ConfigurationException {
		this.config = config;
		try {
			this.constructor = actionClass.getConstructor();
		} catch (SecurityException e) {
			throw new ConfigurationException(e);
		} catch (NoSuchMethodException e) {
			throw new ConfigurationException(e);
		}
		this.methodInfo = ActionProcessorMethodInfo.getMethodInfo(config, actionClass);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jboss.soa.esb.actions.ActionPipelineProcessor#process(org.jboss.soa.esb.message.Message)
	 */
	public Message process(Message message) throws ActionProcessingException {
		if (methodInfo.hasProcessMethods()) {
			try {
				Object instance = constructor.newInstance();
				BeanConfigurator configurator = new ActionBeanConfigurator(config, instance);
				configurator.configure();
				return methodInfo.processMethods(instance, message);
			} catch (Exception e) {
				throw new ActionProcessingException(e);
			}
		} else {
			return message;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jboss.soa.esb.actions.ActionPipelineProcessor#processException(org.jboss.soa.esb.message.Message,
	 * java.lang.Throwable)
	 */
	public void processException(Message message, Throwable th) {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jboss.soa.esb.actions.ActionPipelineProcessor#processSuccess(org.jboss.soa.esb.message.Message)
	 */
	public void processSuccess(Message message) {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jboss.soa.esb.actions.ActionLifecycle#destroy()
	 */
	public void destroy() throws ActionLifecycleException {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jboss.soa.esb.actions.ActionLifecycle#initialise()
	 */
	public void initialise() throws ActionLifecycleException {
	}
}