/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.soa.esb.listeners.jca;

import javax.jms.Message;
import javax.jms.MessageListener;

import org.jboss.soa.esb.listeners.gateway.PackageJmsMessageContents;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.Configurable;
import org.jboss.soa.esb.ConfigurationException;

/**
 * comment
 *
 * @author <a href="bill@jboss.com">Bill Burke</a>
 * @version $Revision: 1.1 $
 */
public class JmsEndpoint implements InflowGateway, MessageListener, Configurable {
    
   private org.jboss.soa.esb.client.ServiceInvoker service;
   private PackageJmsMessageContents transformer;

    public void setConfiguration(ConfigTree config) throws ConfigurationException {
        MessagePayloadProxy proxy = PackageJmsMessageContents.createPayloadProxy(config);
        transformer = new PackageJmsMessageContents(proxy);
    }

    public void setServiceInvoker(ServiceInvoker invoker)
   {
      this.service = invoker;
   }

    public void onMessage(Message message)
   {
      if(transformer == null) {
          throw new IllegalStateException("Class not configured.  setConfiguration(ConfigTree) must be called before endpoint can listen for messages.");
      }

      try
      {
         org.jboss.soa.esb.message.Message esbMessage = transformer.process(message);
         service.deliverAsync(esbMessage);
      }
      catch (Exception e)
      {
         throw new RuntimeException(e);
      }
   }
}
