/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.soa.esb.listeners.gateway;

import java.io.Serializable;

import org.jboss.soa.esb.listeners.ListenerTagNames;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.helpers.ConfigTree;

/**
* Default packaging for Hibernate Entity messages. <p/>It will just drop the
* Hibernate entity into a message.
*
* @author <a href="mailto:tcunning@redhat.com">tcunning@redhat.com</a>
* @since Version 4.2
*
*/
public class PackageHibernateMessageContents {

    private MessagePayloadProxy payloadProxy;

    public PackageHibernateMessageContents() {
        this.payloadProxy = createPayloadProxy(new ConfigTree("default-config"));
    }

    public PackageHibernateMessageContents(MessagePayloadProxy payloadProxy) {
        this.payloadProxy = payloadProxy;
    }

    public Message process (Object obj) throws MessageDeliverException {
		if (!(obj instanceof Serializable))
			throw new IllegalArgumentException("Object must be serializable");

		Message message = MessageFactory.getInstance().getMessage();

		payloadProxy.setPayload(message, obj);

		return message;
	}

    public static MessagePayloadProxy createPayloadProxy(ConfigTree config) {
        return  new MessagePayloadProxy(config,
                new String[] {ListenerTagNames.HIBERNATE_OBJECT_DATA_TAG},
                new String[] {ListenerTagNames.HIBERNATE_OBJECT_DATA_TAG});
    }
}