/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.couriers;

import java.net.URI;

import org.jboss.soa.esb.message.Message;

/**
 * The service encountered an error and returned a Fault message. This is
 * received and then thrown as an exception.
 * 
 * @since Version 4.2
 */

public class FaultMessageException extends CourierException
{

	private static final long serialVersionUID = 1L;

	/**
	 * Construct an exception instance.
	 * 
	 * @param message
	 *            Exception message.
	 */

	public FaultMessageException(String message, URI code, Message msg)
	{
		super(message);

		_code = code;
		_msg = msg;
	}
	
	public FaultMessageException(String message, URI code, Message msg, Throwable cause)
	{
		super(message, cause);

		_code = code;
		_msg = msg;
	}

	public final URI getCode()
	{
		return _code;
	}
	
	public final Message getReturnedMessage ()
	{
		return _msg;
	}

	private URI _code;
	private Message _msg;

}
