/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.internal.soa.esb.publish;

import org.jboss.internal.soa.esb.assertion.AssertArgument;

/**
 * Endpoint contract publication information.
 * <p/>
 * The contract definition e.g. WSDL.
 *
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class ContractInfo {

    private String mimeType;
    private String data;

    /**
     * Public constructor.
     * @param mimeType Contract data MIME type.
     * @param data Contract data.
     */
    public ContractInfo(String mimeType, String data) {
        AssertArgument.isNotNullAndNotEmpty(mimeType, "mimeType");
        AssertArgument.isNotNullAndNotEmpty(data, "data");

        this.mimeType = mimeType;
        this.data = data;
    }

    /**
     * Get the contract data MIME type.
     * @return Contract data mime type.
     */
    public String getMimeType() {
        return mimeType;
    }

    /**
     * Get the contract data.
     * @return Contract data.
     */
    public String getData() {
        return data;
    }
}
