/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * (C) 2005-2006
 *  
 */

package org.jboss.internal.soa.esb.persistence.manager;

import java.sql.Connection;
import java.sql.SQLException;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.persistence.manager.ConnectionManager;

/**
 * J2EE datasource based Connection Pooling implementation for use when deploying to a J2EE container 
 *
 */
public class J2eeConnectionManager implements ConnectionManager {
    
    private static J2eeConnectionManager instance = null;
    @SuppressWarnings("unused")
    private DataSource datasource = null;
    private Context oJndiCtx = null;
    
    private static Logger _logger = Logger.getLogger(J2eeConnectionManager.class);
    private static final Object foo = new Integer(0);

    public Connection getConnection() throws SQLException 
    {
        return datasource.getConnection();
    }

    public ConnectionManager getInstance() {
        if (null != instance)
        {
            return instance;
        }
        
        synchronized (foo)
        {
            if (null != instance) 
                return instance;
            
            try
            {
                instance = new J2eeConnectionManager();
                instance.init();
            }
            catch (Exception e)
            {
                _logger.error("Could not initialise instance.", e);
                
                return null;
            }

            return instance;
        }
    }

    public void init() throws ConfigurationException {
        _logger.info("initializing...");
        
                             
        try
        {
            oJndiCtx = new InitialContext();
            if (null == oJndiCtx) {
                _logger.error("could not get a valid context");
                throw new ConfigurationException("could not get a valid context - check your settings in the config file");
            } 
            String dataSourcename = Configuration.getStoreDBDatasourceName();
            datasource =  ((DataSource) oJndiCtx.lookup(dataSourcename));
        }
        catch (Exception ex)
        {
                throw new ConfigurationException(ex);
        }
    }

}
