package org.jboss.internal.soa.esb.message.format.xml.body.content;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;

import org.jboss.internal.soa.esb.message.format.xml.BodyImpl;
import org.jboss.soa.esb.message.body.content.InvalidPayloadException;
import org.jboss.soa.esb.message.body.content.MapBody;
import org.jboss.soa.esb.message.body.content.Payload;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author mark.little@jboss.com
 */

/**
 * The Message payload contains a Map of serializable Objects that can be
 * inserted and retrieved as a Map.
 */

public class MapBodyImpl extends BodyImpl implements MapBody
{
	public MapBodyImpl (BodyImpl b)
	{
		super(b);
		
		add(Payload.CONTENT_TYPE, Payload.MAP_BODY);
	}
	
	public void setMap (Map<String, Serializable> payload)
	{
            initialiseMap(payload) ;
	}
	
	public boolean getBoolean (String name) throws InvalidPayloadException
	{
		try
		{
			return ((Boolean) get(name)).booleanValue();
		}
		catch (Exception ex)
		{
			throw new InvalidPayloadException();
		}
	}
	
	public byte getByte (String name) throws InvalidPayloadException
	{
		try
		{
			return ((Byte) get(name)).byteValue();
		}
		catch (Exception ex)
		{
			throw new InvalidPayloadException();
		}
	}
	
	public byte[] getBytes (String name) throws InvalidPayloadException
	{
		try
		{
			return ((String) get(name)).getBytes();
		}
		catch (Exception ex)
		{
			throw new InvalidPayloadException();
		}
	}
	
	public float getFloat (String name) throws InvalidPayloadException
	{
		try
		{
			return ((Float) get(name)).floatValue();
		}
		catch (Exception ex)
		{
			throw new InvalidPayloadException();
		}
	}
	
	public double getDouble (String name) throws InvalidPayloadException
	{
		try
		{
			return ((Double) get(name)).doubleValue();
		}
		catch (Exception ex)
		{
			throw new InvalidPayloadException();
		}
	}
	
	public char getChar (String name) throws InvalidPayloadException
	{
		try
		{
			return (char) ((Byte) get(name)).byteValue();
		}
		catch (Exception ex)
		{
			throw new InvalidPayloadException();
		}
	}
	
	public int getInt (String name) throws InvalidPayloadException
	{
		try
		{
			return ((Integer) get(name)).intValue();
		}
		catch (Exception ex)
		{
			throw new InvalidPayloadException();
		}
	}
	
	public long getLong (String name) throws InvalidPayloadException
	{
		try
		{
			return ((Long) get(name)).longValue();
		}
		catch (Exception ex)
		{
			throw new InvalidPayloadException();
		}
	}
	
	public String getString (String name) throws InvalidPayloadException
	{
		try
		{
			return (String) get(name);
		}
		catch (Exception ex)
		{
			throw new InvalidPayloadException();
		}
	}
	
	public Enumeration<String> getMapNames ()
	{
		return getEnumeratedNames();
	}
	
	public boolean itemExists (String name)
	{
		return (boolean) (get(name) != null);
	}
	
	public void setBoolean (String name, boolean val)
	{
		add(name, new Boolean(val));
	}
	
	public void setByte (String name, byte val)
	{
		add(name, new Byte(val));
	}
	
	public void setBytes (String name, byte[] val)
	{
		add(name, new String(val));
	}
	
	public void setFloat (String name, float val)
	{
		add(name, new Double(val));
	}
	
	public void setDouble (String name, double val)
	{
		add(name, new Double(val));
	}
	
	public void setChar (String name, char val)
	{
		add(name, new Byte((byte) val));
	}
	
	public void setInt (String name, int val)
	{
		add(name, new Integer(val));
	}
	
	public void setLong (String name, long val)
	{
		add(name, new Long(val));
	}
	
	public void setString (String name, String val)
	{
		add(name, val);
	}
}