/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author mark.little@jboss.com
 */

/*
 * Copyright (c) 2002, 2003, Arjuna Technologies Limited.
 *
 * XMLUtil.java
 */

package org.jboss.internal.soa.esb.message.format.xml;

import javax.xml.namespace.QName;

public class XMLUtil
{
    public static final String ESB_PREFIX = "jbesb";
    public static final String ESB_NAMESPACE_URI = "http://www.jboss.org/ws/2006/09/esb";
    
    // Element names
    /**
     * The name of the envelope element.
     */
    public static final String ESB_ELEMENT_ENVELOPE = "Envelope";
    /**
     * The qualified name of the envelope element.
     */
    public static final QName ESB_QNAME_ENVELOPE = new QName(ESB_ELEMENT_ENVELOPE) ;
    /**
     * The name of the header element.
     */
    public static final String ESB_ELEMENT_HEADER = "Header" ;
    /**
     * The qualified name of the header element.
     */
    public static final QName ESB_QNAME_HEADER = new QName(ESB_ELEMENT_HEADER) ;
    /**
     * The name of the context element.
     */
    public static final String ESB_ELEMENT_CONTEXT = "Context" ;
    /**
     * The qualified name of the context element.
     */
    public static final QName ESB_QNAME_CONTEXT = new QName(ESB_ELEMENT_CONTEXT) ;
    /**
     * The name of the body element.
     */
    public static final String ESB_ELEMENT_BODY = "Body" ;
    /**
     * The qualified name of the body element.
     */
    public static final QName ESB_QNAME_BODY = new QName(ESB_ELEMENT_BODY) ;
    /**
     * The name of the body bytes content element.
     */
    public static final String ESB_ELEMENT_BODY_BYTES_CONTENT = "Bytes" ;
    /**
     * The qualified name of the body bytes content element.
     */
    public static final QName ESB_QNAME_BODY_BYTES_CONTENT = new QName(ESB_ELEMENT_BODY_BYTES_CONTENT) ;
    /**
     * The name of the body content element.
     */
    public static final String ESB_ELEMENT_BODY_CONTENT = "Content" ;
    /**
     * The qualified name of the body content element.
     */
    public static final QName ESB_QNAME_BODY_CONTENT = new QName(ESB_ELEMENT_BODY_CONTENT) ;
    /**
     * The name of the body content key element.
     */
    public static final String ESB_ELEMENT_BODY_CONTENT_KEY = "Key" ;
    /**
     * The qualified name of the body content key element.
     */
    public static final QName ESB_QNAME_BODY_CONTENT_KEY = new QName(ESB_ELEMENT_BODY_CONTENT_KEY) ;
    /**
     * The name of the body content value element.
     */
    public static final String ESB_ELEMENT_BODY_CONTENT_VALUE = "Value" ;
    /**
     * The qualified name of the body content value element.
     */
    public static final QName ESB_QNAME_BODY_CONTENT_VALUE = new QName(ESB_ELEMENT_BODY_CONTENT_VALUE) ;
    /**
     * The name of the marshal element.
     */
    public static final String ESB_ELEMENT_BODY_CONTENT_MARSHAL = "marshalunmarshal" ;
    /**
     * The qualified name of the marshal element.
     */
    public static final QName ESB_QNAME_BODY_CONTENT_MARSHAL = new QName(ESB_ELEMENT_BODY_CONTENT_MARSHAL) ;
    /**
     * The name of the marshal type element.
     */
    public static final String ESB_ELEMENT_BODY_CONTENT_MARSHAL_TYPE = "plugin-type" ;
    /**
     * The qualified name of the marshal type element.
     */
    public static final QName ESB_QNAME_BODY_CONTENT_MARSHAL_TYPE = new QName(ESB_ELEMENT_BODY_CONTENT_MARSHAL_TYPE) ;
    /**
     * The name of the attachment element.
     */
    public static final String ESB_ELEMENT_ATTACHMENT = "Attachment" ;
    /**
     * The qualified name of the attachment element.
     */
    public static final QName ESB_QNAME_ATTACHMENT = new QName(ESB_ELEMENT_ATTACHMENT) ;
    /**
     * The name of the unnamed attachment element.
     */
    public static final String ESB_ELEMENT_ATTACHMENT_UNNAMED = "UnNamed" ;
    /**
     * The qualified name of the unnamed attachment element.
     */
    public static final QName ESB_QNAME_ATTACHMENT_UNNAMED = new QName(ESB_ELEMENT_ATTACHMENT_UNNAMED) ;
    /**
     * The name of the named attachment element.
     */
    public static final String ESB_ELEMENT_ATTACHMENT_NAMED = "Named" ;
    /**
     * The qualified name of the named attachment element.
     */
    public static final QName ESB_QNAME_ATTACHMENT_NAMED = new QName(ESB_ELEMENT_ATTACHMENT_NAMED) ;
    /**
     * The name of the properties element.
     */
    public static final String ESB_ELEMENT_PROPERTIES = "Properties" ;
    /**
     * The qualified name of the properties element.
     */
    public static final QName ESB_QNAME_PROPERTIES = new QName(ESB_ELEMENT_PROPERTIES) ;
    /**
     * The name of the property element.
     */
    public static final String ESB_ELEMENT_PROPERTY = "Property" ;
    /**
     * The qualified name of the property element.
     */
    public static final QName ESB_QNAME_PROPERTY = new QName(ESB_ELEMENT_PROPERTY) ;
    /**
     * The name of the property key element.
     */
    public static final String ESB_ELEMENT_PROPERTY_KEY = "Key" ;
    /**
     * The qualified name of the property key element.
     */
    public static final QName ESB_QNAME_PROPERTY_KEY = new QName(ESB_ELEMENT_PROPERTY_KEY) ;
    /**
     * The name of the property value element.
     */
    public static final String ESB_ELEMENT_PROPERTY_VALUE = "Value" ;
    /**
     * The qualified name of the property value element.
     */
    public static final QName ESB_QNAME_PROPERTY_VALUE = new QName(ESB_ELEMENT_PROPERTY_VALUE) ;

    /**
     * The name attribute of the named attachment element.
     */
    public static final String ESB_ATTRIBUTE_ATTACHMENT_NAMED_NAME = "name" ;
    /**
     * The qualified name of the property value element.
     */
    public static final QName ESB_QNAME_ATTRIBUTE_ATTACHMENT_NAMED_NAME = new QName(ESB_ATTRIBUTE_ATTACHMENT_NAMED_NAME) ;
}
