package org.jboss.internal.soa.esb.message.format.serialized;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author mark.little@jboss.com
 */

import java.io.IOException;
import java.io.Serializable;

import javax.xml.stream.XMLStreamException;

import org.jboss.internal.soa.esb.message.format.xml.CallImpl;
import org.jboss.soa.esb.addressing.Call;
import org.jboss.soa.esb.message.Header;

/**
 * The message header. Contains such things as routing information.
 */

public class HeaderImpl implements Header, Serializable
{
	private static final long serialVersionUID = 0x0;
	
	public HeaderImpl ()
	{
		_call = new Call();
	}
	
	// TODO add other setters/getters for artibitrary attributes
	
	public Call getCall ()
	{
		return _call;
	}
	
	public void setCall (Call call)
	{
		if (call == null)
			throw new IllegalArgumentException();
		
		_call = call;
	}

	public String toString ()
	{
		if (_call != null)
			return "header: [ "+_call.toString()+" ]";
		else
			return "header: [  ]";
	}
	
	/*
	 * Call and PortReference aren't Serializable so we have to do some
	 * magic.
	 */
	
	private void writeObject(java.io.ObjectOutputStream out) throws IOException
	{
		if (_call != null)
		{
			try
			{
			    out.writeObject(CallImpl.toXML(_call)) ;
			}
			catch (final XMLStreamException xmlse)
			{
			    final IOException ioe = new IOException("Caught XMLStreamException serialising Call") ;
			    ioe.initCause(xmlse) ;
			    throw ioe ;
			}
		}	
	}
	
	private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException
	{
		try
		{
		    final String header = (String) in.readObject();
		    _call = CallImpl.fromXML(header) ;
		}
		catch (final XMLStreamException xmlse)
		{
                    final IOException ioe = new IOException("Caught XMLStreamException deserialising Call") ;
                    ioe.initCause(xmlse) ;
                    throw ioe ;
		}
	}
	
	private Call _call;
}