package org.jboss.internal.soa.esb.couriers.helpers;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author mark.little@jboss.com
 */

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.addressing.eprs.FileEpr;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.util.FileUtil;
import org.jboss.soa.esb.util.Util;

public class LocalFileHandler implements FileHandler
{
	private LocalFileHandler()
	{
	}

	LocalFileHandler(FileEpr epr)
	{
		_epr = epr;
	}

	public boolean deleteFile(File file) throws CourierException
	{
		return file.delete();
	}

	public byte[] getFileContents(File file) throws CourierException
	{
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		byte[] ba = new byte[1000];  // TODO MAGIC NUMBER
		int iQread;

		try
		{
			FileInputStream inp = new FileInputStream(file);
			while (-1 != (iQread = inp.read(ba)))
				if (iQread > 0)
					out.write(ba, 0, iQread);
			inp.close();
			out.close();
			return out.toByteArray();
		}
		catch (FileNotFoundException e)
		{
			throw new CourierException(e);
		}
		catch (IOException e)
		{
			throw new CourierException(e);
		}
		catch (Exception e)
		{
			throw new CourierException(e);
		}
	}

	public File[] getFileList() throws CourierException
	{
		try
		{
			File dir = new File(_epr.getURL().getFile());
			if (!dir.isDirectory())
				throw new CourierException(
						"Can't get file list if URL is not a directory");

			FileFilter filter = new FileEndsWith(_epr.getInputSuffix());
			return dir.listFiles(filter);
		}
		catch (URISyntaxException e)
		{
			throw new CourierException(e);
		}
		catch (MalformedURLException e)
		{
			throw new CourierException(e);
		}
		catch (Exception e)
		{
			throw new CourierException(e);
		}
	}

	public boolean renameFile(File from, File to) throws CourierException
	{
		try
		{
			if (to.exists())
				to.delete();
			if (!FileUtil.renameTo(from, to))
				throw new CourierException("Unable to rename from " + from
						+ " to " + to);
			
			return true;
		}
		catch (Exception e)
		{
			throw new CourierException(e);
		}
	}

	private class FileEndsWith implements FileFilter
	{
		String m_sSuffix;

		FileEndsWith(String p_sEnd) throws CourierException
		{
			m_sSuffix = p_sEnd;
			if (Util.isNullString(m_sSuffix))
				throw new CourierException(
						"A file suffix (or full Message id) must be specified for pickup");
		} // ______________________________

		public boolean accept(File p_f)
		{
			return (p_f.isFile()) ? p_f.toString().endsWith(m_sSuffix) : false;
		} // ______________________________
	} // ____________________________________________________

	protected FileEpr _epr;

	static Logger _logger = Logger.getLogger(LocalFileHandler.class);
}
