package org.drools.audit;

/*
 * Copyright 2005 JBoss Inc
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.io.ObjectOutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

import org.drools.WorkingMemory;
import org.drools.audit.event.LogEvent;

import com.thoughtworks.xstream.XStream;

/**
 * A logger of events generated by a working memory.
 * It stores its information in memory, so it can be retrieved later.
 * 
 * @author <a href="mailto:kris_verlaenen@hotmail.com">Kris Verlaenen </a>
 */
public class WorkingMemoryInMemoryLogger extends WorkingMemoryLogger {

    private final List events            = new ArrayList();

    /**
     * Creates a new WorkingMemoryInMemoryLogger for the given working memory.
     * @param workingMemory
     */
    public WorkingMemoryInMemoryLogger(final WorkingMemory workingMemory) {
        super( workingMemory );
    }

    public String getEvents() {
        final XStream xstream = new XStream();
        StringWriter writer = new StringWriter();
        try {
            final ObjectOutputStream out = xstream.createObjectOutputStream(writer);
        	out.writeObject( this.events );
            out.close();
        } catch (Throwable t) {
        	throw new RuntimeException("Unable to create event output: " + t.getMessage());
        }
        return writer.toString();
    }

    /**
     * Clears all the events in the log.
     */
    public void clear() {
        this.events.clear();
    }

    /**
     * @see org.drools.audit.WorkingMemoryLogger
     */
    public void logEventCreated(final LogEvent logEvent) {
        this.events.add( logEvent );
    }

}
