#!/bin/sh
# $Id: build.sh 1106 2008-03-12 10:56:35Z jcoleman $
# Build SOA Platform.
# Requires Internet connection
echo SOA Platform Build
echo

echo Setting \$CLASSPATH
unset CLASSPATH
JAR_DIR="`pwd`/build-tools/lib"
if [ ! -d "${JAR_DIR}" ]; then
	echo "Could not find jar file directory: ${JAR_DIR}" >&2
	exit 1
fi
for j in bsf.jar commons-logging-1.1.jar mvel4bsf.jar mvel.jar script-api.jar
do
	if [ a"${CLASSPATH}" = a ]; then
		CLASSPATH="${JAR_DIR}/$j"
	else
		CLASSPATH="${CLASSPATH}:${JAR_DIR}/$j"
	fi
done
export CLASSPATH

echo Setting \$PATH
if [ a"${JAVA_HOME}" = a ]; then
	echo Please set \$JAVA_HOME >&2
	exit 1;
fi
if [ a"${ANT_HOME}" = a ]; then
	echo Please set \$ANT_HOME >&2
	exit 1;
fi
if [ a"${M2_HOME}" = a ]; then
	echo Please set \$M2_HOME >&2
	exit 1;
fi
PATH="$JAVA_HOME/bin:$ANT_HOME/bin:$M2_HOME:$PATH"
MAVEN_OPTS="-Xms256m -Xmx512m"
export MAVEN_OPTS

echo Copying required jars ...
(cd build-tools && ant configure) || exit $?
echo "Building (this may take some time) ..."
(cd build-tools && ant -Dsoa_no_checkout=true build.soa release.zip) || exit $?
echo
echo Release zip files have been created in the build-tools/release directory
