<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@ page session="true" %>
<%@ page import="
	java.io.File,
	java.text.NumberFormat,
	java.text.SimpleDateFormat,
	java.util.List,
	org.hibernate.Session,
	org.hibernate.Transaction,
	org.jboss.soa.esb.monitoring.MonitoringSessionFactory,
	org.jboss.soa.esb.monitoring.pojo.*,
	org.jboss.soa.esb.monitoring.server.StatisticsHelper,
	org.jboss.soa.esb.monitoring.server.TimeSeriesChartProducer,
	org.jfree.data.time.Minute,
	org.jfree.chart.JFreeChart
"%>
<%! 
	private static int imagecounter = 0;
%>
<%
response.setHeader("Cache-Control","no-cache"); //HTTP 1.1
response.setHeader("Pragma","no-cache"); //HTTP 1.0
response.setDateHeader ("Expires", 0); //prevents caching at the proxy server
%>
<html>
<head>
   <META HTTP-EQUIV="PRAGMA" CONTENT="NO-CACHE">
   <title>JBoss ESB Monitoring Console</title>
   <link rel="stylesheet" href="style_master.css" type="text/css">
</head>
<body>
   <table>
      <tr>
         <td><img src="../images/logo.gif" align="left" border="0" alt="JBoss"></td>
         <td valign="middle">         
         <h1>JBoss ESB Management Console</h1>
         </td>
      </tr>
	</table>
	<table cellpadding="5">
      <tr>
      	<td><a href="operations.jsp">Management</a></td>
<td><a href="/jbossesb/index.jsp">Back to Console index</a></td>
    </table>
<hr>
<%
Long id = new Long(request.getParameter("id"));
String servername = request.getParameter("servername");
int maxrecords = 10;
try {
	maxrecords = Integer.parseInt(request.getParameter("maxrecords"));	
} catch (Exception e) {}
int timerange = -1;
try {
	timerange = Integer.parseInt(request.getParameter("timerange"));
} catch (Exception e) {}

Session sess = null;
Transaction tx = null;
try {
	sess = MonitoringSessionFactory.getInstance().openSession();
	tx = sess.beginTransaction();
	
	JMXAttribute jmxa = (JMXAttribute) sess.load(JMXAttribute.class, id);
	
	Integer intId = new Integer(id.intValue());
	List dataList = StatisticsHelper.getData(sess, servername, intId, new Integer(timerange));
	
	String attribute = jmxa.getAttribute();
	int attributeType = StatisticsHelper.getAttributeType(attribute);
		
	TimeSeriesChartProducer tscp = new TimeSeriesChartProducer(attribute, Minute.class);
	JFreeChart jfc = tscp.createChart(attribute);
	
	for (int i = 0; i < dataList.size(); i++) {
		JMXData jmxd = (JMXData) dataList.get(i);
		switch (attributeType) {
			case StatisticsHelper.COUNT_ATTRIBUTE:
			case StatisticsHelper.BYTES_ATTRIBUTE:
				tscp.addMinute(new Minute(jmxd.getStatdate()), jmxd.getCountvalue());
				break;
			case StatisticsHelper.TIME_ATTRIBUTE:
				tscp.addMinute(new Minute(jmxd.getStatdate()), jmxd.getTimevalue());
				break;
			default:
				break;
		}
	}
	
	if ((attributeType == StatisticsHelper.COUNT_ATTRIBUTE)
			|| (attributeType == StatisticsHelper.BYTES_ATTRIBUTE) 
			|| (attributeType == StatisticsHelper.TIME_ATTRIBUTE)) {
	String image = "image-" + session.getId() + "-" + imagecounter++ + ".jpg";
	String realFile = session.getServletContext().getRealPath("") + File.separator 
		+ image;
	File file = new File(realFile);
	tscp.saveChart(attribute, file);
%>
<center>
<img src="/jbossesb/<%=image%>">
</center>
<%
} else {
%>
<h1><code><%=attribute%></code></h1>
<%
}
%><br>
<form action="attribute.jsp">
<b>Selection</b>:  Graph and list records from the last <select name="timerange">
				<option value="5" <%=StatisticsHelper.getSelected(5, timerange)%>>5 minutes
				<option value="60" <%=StatisticsHelper.getSelected(60, timerange)%>>1 hour
				<option value="1440" <%=StatisticsHelper.getSelected(1440, timerange)%>>1 day
				<option value="10080" <%=StatisticsHelper.getSelected(10080, timerange)%>>1 week
				<option value="44640" <%=StatisticsHelper.getSelected(44640, timerange)%>>1 month
				<option value="-1" <%=StatisticsHelper.getSelected(-1, timerange)%>>All
			</select> and the 
list the last <input type="text" name="maxrecords" value="<%=maxrecords%>"> records
		<input type="hidden" name="id" value="<%=id%>">
		<input type="hidden" name="servername" value="<%=servername%>">
		<input type="submit" value="submit">
</form>
<hr>
<center>
<table>
<tr>
<th>Collection Date</th>
<th><%=attribute%></th>
</tr>
<%
NumberFormat nf = NumberFormat.getInstance();
SimpleDateFormat formatter = new SimpleDateFormat("MM-dd HH:mm:ss");
for (int i = dataList.size()-1; (i>=0 && (dataList.size()-i <= maxrecords)); i--) {
	JMXData jmxd = (JMXData) dataList.get(i);

	%>
	<%
	
	switch (attributeType) {
		case StatisticsHelper.COUNT_ATTRIBUTE:
		case StatisticsHelper.BYTES_ATTRIBUTE:
	%>
		<tr>
			<td><%=formatter.format(jmxd.getStatdate())%></td>
			<td align="right"><%=jmxd.getCountvalue()%></td>
		</tr>
	<%		
			break;
		case StatisticsHelper.TIME_ATTRIBUTE:
	%>
		<tr>
			<td><%=formatter.format(jmxd.getStatdate())%></td>
			<td align="right"><%=nf.format(jmxd.getTimevalue())%></td>
		</tr>
	<%
			break;
		default:		
	%>
		<tr>
			<td><%=formatter.format(jmxd.getStatdate())%></td>
			<td align="right"><%=jmxd.getTextvalue()%></td>
		</tr>
	<%
			break;
	}

}
} catch (Exception e) {
	e.printStackTrace();
} finally {
	if (tx.isActive()) {
		tx.rollback();
	} 
	tx = null;
	
	sess.flush();
	sess.close();
	sess = null;
}
%>
</table>
</center>
</body>
</html>
