/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.tests.main;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.mvel.CompiledExpression;
import org.mvel.ExpressionCompiler;
import org.mvel.MVEL;
import org.mvel.ParserContext;
import org.mvel.debug.DebugTools;
import org.mvel.integration.impl.MapVariableResolverFactory;
import org.mvel.optimizers.OptimizerFactory;
import org.mvel.tests.main.res.Bar;
import org.mvel.tests.main.res.Base;
import org.mvel.tests.main.res.DerivedClass;
import org.mvel.tests.main.res.Foo;
import org.mvel.tests.main.res.TestInterface;
import org.mvel.util.StringAppender;

public abstract class AbstractTest
extends TestCase {
    protected Foo foo;
    protected Map<String, Object> map;
    protected Base base;
    protected DerivedClass derived;
    private boolean silentTests = Boolean.getBoolean("mvel.tests.silent");

    public void testNothing() {
    }

    protected void setUp() throws Exception {
        this.foo = new Foo();
        this.map = new HashMap<String, Object>();
        this.base = new Base();
        this.derived = new DerivedClass();
        this.foo.setBar(new Bar());
        this.map.put("foo", this.foo);
        this.map.put("a", null);
        this.map.put("b", null);
        this.map.put("c", "cat");
        this.map.put("BWAH", "");
        this.map.put("misc", new MiscTestClass());
        this.map.put("pi", "3.14");
        this.map.put("hour", "60");
        this.map.put("zero", new Integer(0));
        this.map.put("order", new Order());
        this.map.put("$id", new Integer(20));
        this.map.put("five", new Integer(5));
        this.map.put("testImpl", new TestInterface(){

            public String getName() {
                return "FOOBAR!";
            }

            public boolean isFoo() {
                return true;
            }
        });
        this.map.put("derived", this.derived);
    }

    protected void tearDown() throws Exception {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object test(final String ex) {
        Object last;
        Thread[] threads = Boolean.getBoolean("mvel.tests.quick") ? new Thread[1] : (System.getProperty("mvel.tests.threadcount") != null ? new Thread[Integer.parseInt(System.getProperty("mvel.tests.threadcount"))] : new Thread[5]);
        final AbstractTest aTest = this;
        final LinkedList results = new LinkedList();
        long time = System.currentTimeMillis();
        int i = 0;
        while (i < threads.length) {
            threads[i] = new Thread(){

                public void run() {
                    results.add(aTest.runSingleTest(ex));
                }
            };
            ++i;
        }
        if (!this.silentTests) {
            System.out.println("\n[test] begin test for:\n----------------------");
            System.out.println(ex);
            System.out.println("----------------------");
        }
        Thread[] threadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread1 = threadArray[n2];
            thread1.setPriority(1);
            thread1.run();
            ++n2;
        }
        threadArray = threads;
        n = threads.length;
        n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n2;
        }
        if (!this.silentTests) {
            System.out.println("[test] finished in: " + (System.currentTimeMillis() - time) + "ms (execution count: " + threads.length * 8 + " [mixed modes])");
            System.out.print("[test] analyzing results ... ");
        }
        if ((last = results.getFirst()) != null) {
            Iterator iterator = results.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (!o.equals(last)) {
                    if (!o.getClass().isArray()) throw new AssertionError((Object)("differing result in multi-thread test (last was: " + String.valueOf(last) + "; current is: " + String.valueOf(o) + ")"));
                    Object[] a1 = (Object[])o;
                    Object[] a2 = (Object[])last;
                    if (a1.length != a2.length) throw new AssertionError((Object)"differing result in multi-thread test: array sizes differ.");
                    int i2 = 0;
                    while (i2 < a1.length) {
                        if (!(a1[i2] == null && a2[i2] == null || a1[i2].equals(a2[i2]))) {
                            throw new AssertionError((Object)("differing result in multi-thread test (first array has: " + String.valueOf(last) + "; second has: " + String.valueOf(o) + ")"));
                        }
                        ++i2;
                    }
                }
                last = o;
            }
        }
        if (this.silentTests) return last;
        System.out.println("good!");
        return last;
    }

    protected Object runSingleTest(String ex) {
        return this.test(ex, this.base, this.map);
    }

    protected Object test(String ex, Object base, Map map) {
        CharArrayWriter writer;
        CharArrayWriter writer2;
        CharArrayWriter writer3;
        ExpressionCompiler compiler = new ExpressionCompiler(ex);
        StringAppender failErrors = null;
        CompiledExpression compiled = compiler.compile();
        Object first = null;
        Object second = null;
        Object third = null;
        Object fourth = null;
        Object fifth = null;
        Object sixth = null;
        Object seventh = null;
        Object eighth = null;
        if (!Boolean.getBoolean("mvel.disable.jit")) {
            OptimizerFactory.setDefaultOptimizer("ASM");
            try {
                first = MVEL.executeExpression((Object)compiled, base, map);
            }
            catch (Exception e) {
                failErrors = new StringAppender();
                failErrors.append("\nFIRST TEST: { " + ex + " }: EXCEPTION REPORT: \n\n");
                writer3 = new CharArrayWriter();
                e.printStackTrace(new PrintWriter(writer3));
                failErrors.append(writer3.toCharArray());
            }
            try {
                second = MVEL.executeExpression((Object)compiled, base, map);
            }
            catch (Exception e) {
                if (failErrors == null) {
                    failErrors = new StringAppender();
                }
                failErrors.append("\nSECOND TEST: { " + ex + " }: EXCEPTION REPORT: \n\n");
                writer3 = new CharArrayWriter();
                e.printStackTrace(new PrintWriter(writer3));
                failErrors.append(writer3.toCharArray());
            }
        }
        try {
            third = MVEL.eval(ex, base, map);
        }
        catch (Exception e) {
            if (failErrors == null) {
                failErrors = new StringAppender();
            }
            failErrors.append("\nTHIRD TEST: { " + ex + " }: EXCEPTION REPORT: \n\n");
            writer3 = new CharArrayWriter();
            e.printStackTrace(new PrintWriter(writer3));
            failErrors.append(writer3.toCharArray());
        }
        if (first != null && !first.getClass().isArray()) {
            if (!first.equals(second)) {
                System.out.println(failErrors.toString());
                throw new AssertionError((Object)("Different result from test 1 and 2 (Compiled Re-Run / JIT) [first: " + String.valueOf(first) + "; second: " + String.valueOf(second) + "]"));
            }
            if (!first.equals(third)) {
                if (failErrors != null) {
                    System.out.println(failErrors.toString());
                }
                throw new AssertionError((Object)("Different result from test 1 and 3 (Compiled to Interpreted) [first: " + String.valueOf(first) + " (" + (first != null ? first.getClass().getName() : null) + "); third: " + String.valueOf(third) + " (" + (third != null ? third.getClass().getName() : "null") + ")]"));
            }
        }
        OptimizerFactory.setDefaultOptimizer("reflective");
        Serializable compiled2 = MVEL.compileExpression(ex);
        try {
            fourth = MVEL.executeExpression((Object)compiled2, base, map);
        }
        catch (Exception e) {
            if (failErrors == null) {
                failErrors = new StringAppender();
            }
            failErrors.append("\nFOURTH TEST: { " + ex + " }: EXCEPTION REPORT: \n\n");
            writer2 = new CharArrayWriter();
            e.printStackTrace(new PrintWriter(writer2));
            failErrors.append(writer2.toCharArray());
        }
        try {
            fifth = MVEL.executeExpression((Object)compiled2, base, map);
        }
        catch (Exception e) {
            if (failErrors == null) {
                failErrors = new StringAppender();
            }
            failErrors.append("\nFIFTH TEST: { " + ex + " }: EXCEPTION REPORT: \n\n");
            writer2 = new CharArrayWriter();
            e.printStackTrace(new PrintWriter(writer2));
            failErrors.append(writer2.toCharArray());
        }
        if (fourth != null && !fourth.getClass().isArray() && !fourth.equals(fifth)) {
            throw new AssertionError((Object)("Different result from test 4 and 5 (Compiled Re-Run / Reflective) [first: " + String.valueOf(first) + "; second: " + String.valueOf(second) + "]"));
        }
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("unittest");
        ExpressionCompiler debuggingCompiler = new ExpressionCompiler(ex);
        debuggingCompiler.setDebugSymbols(true);
        CompiledExpression compiledD = debuggingCompiler.compile(ctx);
        try {
            sixth = MVEL.executeExpression((Object)compiledD, base, map);
        }
        catch (Exception e) {
            if (failErrors == null) {
                failErrors = new StringAppender();
            }
            failErrors.append("\nSIXTH TEST: { " + ex + " }: EXCEPTION REPORT: \n\n");
            writer = new CharArrayWriter();
            e.printStackTrace(new PrintWriter(writer));
            failErrors.append(writer.toCharArray());
        }
        if (sixth != null && !sixth.getClass().isArray() && !fifth.equals(sixth)) {
            System.out.println("Payload 1 -- No Symbols: ");
            System.out.println(DebugTools.decompile(compiled));
            System.out.println();
            System.out.println("Payload 2 -- With Symbols: ");
            System.out.println(DebugTools.decompile(compiledD));
            System.out.println();
            throw new AssertionError((Object)("Different result from test 5 and 6 (Compiled to Compiled+DebuggingSymbols) [first: " + String.valueOf(fifth) + "; second: " + String.valueOf(sixth) + "]"));
        }
        try {
            seventh = MVEL.executeExpression((Object)compiledD, base, map);
        }
        catch (Exception e) {
            if (failErrors == null) {
                failErrors = new StringAppender();
            }
            failErrors.append("\nSEVENTH TEST: { " + ex + " }: EXCEPTION REPORT: \n\n");
            writer = new CharArrayWriter();
            e.printStackTrace(new PrintWriter(writer));
            failErrors.append(writer.toCharArray());
        }
        if (seventh != null && !seventh.getClass().isArray() && !seventh.equals(sixth)) {
            throw new AssertionError((Object)("Different result from test 4 and 5 (Compiled Re-Run / Reflective) [first: " + String.valueOf(first) + "; second: " + String.valueOf(second) + "]"));
        }
        try {
            eighth = MVEL.executeExpression(AbstractTest.serializationTest(compiledD), base, new MapVariableResolverFactory(map));
        }
        catch (Exception e) {
            if (failErrors == null) {
                failErrors = new StringAppender();
            }
            failErrors.append("\nEIGHTH TEST (Serializability): { " + ex + " }: EXCEPTION REPORT: \n\n");
            writer = new CharArrayWriter();
            e.printStackTrace(new PrintWriter(writer));
            failErrors.append(writer.toCharArray());
        }
        if (eighth != null && !eighth.getClass().isArray() && !eighth.equals(seventh)) {
            throw new AssertionError((Object)("Different result from test 4 and 5 (Compiled Re-Run / Reflective) [first: " + String.valueOf(first) + "; second: " + String.valueOf(second) + "]"));
        }
        if (failErrors != null) {
            System.out.println(DebugTools.decompile(compiledD));
            throw new AssertionError((Object)("Detailed Failure Report:\n" + failErrors.toString()));
        }
        return fourth;
    }

    protected static Object serializationTest(Serializable s) throws Exception {
        File file = new File("./mvel_ser_test" + System.currentTimeMillis() + Math.round(Math.random() * 1000.0) + ".tmp");
        InputStream inputStream = null;
        ObjectInputStream objectIn = null;
        try {
            file.createNewFile();
            file.deleteOnExit();
            FileOutputStream fileStream = new FileOutputStream(file);
            ObjectOutputStream objectOut = new ObjectOutputStream(new BufferedOutputStream(fileStream));
            objectOut.writeObject(s);
            objectOut.flush();
            fileStream.flush();
            fileStream.close();
            inputStream = new BufferedInputStream(new FileInputStream(file));
            objectIn = new ObjectInputStream(inputStream);
            Object object = objectIn.readObject();
            return object;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (objectIn != null) {
                objectIn.close();
            }
        }
    }

    public static class Address {
        private String street;

        public Address(String street) {
            this.street = street;
        }

        public String getStreet() {
            return this.street;
        }

        public void setStreet(String street) {
            this.street = street;
        }
    }

    public static class Bean {
        private Date myDate = new Date();

        public Date getToday() {
            return new Date();
        }

        public Date getNullDate() {
            return null;
        }

        public String getNullString() {
            return null;
        }

        public Date getMyDate() {
            return this.myDate;
        }

        public void setMyDate(Date myDate) {
            this.myDate = myDate;
        }
    }

    public class ClassA {
        private Integer i;
        private double d;
        private String s;
        public Date date;
        private BigDecimal bigdec;
        private BigInteger bigint;

        public Integer getI() {
            return this.i;
        }

        public void setI(Integer i) {
            this.i = i;
        }

        public double getD() {
            return this.d;
        }

        public void setD(double d) {
            this.d = d;
        }

        public String getS() {
            return this.s;
        }

        public void setS(String s) {
            this.s = s;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public BigDecimal getBigdec() {
            return this.bigdec;
        }

        public void setBigdec(BigDecimal bigdec) {
            this.bigdec = bigdec;
        }

        public BigInteger getBigint() {
            return this.bigint;
        }

        public void setBigint(BigInteger bigint) {
            this.bigint = bigint;
        }
    }

    public class ClassB {
        private Integer i;
        private double d;
        private String s;
        public String date;
        private BigDecimal bigdec;
        private BigInteger bigint;

        public Integer getI() {
            return this.i;
        }

        public void setI(Integer i) {
            this.i = i;
        }

        public double getD() {
            return this.d;
        }

        public void setD(double d) {
            this.d = d;
        }

        public String getS() {
            return this.s;
        }

        public void setS(String s) {
            this.s = s;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public BigDecimal getBigdec() {
            return this.bigdec;
        }

        public void setBigdec(BigDecimal bigdec) {
            this.bigdec = bigdec;
        }

        public BigInteger getBigint() {
            return this.bigint;
        }

        public void setBigint(BigInteger bigint) {
            this.bigint = bigint;
        }
    }

    public static class Context {
        private final SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yy");
        private Bean bean;

        public Bean getBean() {
            return this.bean;
        }

        public void setBean(Bean bean) {
            this.bean = bean;
        }

        public String formatDate(Date date) {
            return date == null ? null : this.dateFormat.format(date);
        }

        public String formatString(String str) {
            return str == null ? "<NULL>" : str;
        }
    }

    public static class Drools {
        public void insert(Object obj) {
        }
    }

    public static class Item {
        private String name;

        public Item(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class Message {
        public static final int HELLO = 0;
        public static final int GOODBYE = 1;
        private List items = new ArrayList();
        private String message;
        private int status;

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public void addItem(Item item) {
            this.items.add(item);
        }

        public List getItems() {
            return this.items;
        }
    }

    public static class MiscTestClass {
        int exec = 0;

        public List toList(Object object1, String string, int integer, Map map, List list) {
            ++this.exec;
            ArrayList<Object> l = new ArrayList<Object>();
            l.add(object1);
            l.add(string);
            l.add(new Integer(integer));
            l.add(map);
            l.add(list);
            return l;
        }

        public int getExec() {
            return this.exec;
        }
    }

    public static class Model {
        private List latestHeadlines;

        public List getLatestHeadlines() {
            return this.latestHeadlines;
        }

        public void setLatestHeadlines(List latestHeadlines) {
            this.latestHeadlines = latestHeadlines;
        }
    }

    public static class Order {
        private int number = 20;

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }
    }

    public static class Person {
        private String name;
        private int age;

        public Person() {
        }

        public Person(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }
    }
}

