/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import org.jboss.seam.ui.PrioritizableConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterChain
implements Converter,
StateHolder {
    public static final String CONTINUE = "org.jboss.seam.ui.ConverterChain.continue";
    public static final int CHAIN_END = Integer.MAX_VALUE;
    public static final int CHAIN_START = 0;
    private List<PrioritizableConverter> converters = new ArrayList<PrioritizableConverter>();
    private boolean dirty;
    private boolean _transient;

    public ConverterChain() {
    }

    public ConverterChain(UIComponent component) {
        this();
        ValueHolder valueHolder;
        if (component instanceof ValueHolder && !((valueHolder = (ValueHolder)component).getConverter() instanceof ConverterChain)) {
            ValueBinding converterValueBinding = component.getValueBinding("converter");
            if (converterValueBinding != null) {
                this.addConverterToChain(converterValueBinding);
            } else if (valueHolder.getConverter() != null) {
                this.addConverterToChain(valueHolder.getConverter());
            } else {
                ValueBinding valueBinding = component.getValueBinding("value");
                FacesContext facesContext = FacesContext.getCurrentInstance();
                if (valueBinding != null) {
                    this.addConverterToChain(facesContext.getApplication().createConverter(valueBinding.getType(facesContext)));
                }
            }
            valueHolder.setConverter((Converter)this);
        }
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        Object output = null;
        for (PrioritizableConverter converter : this.getConverters()) {
            Object result = converter.getAsObject(context, component, value);
            if (CONTINUE.equals(result)) continue;
            output = result;
            break;
        }
        return output;
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        String output = null;
        for (PrioritizableConverter converter : this.getConverters()) {
            String result = converter.getAsString(context, component, value);
            if (CONTINUE.equals(result)) continue;
            output = result;
            break;
        }
        return output;
    }

    public boolean addConverterToChain(Converter c) {
        return this.addConverterToChain(c, Integer.MAX_VALUE);
    }

    public boolean addConverterToChain(ValueBinding c) {
        return this.addConverterToChain(c, Integer.MAX_VALUE);
    }

    public boolean addConverterToChain(Converter c, int priority) {
        if (c != null) {
            this.dirty = true;
            return this.converters.add(new PrioritizableConverter(c, priority));
        }
        return false;
    }

    public boolean addConverterToChain(ValueBinding c, int priority) {
        if (c != null) {
            this.dirty = true;
            return this.converters.add(new PrioritizableConverter(c, priority));
        }
        return false;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.converters = (List)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)values[0]);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{UIComponentBase.saveAttachedState((FacesContext)context, this.converters)};
        return values;
    }

    public void setTransient(boolean newTransientValue) {
        this._transient = newTransientValue;
    }

    private List<PrioritizableConverter> getConverters() {
        if (this.dirty) {
            Collections.sort(this.converters);
        }
        return this.converters;
    }

    public boolean containsConverterType(Converter converter) {
        for (PrioritizableConverter c : this.converters) {
            if (!c.getClass().equals(converter)) continue;
            return true;
        }
        return false;
    }
}

