/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.milyn.io.StreamUtils;
import org.milyn.xml.HTMLEntityLookup;
import org.milyn.xml.LocalDTDEntityResolver;
import org.milyn.xml.LocalXSDEntityResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlUtil {
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static String ELEMENT_NAME_FUNC = "/name()";
    private static XPathFactory xPathFactory = XPathFactory.newInstance();

    public static void removeEntities(Reader reader, Writer writer) throws IOException {
        int curChar = -1;
        StringBuffer ent = null;
        if (reader == null) {
            throw new IllegalArgumentException("null reader arg");
        }
        if (writer == null) {
            throw new IllegalArgumentException("null writer arg");
        }
        ent = new StringBuffer(50);
        while ((curChar = reader.read()) != -1) {
            if (curChar == 38) {
                if (ent.length() > 0) {
                    writer.write(ent.toString());
                    ent.setLength(0);
                }
                ent.append((char)curChar);
                continue;
            }
            if (curChar == 59 && ent.length() > 0) {
                block21: {
                    int entLen = ent.length();
                    if (entLen > 1) {
                        if (ent.charAt(1) == '#') {
                            if (entLen > 2) {
                                char char2 = ent.charAt(2);
                                try {
                                    if (char2 == 'x' || char2 == 'X') {
                                        if (entLen > 3) {
                                            writer.write(Integer.parseInt(ent.substring(3), 16));
                                        } else {
                                            writer.write(ent.toString());
                                            writer.write(curChar);
                                        }
                                        break block21;
                                    }
                                    writer.write(Integer.parseInt(ent.substring(2)));
                                }
                                catch (NumberFormatException nfe) {
                                    writer.write(ent.toString());
                                    writer.write(curChar);
                                }
                            } else {
                                writer.write("&#;");
                            }
                        } else {
                            Character character = HTMLEntityLookup.getCharacterCode(ent.substring(1));
                            if (character != null) {
                                writer.write(character.charValue());
                            } else {
                                writer.write(ent.toString());
                                writer.write(curChar);
                            }
                        }
                    } else {
                        writer.write("&;");
                    }
                }
                ent.setLength(0);
                continue;
            }
            if (ent.length() > 0) {
                ent.append((char)curChar);
                continue;
            }
            writer.write(curChar);
        }
        if (ent.length() > 0) {
            writer.write(ent.toString());
        }
    }

    public static String removeEntities(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null string arg");
        }
        try {
            StringReader reader = new StringReader(string);
            StringWriter writer = new StringWriter();
            XmlUtil.removeEntities(reader, writer);
            return writer.toString();
        }
        catch (Exception excep) {
            excep.printStackTrace();
            return string;
        }
    }

    public static void rewriteEntities(Reader reader, Writer writer) throws IOException {
        int curChar = -1;
        if (reader == null) {
            throw new IllegalArgumentException("null reader arg");
        }
        if (writer == null) {
            throw new IllegalArgumentException("null writer arg");
        }
        StringBuffer ent = new StringBuffer(50);
        char[] entBuf = new char[50];
        while ((curChar = reader.read()) != -1) {
            if (curChar == 38) {
                if (ent.length() > 0) {
                    writer.write(ent.toString());
                    ent.setLength(0);
                }
                ent.append((char)curChar);
                continue;
            }
            if (curChar == 59 && ent.length() > 0) {
                int entLen = ent.length();
                if (entLen > 1) {
                    if (ent.charAt(1) == '#') {
                        ent.getChars(0, ent.length(), entBuf, 0);
                        writer.write(entBuf, 0, ent.length());
                        writer.write(59);
                    } else {
                        Character character = HTMLEntityLookup.getCharacterCode(ent.substring(1));
                        if (character != null) {
                            writer.write("&#");
                            writer.write(String.valueOf((int)character.charValue()));
                            writer.write(";");
                        } else {
                            writer.write(ent.toString());
                            writer.write(curChar);
                        }
                    }
                } else {
                    writer.write("&;");
                }
                ent.setLength(0);
                continue;
            }
            if (ent.length() > 0) {
                ent.append((char)curChar);
                continue;
            }
            writer.write(curChar);
        }
        if (ent.length() > 0) {
            writer.write(ent.toString());
        }
    }

    public static Document parseStream(InputStream stream, VALIDATION_TYPE validation, boolean expandEntityRefs) throws SAXException, IOException {
        return XmlUtil.parseStream(stream, new LocalDTDEntityResolver(), validation, expandEntityRefs);
    }

    public static Document parseStream(InputStream stream, EntityResolver entityResolver, VALIDATION_TYPE validation, boolean expandEntityRefs) throws SAXException, IOException {
        if (stream == null) {
            throw new IllegalArgumentException("null 'stream' arg in method call.");
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = null;
            if (validation == VALIDATION_TYPE.DTD) {
                factory.setValidating(true);
            } else if (validation == VALIDATION_TYPE.XSD) {
                try {
                    Schema schema = XmlUtil.getSchema(entityResolver);
                    stream = new ByteArrayInputStream(StreamUtils.readStream(stream));
                    schema.newValidator().validate(new StreamSource(stream));
                    stream.reset();
                }
                catch (IllegalArgumentException e) {
                    throw new SAXException("Unable to validate document.  Installed parser '" + factory.getClass().getName() + "' doesn't support JAXP 1.2", e);
                }
            }
            factory.setExpandEntityReferences(expandEntityRefs);
            docBuilder = factory.newDocumentBuilder();
            if (validation == VALIDATION_TYPE.DTD) {
                docBuilder.setEntityResolver(entityResolver);
            }
            docBuilder.setErrorHandler(XMLParseErrorHandler.getInstance());
            return docBuilder.parse(stream);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to parse XML stream - XML Parser not configured correctly.", e);
        }
        catch (FactoryConfigurationError e) {
            throw new IllegalStateException("Unable to parse XML stream - DocumentBuilderFactory not configured correctly.", e);
        }
    }

    private static Schema getSchema(EntityResolver entityResolver) throws SAXException, IOException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance(W3C_XML_SCHEMA);
        if (entityResolver instanceof LocalXSDEntityResolver) {
            return schemaFactory.newSchema(((LocalXSDEntityResolver)entityResolver).getSchemaSources());
        }
        return schemaFactory.newSchema(new StreamSource(entityResolver.resolveEntity("default", "default").getByteStream()));
    }

    public static NodeList getNodeList(Node node, String xpath) {
        if (node == null) {
            throw new IllegalArgumentException("null 'document' arg in method call.");
        }
        if (xpath == null) {
            throw new IllegalArgumentException("null 'xpath' arg in method call.");
        }
        try {
            XPath xpathEvaluater = xPathFactory.newXPath();
            if (xpath.endsWith(ELEMENT_NAME_FUNC)) {
                return (NodeList)xpathEvaluater.evaluate(xpath.substring(0, xpath.length() - ELEMENT_NAME_FUNC.length()), node, XPathConstants.NODESET);
            }
            return (NodeList)xpathEvaluater.evaluate(xpath, node, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException("bad 'xpath' expression [" + xpath + "].");
        }
    }

    public static Node getNode(Node node, String xpath) {
        NodeList nodeList = XmlUtil.getNodeList(node, xpath);
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        return nodeList.item(0);
    }

    public static String getString(Node node, String xpath) {
        NodeList nodeList = XmlUtil.getNodeList(node, xpath);
        if (nodeList == null || nodeList.getLength() == 0) {
            return "";
        }
        if (xpath.endsWith(ELEMENT_NAME_FUNC)) {
            if (nodeList.getLength() > 0) {
                return nodeList.item(0).getNodeName();
            }
            return "";
        }
        return XmlUtil.serialize(nodeList);
    }

    public static String serialize(NodeList nodeList) throws DOMException {
        return XmlUtil.serialize(nodeList, false);
    }

    public static String serialize(NodeList nodeList, boolean format) throws DOMException {
        if (nodeList == null) {
            throw new IllegalArgumentException("null 'subtree' NodeIterator arg in method call.");
        }
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            if (format) {
                try {
                    factory.setAttribute("indent-number", new Integer(4));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            if (format) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
            }
            StringWriter writer = new StringWriter();
            int listLength = nodeList.getLength();
            for (int i = 0; i < listLength; ++i) {
                Node node = nodeList.item(i);
                if (XmlUtil.isTextNode(node)) {
                    writer.write(node.getNodeValue());
                    continue;
                }
                if (node.getNodeType() == 2) {
                    writer.write(((Attr)node).getValue());
                    continue;
                }
                if (node.getNodeType() != 1) continue;
                transformer.transform(new DOMSource(node), new StreamResult(writer));
            }
            return writer.toString();
        }
        catch (Exception e) {
            DOMException domExcep = new DOMException(15, "Unable to serailise DOM subtree.");
            domExcep.initCause(e);
            throw domExcep;
        }
    }

    public static boolean isTextNode(Node node) {
        if (node == null) {
            return false;
        }
        short nodeType = node.getNodeType();
        return nodeType == 4 || nodeType == 3;
    }

    static class XMLParseErrorHandler
    implements ErrorHandler {
        private static XMLParseErrorHandler singleton = new XMLParseErrorHandler();

        private XMLParseErrorHandler() {
        }

        private static XMLParseErrorHandler getInstance() {
            return singleton;
        }

        public void warning(SAXParseException arg0) throws SAXException {
            throw arg0;
        }

        public void error(SAXParseException arg0) throws SAXException {
            throw arg0;
        }

        public void fatalError(SAXParseException arg0) throws SAXException {
            throw arg0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VALIDATION_TYPE {
        NONE,
        DTD,
        XSD;

    }
}

