/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

public class RspListTest
extends TestCase {
    RspList rl;
    Address a1;
    Address a2;
    Address a3;
    Address a4;
    Address a5;
    Rsp rsp1;
    Rsp rsp2;
    Rsp rsp3;
    Rsp rsp4;
    Rsp rsp5;

    public RspListTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.rl = new RspList();
        this.a1 = new IpAddress(1111);
        this.a2 = new IpAddress(2222);
        this.a3 = new IpAddress(3333);
        this.a4 = new IpAddress(4444);
        this.a5 = new IpAddress(5555);
        this.rsp1 = new Rsp(this.a1);
        this.rsp2 = new Rsp(this.a2, true);
        this.rsp3 = new Rsp(this.a3, "hello world");
        this.rsp4 = new Rsp(this.a4, Boolean.TRUE);
        this.rsp5 = new Rsp(this.a5, true);
        this.rl.put(this.a1, this.rsp1);
        this.rl.put(this.a2, this.rsp2);
        this.rl.put(this.a3, this.rsp3);
        this.rl.put(this.a4, this.rsp4);
        this.rl.put(this.a5, this.rsp5);
    }

    protected void tearDown() throws Exception {
        this.rl.clear();
        super.tearDown();
    }

    public void testConstructor() {
        LinkedList<Rsp> c = new LinkedList<Rsp>();
        c.add(this.rsp1);
        c.add(this.rsp2);
        c.add(this.rsp3);
        RspList tmp = new RspList(c);
        RspListTest.assertEquals((int)c.size(), (int)tmp.size());
        RspListTest.assertTrue((boolean)tmp.containsKey(this.a1));
        RspListTest.assertTrue((boolean)tmp.containsKey(this.a2));
        RspListTest.assertTrue((boolean)tmp.containsKey(this.a3));
        RspListTest.assertTrue((boolean)tmp.containsValue(this.rsp1));
        RspListTest.assertTrue((boolean)tmp.containsValue(this.rsp2));
        RspListTest.assertTrue((boolean)tmp.containsValue(this.rsp3));
    }

    public void testIsEmpty() {
        RspList tmp = new RspList();
        RspListTest.assertTrue((boolean)tmp.isEmpty());
        tmp.addRsp(this.a1, this.rsp1);
        RspListTest.assertFalse((boolean)tmp.isEmpty());
    }

    public void testContainsKey() {
        RspListTest.assertTrue((boolean)this.rl.containsKey(this.a1));
        RspListTest.assertTrue((boolean)this.rl.containsKey(this.a3));
    }

    public void testContainsValue() {
        RspListTest.assertTrue((boolean)this.rl.containsValue(this.rsp1));
        RspListTest.assertTrue((boolean)this.rl.containsValue(this.rsp3));
    }

    public void testGet() {
        Rsp rsp = (Rsp)this.rl.get(this.a1);
        RspListTest.assertEquals((Object)rsp, (Object)this.rsp1);
        rsp = (Rsp)this.rl.get(this.a3);
        RspListTest.assertEquals((Object)rsp, (Object)this.rsp3);
    }

    public void testPut() {
        Rsp rsp = (Rsp)this.rl.put(new IpAddress(6666), new Rsp((Address)new IpAddress(6666), true));
        RspListTest.assertNull((Object)rsp);
        rsp = (Rsp)this.rl.put(this.a2, this.rsp2);
        RspListTest.assertEquals((Object)rsp, (Object)this.rsp2);
        RspListTest.assertEquals((int)6, (int)this.rl.size());
    }

    public void testRemove() {
        Rsp rsp = (Rsp)this.rl.remove(new IpAddress(6666));
        RspListTest.assertNull((Object)rsp);
        rsp = (Rsp)this.rl.remove(this.a2);
        RspListTest.assertEquals((Object)rsp, (Object)this.rsp2);
        RspListTest.assertEquals((int)4, (int)this.rl.size());
    }

    public void testClear() {
        this.rl.clear();
        RspListTest.assertEquals((int)0, (int)this.rl.size());
    }

    public void testKeySet() {
        RspList tmp = new RspList();
        Set keys = tmp.keySet();
        RspListTest.assertNotNull((Object)keys);
        RspListTest.assertEquals((int)0, (int)keys.size());
    }

    public void testKeySet2() {
        Set keys = this.rl.keySet();
        RspListTest.assertNotNull((Object)keys);
        RspListTest.assertEquals((int)this.rl.size(), (int)keys.size());
    }

    public void testAddRsp() {
        this.rl.addRsp(new IpAddress(6666), new Integer(322649));
        RspListTest.assertEquals((int)6, (int)this.rl.size());
        Rsp rsp = (Rsp)this.rl.get(new IpAddress(6666));
        RspListTest.assertNotNull((Object)rsp);
        RspListTest.assertTrue((boolean)rsp.wasReceived());
        RspListTest.assertFalse((boolean)rsp.wasSuspected());
        RspListTest.assertEquals((Object)new Integer(322649), (Object)rsp.getValue());
    }

    public void testAddRsp2() {
        this.rl.addRsp(this.a1, new Integer(322649));
        RspListTest.assertEquals((int)5, (int)this.rl.size());
        Rsp rsp = (Rsp)this.rl.get(this.a1);
        RspListTest.assertNotNull((Object)rsp);
        RspListTest.assertTrue((boolean)rsp.wasReceived());
        RspListTest.assertFalse((boolean)rsp.wasSuspected());
        RspListTest.assertEquals((Object)new Integer(322649), (Object)rsp.getValue());
    }

    public void testNumSuspectedMembers() {
        RspListTest.assertEquals((int)2, (int)this.rl.numSuspectedMembers());
    }

    public void testGetFirst() {
        Object obj = this.rl.getFirst();
        System.out.println("-- first (non-null) value is " + obj);
        RspListTest.assertNotNull((Object)obj);
    }

    public void testGetResults() {
        Vector v = this.rl.getResults();
        RspListTest.assertNotNull((Object)v);
        RspListTest.assertEquals((int)2, (int)v.size());
    }

    public void testElementAt() {
        HashSet<Address> s = new HashSet<Address>();
        for (int i = 0; i < this.rl.size(); ++i) {
            Rsp rsp = (Rsp)this.rl.elementAt(i);
            s.add(rsp.getSender());
        }
        System.out.println("-- set is " + s);
        RspListTest.assertEquals((int)this.rl.size(), (int)s.size());
    }

    public void testElementAtWithOOBEx() {
        try {
            this.rl.elementAt(6);
            RspListTest.fail((String)"this should have thrown an ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public static Test suite() {
        return new TestSuite(RspListTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RspListTest.suite());
    }
}

