/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.HashMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Message;

public class AckReceiverWindow {
    long next_to_remove = 0L;
    final HashMap msgs = new HashMap();
    static final Log log = LogFactory.getLog((Class)AckReceiverWindow.class);

    public AckReceiverWindow(long initial_seqno) {
        this.next_to_remove = initial_seqno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long seqno, Message msg) {
        if (msg == null) {
            throw new IllegalArgumentException("msg must be non-null");
        }
        HashMap hashMap = this.msgs;
        synchronized (hashMap) {
            if (seqno < this.next_to_remove) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("discarded msg with seqno=" + seqno + " (next msg to receive is " + this.next_to_remove + ')'));
                }
                return;
            }
            Long seq = new Long(seqno);
            if (!this.msgs.containsKey(seq)) {
                this.msgs.put(seq, msg);
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("seqno " + seqno + " already received - dropping it"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message remove() {
        Message retval;
        HashMap hashMap = this.msgs;
        synchronized (hashMap) {
            Long key = new Long(this.next_to_remove);
            retval = (Message)this.msgs.remove(key);
            if (retval != null) {
                ++this.next_to_remove;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("removed seqno=" + key));
                }
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        HashMap hashMap = this.msgs;
        synchronized (hashMap) {
            this.msgs.clear();
        }
    }

    public int size() {
        return this.msgs.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.msgs.size()).append(" msgs (").append("next=").append(this.next_to_remove).append(")");
        TreeSet s = new TreeSet(this.msgs.keySet());
        if (!s.isEmpty()) {
            sb.append(" [").append(s.first()).append(" - ").append(s.last()).append("]");
        }
        return sb.toString();
    }

    public String printDetails() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.msgs.size()).append(" msgs (").append("next=").append(this.next_to_remove).append(")").append(", msgs=").append(new TreeSet(this.msgs.keySet()));
        return sb.toString();
    }
}

