/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import EDU.oswego.cs.dl.util.concurrent.CondVar;
import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.stack.Protocol;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class FC
extends Protocol {
    final Map sent = new HashMap(11);
    final Map received = new ConcurrentReaderHashMap(11);
    final List creditors = new ArrayList(11);
    final Set pending_requesters = new HashSet(11);
    private long max_credits = 500000L;
    private Long max_credits_constant = new Long(this.max_credits);
    private long max_block_time = 5000L;
    private double min_threshold = 0.25;
    private long min_credits = 0L;
    private boolean running = true;
    private boolean insufficient_credit = false;
    private long lowest_credit = this.max_credits;
    final Sync lock = new ReentrantLock();
    final CondVar mutex = new CondVar(this.lock);
    private boolean ignore_synchronous_response = true;
    private Thread ignore_thread;
    static final String name = "FC";
    private long start_blocking = 0L;
    private final Map last_credit_request = new ConcurrentHashMap();
    private int num_blockings = 0;
    private int num_credit_requests_received = 0;
    private int num_credit_requests_sent = 0;
    private int num_credit_responses_sent = 0;
    private int num_credit_responses_received = 0;
    private long total_time_blocking = 0L;
    final BoundedList last_blockings = new BoundedList(50);
    static final FcHeader REPLENISH_HDR = new FcHeader(1);
    static final FcHeader CREDIT_REQUEST_HDR = new FcHeader(2);

    public final String getName() {
        return name;
    }

    public void resetStats() {
        super.resetStats();
        this.num_blockings = 0;
        this.num_credit_requests_sent = 0;
        this.num_credit_requests_received = 0;
        this.num_credit_responses_received = 0;
        this.num_credit_responses_sent = 0;
        this.total_time_blocking = 0L;
        this.last_blockings.removeAll();
    }

    public long getMaxCredits() {
        return this.max_credits;
    }

    public void setMaxCredits(long max_credits) {
        this.max_credits = max_credits;
        this.max_credits_constant = new Long(this.max_credits);
    }

    public double getMinThreshold() {
        return this.min_threshold;
    }

    public void setMinThreshold(double min_threshold) {
        this.min_threshold = min_threshold;
    }

    public long getMinCredits() {
        return this.min_credits;
    }

    public void setMinCredits(long min_credits) {
        this.min_credits = min_credits;
    }

    public boolean isBlocked() {
        return this.insufficient_credit;
    }

    public int getNumberOfBlockings() {
        return this.num_blockings;
    }

    public long getMaxBlockTime() {
        return this.max_block_time;
    }

    public void setMaxBlockTime(long t) {
        this.max_block_time = t;
    }

    public long getTotalTimeBlocked() {
        return this.total_time_blocking;
    }

    public double getAverageTimeBlocked() {
        return this.num_blockings == 0 ? 0.0 : (double)this.total_time_blocking / (double)this.num_blockings;
    }

    public int getNumberOfCreditRequestsReceived() {
        return this.num_credit_requests_received;
    }

    public int getNumberOfCreditRequestsSent() {
        return this.num_credit_requests_sent;
    }

    public int getNumberOfCreditResponsesReceived() {
        return this.num_credit_responses_received;
    }

    public int getNumberOfCreditResponsesSent() {
        return this.num_credit_responses_sent;
    }

    public String printSenderCredits() {
        return FC.printMap(this.sent);
    }

    public String printReceiverCredits() {
        return FC.printMap(this.received);
    }

    public String printCredits() {
        StringBuffer sb = new StringBuffer();
        sb.append("senders:\n").append(FC.printMap(this.sent)).append("\n\nreceivers:\n").append(FC.printMap(this.received));
        return sb.toString();
    }

    public Map dumpStats() {
        HashMap<String, String> retval = super.dumpStats();
        if (retval == null) {
            retval = new HashMap<String, String>();
        }
        retval.put("senders", FC.printMap(this.sent));
        retval.put("receivers", FC.printMap(this.received));
        retval.put("num_blockings", (String)((Object)new Integer(this.num_blockings)));
        retval.put("avg_time_blocked", (String)((Object)new Double(this.getAverageTimeBlocked())));
        retval.put("num_replenishments", (String)((Object)new Integer(this.num_credit_responses_received)));
        retval.put("total_time_blocked", (String)((Object)new Long(this.total_time_blocking)));
        return retval;
    }

    public String showLastBlockingTimes() {
        return this.last_blockings.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblock() {
        if (Util.acquire(this.lock)) {
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("unblocking the sender and replenishing all members, creditors are " + this.creditors));
                }
                Iterator it = this.sent.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    entry.setValue(this.max_credits_constant);
                }
                this.lowest_credit = FC.computeLowestCredit(this.sent);
                this.creditors.clear();
                this.insufficient_credit = false;
                this.mutex.broadcast();
            }
            finally {
                Util.release(this.lock);
            }
        }
    }

    public boolean setProperties(Properties props) {
        boolean min_credits_set = false;
        super.setProperties(props);
        String str = props.getProperty("max_credits");
        if (str != null) {
            this.max_credits = Long.parseLong(str);
            props.remove("max_credits");
        }
        if ((str = props.getProperty("min_threshold")) != null) {
            this.min_threshold = Double.parseDouble(str);
            props.remove("min_threshold");
        }
        if ((str = props.getProperty("min_credits")) != null) {
            this.min_credits = Long.parseLong(str);
            props.remove("min_credits");
            min_credits_set = true;
        }
        if (!min_credits_set) {
            this.min_credits = (long)((double)this.max_credits * this.min_threshold);
        }
        if ((str = props.getProperty("max_block_time")) != null) {
            this.max_block_time = Long.parseLong(str);
            props.remove("max_block_time");
        }
        if ((str = props.getProperty("ignore_synchronous_response")) != null) {
            this.ignore_synchronous_response = Boolean.valueOf(str);
            props.remove("ignore_synchronous_response");
        }
        if (!props.isEmpty()) {
            this.log.error((Object)("the following properties are not recognized: " + props));
            return false;
        }
        this.max_credits_constant = new Long(this.max_credits);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        super.start();
        this.lock.acquire();
        try {
            this.running = true;
            this.insufficient_credit = false;
            this.lowest_credit = this.max_credits;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        super.stop();
        if (Util.acquire(this.lock)) {
            try {
                this.running = false;
                this.ignore_thread = null;
                this.mutex.broadcast();
            }
            finally {
                Util.release(this.lock);
            }
        }
    }

    protected void receiveDownEvent(Event evt) {
        if (evt.getType() == 6) {
            View v = (View)evt.getArg();
            Vector mbrs = v.getMembers();
            this.handleViewChange(mbrs);
        }
        super.receiveDownEvent(evt);
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                this.handleDownMessage(evt);
                return;
            }
        }
        this.passDown(evt);
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg;
                FcHeader hdr;
                if (this.ignore_thread == null && this.ignore_synchronous_response) {
                    this.ignore_thread = Thread.currentThread();
                }
                if ((hdr = (FcHeader)(msg = (Message)evt.getArg()).removeHeader(name)) != null) {
                    switch (hdr.type) {
                        case 1: {
                            ++this.num_credit_responses_received;
                            this.handleCredit(msg.getSrc(), (Number)msg.getObject());
                            break;
                        }
                        case 2: {
                            ++this.num_credit_requests_received;
                            Address sender = msg.getSrc();
                            Long sent_credits = (Long)msg.getObject();
                            this.handleCreditRequest(sender, sent_credits);
                            break;
                        }
                        default: {
                            this.log.error((Object)("header type " + hdr.type + " not known"));
                        }
                    }
                    return;
                }
                this.adjustCredit(msg);
                break;
            }
            case 6: {
                this.handleViewChange(((View)evt.getArg()).getMembers());
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDownMessage(Event evt) {
        Message msg = (Message)evt.getArg();
        int length = msg.getLength();
        Address dest = msg.getDest();
        if (Util.acquire(this.lock)) {
            try {
                long tmp;
                if (this.lowest_credit <= (long)length) {
                    if (this.ignore_synchronous_response && this.ignore_thread == Thread.currentThread()) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("Bypassing blocking to avoid deadlocking " + Thread.currentThread()));
                        }
                    } else {
                        this.determineCreditors(dest, length);
                        long blockStart = System.currentTimeMillis();
                        if (!this.insufficient_credit) {
                            this.insufficient_credit = true;
                            this.start_blocking = blockStart;
                            if (this.log.isTraceEnabled()) {
                                this.log.trace((Object)("Starting blocking. lowest_credit=" + this.lowest_credit + "; msg length =" + length));
                            }
                        }
                        ++this.num_blockings;
                        while (this.insufficient_credit && this.running) {
                            try {
                                this.mutex.timedwait(this.max_block_time);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            if (!this.insufficient_credit || !this.running) continue;
                            long waitTime = System.currentTimeMillis() - blockStart;
                            if (this.log.isTraceEnabled()) {
                                this.log.trace((Object)("Still waiting for credits -- waiting " + waitTime + " ms"));
                            }
                            if (waitTime < this.max_block_time) continue;
                            this.determineCreditors(dest, length);
                            HashMap sent_copy = new HashMap(this.sent);
                            sent_copy.keySet().retainAll(this.creditors);
                            Util.release(this.lock);
                            try {
                                Iterator it = sent_copy.entrySet().iterator();
                                while (it.hasNext()) {
                                    Map.Entry e = it.next();
                                    this.sendCreditRequest((Address)e.getKey(), (Long)e.getValue());
                                }
                            }
                            finally {
                                Util.acquire(this.lock);
                            }
                        }
                        long block_time = System.currentTimeMillis() - blockStart;
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("total time blocked: " + block_time + " ms"));
                        }
                        this.total_time_blocking += block_time;
                        this.last_blockings.add(new Long(block_time));
                    }
                }
                if ((tmp = this.decrementCredit(this.sent, dest, length)) != -1L) {
                    this.lowest_credit = Math.min(tmp, this.lowest_credit);
                }
            }
            finally {
                Util.release(this.lock);
            }
        }
        this.passDown(evt);
    }

    private void determineCreditors(Address dest, int length) {
        boolean multicast;
        boolean bl = multicast = dest == null || dest.isMulticastAddress();
        if (multicast) {
            Iterator it = this.sent.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Address mbr = (Address)entry.getKey();
                Long credits = (Long)entry.getValue();
                if (credits > (long)length || this.creditors.contains(mbr)) continue;
                this.creditors.add(mbr);
            }
        } else {
            Long credits = (Long)this.sent.get(dest);
            if (credits != null && credits <= (long)length && !this.creditors.contains(dest)) {
                this.creditors.add(dest);
            }
        }
    }

    private long decrementCredit(Map m, Address dest, long credits) {
        boolean multicast = dest == null || dest.isMulticastAddress();
        long lowest = this.max_credits;
        if (multicast) {
            if (m.isEmpty()) {
                return -1L;
            }
            Iterator it = m.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Long val = (Long)entry.getValue();
                long tmp = val;
                entry.setValue(new Long(tmp -= credits));
                lowest = Math.min(tmp, lowest);
            }
            return lowest;
        }
        Long val = (Long)m.get(dest);
        if (val != null) {
            lowest = val;
            m.put(dest, new Long(lowest -= credits));
            return lowest;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleCredit(Address sender, Number increase) {
        if (sender == null) {
            return;
        }
        StringBuffer sb = null;
        if (Util.acquire(this.lock)) {
            try {
                Long old_credit = (Long)this.sent.get(sender);
                long increased = old_credit + increase.longValue();
                Long new_credit = new Long(Math.min(this.max_credits, increased));
                if (this.log.isTraceEnabled()) {
                    sb = new StringBuffer();
                    sb.append("received " + increase + " credit from ").append(sender).append(", old credit was ").append(old_credit).append(", new credits are ").append(new_credit);
                    if (increased > this.max_credits) {
                        sb.append(" ignored over-credit of " + (increased - this.max_credits));
                    }
                }
                this.sent.put(sender, new_credit);
                this.lowest_credit = FC.computeLowestCredit(this.sent);
                if (!this.creditors.isEmpty()) {
                    if (this.log.isTraceEnabled()) {
                        sb.append(".\nCreditors before are: ").append(this.creditors);
                    }
                    this.creditors.remove(sender);
                    if (this.log.isTraceEnabled()) {
                        sb.append("\nCreditors after removal of ").append(sender).append(" are: ").append(this.creditors).append("; lowest_credit=").append(this.lowest_credit);
                    }
                }
                if (this.insufficient_credit && this.lowest_credit > 0L && this.creditors.isEmpty()) {
                    this.insufficient_credit = false;
                    this.mutex.broadcast();
                    if (this.log.isTraceEnabled()) {
                        sb.append("\nTotal block time = " + (System.currentTimeMillis() - this.start_blocking));
                    }
                }
                if (!this.log.isTraceEnabled()) return;
                this.log.trace((Object)sb.toString());
                return;
            }
            finally {
                Util.release(this.lock);
            }
        } else {
            if (!this.log.isWarnEnabled()) return;
            this.log.warn((Object)(increase + " credits from " + sender + " were dropped, lock could not be acquired"));
        }
    }

    private static long computeLowestCredit(Map m) {
        Collection credits = m.values();
        Long retval = (Long)Collections.min(credits);
        return retval;
    }

    private void adjustCredit(Message msg) {
        Address src = msg.getSrc();
        long length = msg.getLength();
        if (src == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"src is null");
            }
            return;
        }
        if (length == 0L) {
            return;
        }
        long remaining_cred = this.decrementCredit(this.received, src, length);
        long credit_response = this.max_credits - remaining_cred;
        if (credit_response >= this.min_credits) {
            this.received.put(src, this.max_credits_constant);
            if (!this.pending_requesters.isEmpty()) {
                this.pending_requesters.remove(src);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("sending " + credit_response + " replenishment credits to " + src));
            }
            this.sendCredit(src, credit_response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCreditRequest(Address sender, Long sender_credit) {
        if (sender == null) {
            return;
        }
        if (Util.acquire(this.lock)) {
            long credit_response = 0L;
            try {
                Long old_credit = (Long)this.received.get(sender);
                if (old_credit != null) {
                    credit_response = this.max_credits - old_credit;
                }
                if (credit_response > 0L) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("received credit request from " + sender + ": sending " + credit_response + " credits"));
                    }
                    this.received.put(sender, this.max_credits_constant);
                    this.pending_requesters.remove(sender);
                } else if (this.pending_requesters.contains(sender)) {
                    long credits_left = sender_credit;
                    if (credits_left < 0L) {
                        credits_left = 0L;
                    }
                    credit_response = this.max_credits - credits_left;
                    this.received.put(sender, this.max_credits_constant);
                    this.pending_requesters.remove(sender);
                    if (this.log.isWarnEnabled()) {
                        this.log.warn((Object)("Received two credit requests from " + sender + " without any intervening messages; sending " + credit_response + " credits"));
                    }
                } else {
                    this.pending_requesters.add(sender);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("received credit request from " + sender + " but have no credits available"));
                    }
                }
            }
            finally {
                Util.release(this.lock);
            }
            if (credit_response > 0L) {
                this.sendCredit(sender, credit_response);
            }
        }
    }

    private void sendCredit(Address dest, long credit) {
        Number number = credit < Integer.MAX_VALUE ? (Number)new Integer((int)credit) : (Number)new Long(credit);
        Message msg = new Message(dest, null, number);
        msg.putHeader(name, REPLENISH_HDR);
        this.passDown(new Event(1, msg));
        ++this.num_credit_responses_sent;
    }

    private void sendCreditRequest(Address dest, Long credit_balance) {
        if (this.max_block_time > 0L) {
            long now = System.currentTimeMillis();
            Long last = (Long)this.last_credit_request.get(dest);
            if (last != null && now - last < this.max_block_time) {
                return;
            }
            this.last_credit_request.put(dest, new Long(now));
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("sending credit request to " + dest + "; balance=" + credit_balance));
        }
        Message msg = new Message(dest, null, credit_balance);
        msg.putHeader(name, CREDIT_REQUEST_HDR);
        this.passDown(new Event(1, msg));
        ++this.num_credit_requests_sent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleViewChange(Vector mbrs) {
        if (mbrs == null) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("new membership: " + mbrs));
        }
        if (Util.acquire(this.lock)) {
            try {
                Address addr;
                for (int i = 0; i < mbrs.size(); ++i) {
                    addr = (Address)mbrs.elementAt(i);
                    if (!this.received.containsKey(addr)) {
                        this.received.put(addr, this.max_credits_constant);
                    }
                    if (this.sent.containsKey(addr)) continue;
                    this.sent.put(addr, this.max_credits_constant);
                }
                Iterator it = this.received.keySet().iterator();
                while (it.hasNext()) {
                    addr = (Address)it.next();
                    if (mbrs.contains(addr)) continue;
                    it.remove();
                }
                it = this.sent.keySet().iterator();
                while (it.hasNext()) {
                    addr = (Address)it.next();
                    if (mbrs.contains(addr)) continue;
                    it.remove();
                }
                for (int i = 0; i < this.creditors.size(); ++i) {
                    Address creditor = (Address)this.creditors.get(i);
                    if (mbrs.contains(creditor)) continue;
                    this.creditors.remove(creditor);
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("creditors are " + this.creditors));
                }
                if (this.insufficient_credit && this.creditors.isEmpty()) {
                    this.lowest_credit = FC.computeLowestCredit(this.sent);
                    this.insufficient_credit = false;
                    this.mutex.broadcast();
                }
                this.last_credit_request.clear();
            }
            finally {
                Util.release(this.lock);
            }
        }
    }

    private static String printMap(Map m) {
        StringBuffer sb = new StringBuffer();
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    public static class FcHeader
    extends Header
    implements Streamable {
        public static final byte REPLENISH = 1;
        public static final byte CREDIT_REQUEST = 2;
        byte type = 1;

        public FcHeader() {
        }

        public FcHeader(byte type) {
            this.type = type;
        }

        public long size() {
            return 1L;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "REPLENISH";
                }
                case 2: {
                    return "CREDIT_REQUEST";
                }
            }
            return "<invalid type>";
        }
    }
}

