/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Token;
import org.antlr.test.unit.TestSuite;
import org.antlr.tool.Grammar;
import org.antlr.tool.Interpreter;

public class TestInterpretedLexing
extends TestSuite {
    public void testSimpleAltCharTest() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a' | 'b' | 'c';");
        int n = grammar.getTokenType("A");
        Interpreter interpreter = new Interpreter(grammar, new ANTLRStringStream("a"));
        interpreter = new Interpreter(grammar, new ANTLRStringStream("b"));
        CommonToken commonToken = interpreter.scan("A");
        this.assertEqual(((Token)commonToken).getType(), n);
        interpreter = new Interpreter(grammar, new ANTLRStringStream("c"));
        commonToken = interpreter.scan("A");
        this.assertEqual(((Token)commonToken).getType(), n);
    }

    public void testSingleRuleRef() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a' B 'c' ;\nB : 'b' ;\n");
        int n = grammar.getTokenType("A");
        Interpreter interpreter = new Interpreter(grammar, new ANTLRStringStream("abc"));
        CommonToken commonToken = interpreter.scan("A");
        this.assertEqual(((Token)commonToken).getType(), n);
    }

    public void testSimpleLoop() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nINT : (DIGIT)+ ;\nfragment DIGIT : '0'..'9';\n");
        int n = grammar.getTokenType("INT");
        Interpreter interpreter = new Interpreter(grammar, new ANTLRStringStream("12x"));
        CommonToken commonToken = interpreter.scan("INT");
        this.assertEqual(((Token)commonToken).getType(), n);
        interpreter = new Interpreter(grammar, new ANTLRStringStream("1234"));
        commonToken = interpreter.scan("INT");
        this.assertEqual(((Token)commonToken).getType(), n);
    }

    public void testMultAltLoop() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : ('0'..'9'|'a'|'b')+ ;\n");
        int n = grammar.getTokenType("A");
        Interpreter interpreter = new Interpreter(grammar, new ANTLRStringStream("a"));
        CommonToken commonToken = interpreter.scan("A");
        interpreter = new Interpreter(grammar, new ANTLRStringStream("a"));
        commonToken = interpreter.scan("A");
        this.assertEqual(((Token)commonToken).getType(), n);
        interpreter = new Interpreter(grammar, new ANTLRStringStream("1234"));
        commonToken = interpreter.scan("A");
        this.assertEqual(((Token)commonToken).getType(), n);
        interpreter = new Interpreter(grammar, new ANTLRStringStream("aaa"));
        commonToken = interpreter.scan("A");
        this.assertEqual(((Token)commonToken).getType(), n);
        interpreter = new Interpreter(grammar, new ANTLRStringStream("aaaa9"));
        commonToken = interpreter.scan("A");
        this.assertEqual(((Token)commonToken).getType(), n);
        interpreter = new Interpreter(grammar, new ANTLRStringStream("b"));
        commonToken = interpreter.scan("A");
        this.assertEqual(((Token)commonToken).getType(), n);
        interpreter = new Interpreter(grammar, new ANTLRStringStream("baa"));
        commonToken = interpreter.scan("A");
        this.assertEqual(((Token)commonToken).getType(), n);
    }

    public void testSimpleLoops() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : ('0'..'9')+ '.' ('0'..'9')* | ('0'..'9')+ ;\n");
        int n = grammar.getTokenType("A");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("1234.5");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        CommonToken commonToken = interpreter.scan("A");
        this.assertEqual(((Token)commonToken).getType(), n);
    }

    public void testTokensRules() throws Exception {
        Grammar grammar = new Grammar("grammar p;\na : (INT|FLOAT|WS)+;\n");
        Grammar grammar2 = new Grammar();
        grammar2.importTokenVocabulary(grammar);
        grammar2.setGrammarContent("lexer grammar t;\nINT : (DIGIT)+ ;\nFLOAT : (DIGIT)+ '.' (DIGIT)* ;\nfragment DIGIT : '0'..'9';\nWS : (' ')+ {channel=99;};\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("123 139.52");
        Interpreter interpreter = new Interpreter(grammar2, aNTLRStringStream);
        CommonTokenStream commonTokenStream = new CommonTokenStream(interpreter);
        String string = commonTokenStream.toString();
        String string2 = "123 139.52";
        this.assertEqual(string, string2);
    }
}

