/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.jpetstore.web.spring;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.support.PagedListHolder;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.samples.jpetstore.domain.Account;
import org.springframework.samples.jpetstore.domain.logic.PetStoreFacade;
import org.springframework.samples.jpetstore.web.spring.AccountForm;
import org.springframework.samples.jpetstore.web.spring.UserSession;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;
import org.springframework.web.util.WebUtils;

public class AccountFormController
extends SimpleFormController {
    public static final String[] LANGUAGES = new String[]{"english", "japanese"};
    private PetStoreFacade petStore;

    public AccountFormController() {
        this.setSessionForm(true);
        this.setValidateOnBinding(false);
        this.setCommandName("accountForm");
        this.setFormView("EditAccountForm");
    }

    public void setPetStore(PetStoreFacade petStore) {
        this.petStore = petStore;
    }

    protected Object formBackingObject(HttpServletRequest request) throws Exception {
        UserSession userSession = (UserSession)WebUtils.getSessionAttribute((HttpServletRequest)request, (String)"userSession");
        if (userSession != null) {
            return new AccountForm(this.petStore.getAccount(userSession.getAccount().getUsername()));
        }
        return new AccountForm();
    }

    protected void onBindAndValidate(HttpServletRequest request, Object command, BindException errors) throws Exception {
        AccountForm accountForm = (AccountForm)command;
        Account account = accountForm.getAccount();
        if (request.getParameter("account.listOption") == null) {
            account.setListOption(false);
        }
        if (request.getParameter("account.bannerOption") == null) {
            account.setBannerOption(false);
        }
        errors.setNestedPath("account");
        this.getValidator().validate((Object)account, (Errors)errors);
        errors.setNestedPath("");
        if (accountForm.isNewAccount()) {
            account.setStatus("OK");
            ValidationUtils.rejectIfEmpty((Errors)errors, (String)"account.username", (String)"USER_ID_REQUIRED", (String)"User ID is required.");
            if (account.getPassword() == null || account.getPassword().length() < 1 || !account.getPassword().equals(accountForm.getRepeatedPassword())) {
                errors.reject("PASSWORD_MISMATCH", "Passwords did not match or were not provided. Matching passwords are required.");
            }
        } else if (account.getPassword() != null && account.getPassword().length() > 0 && !account.getPassword().equals(accountForm.getRepeatedPassword())) {
            errors.reject("PASSWORD_MISMATCH", "Passwords did not match. Matching passwords are required.");
        }
    }

    protected Map referenceData(HttpServletRequest request) throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("languages", LANGUAGES);
        model.put("categories", this.petStore.getCategoryList());
        return model;
    }

    protected ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        AccountForm accountForm = (AccountForm)command;
        try {
            if (accountForm.isNewAccount()) {
                this.petStore.insertAccount(accountForm.getAccount());
            } else {
                this.petStore.updateAccount(accountForm.getAccount());
            }
        }
        catch (DataIntegrityViolationException ex) {
            errors.rejectValue("account.username", "USER_ID_ALREADY_EXISTS", "User ID already exists: choose a different ID.");
            return this.showForm(request, response, errors);
        }
        UserSession userSession = new UserSession(this.petStore.getAccount(accountForm.getAccount().getUsername()));
        PagedListHolder myList = new PagedListHolder(this.petStore.getProductListByCategory(accountForm.getAccount().getFavouriteCategoryId()));
        myList.setPageSize(4);
        userSession.setMyList(myList);
        request.getSession().setAttribute("userSession", (Object)userSession);
        return super.onSubmit(request, response, command, errors);
    }
}

