/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.polling.test;

import com.deltax.util.TimeInterval;
import java.io.File;
import org.sadun.util.polling.BasePollManager;
import org.sadun.util.polling.CycleEndEvent;
import org.sadun.util.polling.CycleStartEvent;
import org.sadun.util.polling.DirectoryLookupEndEvent;
import org.sadun.util.polling.DirectoryLookupStartEvent;
import org.sadun.util.polling.FileFoundEvent;
import org.sadun.util.polling.FileSetFoundEvent;

class TestPollManager
extends BasePollManager {
    private boolean delay = false;
    private boolean useBusyWaitingForDelay = false;
    private Object lock = new Object();

    TestPollManager() {
    }

    public void cycleStarted(CycleStartEvent evt) {
        System.out.println("Poller awakened " + (evt.getPoller().getFilter() == null ? "(no filtering)" : evt.getPoller().getFilter().toString()));
    }

    public void cycleEnded(CycleEndEvent evt) {
        System.out.println("Poller going to sleep");
    }

    public void directoryLookupStarted(DirectoryLookupStartEvent evt) {
        System.out.println("Scanning " + evt.getDirectory());
    }

    public void directoryLookupEnded(DirectoryLookupEndEvent evt) {
        System.out.println("Finished scanning " + evt.getDirectory());
    }

    public void fileSetFound(FileSetFoundEvent evt) {
        File[] files = evt.getFiles();
        for (int i = 0; i < files.length; ++i) {
            System.out.println("Found " + files[i].getAbsolutePath());
        }
        if (this.delay) {
            this.delay(20000L, this.useBusyWaitingForDelay);
        }
    }

    public void fileFound(FileFoundEvent evt) {
        System.out.println((Object)evt);
        if (this.delay) {
            this.delay(20000L, this.useBusyWaitingForDelay);
        }
    }

    public void exceptionDeletingTargetFile(File target) {
        System.out.println("Exception deleting " + target);
    }

    public void exceptionMovingFile(File file, File dest) {
        System.out.println("Could not move " + file + " to " + dest);
    }

    public String toString() {
        return "TestPollManager - a pollmanager which just echoes the received events";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delay(long timeout, boolean busyWaiting) {
        long start;
        System.out.print("Delaying " + TimeInterval.describe((long)timeout));
        long now = start = System.currentTimeMillis();
        if (busyWaiting) {
            System.out.println(" (busy waiting)");
            while ((now = System.currentTimeMillis()) < start + timeout) {
            }
        } else {
            System.out.println(" (normal waiting)");
            try {
                System.out.println("Current thread: " + Thread.currentThread().getName());
                Object object = this.lock;
                synchronized (object) {
                    this.lock.wait(timeout);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace(System.out);
            }
            finally {
                now = System.currentTimeMillis();
            }
        }
        System.out.println();
        System.out.println("Delayed " + TimeInterval.describe((long)(now - start)) + " (should be approx. " + TimeInterval.describe((long)timeout) + ")");
        if (now - start < timeout - 500L) {
            System.out.println("WARNING: delay is noticeably smaller than expected");
        }
    }
}

