/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.polling.pollmanagers;

import com.deltax.util.TimeInterval;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sadun.util.polling.BasePollerEvent;
import org.sadun.util.polling.DirectoryLookupEndEvent;
import org.sadun.util.polling.DirectoryLookupStartEvent;
import org.sadun.util.polling.DirectoryPoller;
import org.sadun.util.polling.FileFoundEvent;
import org.sadun.util.polling.FileSetFoundEvent;
import org.sadun.util.polling.pollmanagers.HistoryPollManager;

public class LoggerHistoryPollManager
extends HistoryPollManager {
    private Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LoggerHistoryPollManager(String loggerName) {
        this.logger = Logger.getLogger(loggerName);
    }

    public LoggerHistoryPollManager() {
        this(DirectoryPoller.class.getName());
    }

    public LoggerHistoryPollManager(Logger logger) {
        this.logger = logger;
    }

    protected void storeAutomoveException(Exception e, File target) {
        if (!($assertionsDisabled || "delete".equals(e.getMessage()) || "move".equals(e.getMessage()))) {
            throw new AssertionError();
        }
        boolean isDelete = "delete".equals(e.getMessage());
        try {
            this.logger.log(isDelete ? Level.WARNING : Level.SEVERE, e.getMessage() + " operation failed for file " + target.getCanonicalPath());
        }
        catch (IOException e1) {
            this.logger.log(isDelete ? Level.WARNING : Level.SEVERE, e.getMessage() + " operation failed for file " + target.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeEvent(BasePollerEvent evt) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        boolean interesting = false;
        pw.print(evt.getTime() + "\t" + TimeInterval.describe((long)evt.getTime()) + "\t" + evt.getPoller().getName() + "\t");
        if (evt.getPoller().isSendSingleFileEvent()) {
            if (evt instanceof FileFoundEvent) {
                pw.print("Found: [" + ((FileFoundEvent)evt).getFile().getName() + "]");
            }
            interesting = true;
        } else {
            if (evt instanceof FileSetFoundEvent) {
                pw.print("Found: [");
                File[] files = ((FileSetFoundEvent)evt).getFiles();
                for (int i = 0; i < files.length; ++i) {
                    pw.print(files[i].getName());
                    if (i >= files.length - 1) continue;
                    pw.print(",");
                }
                pw.print("]");
            }
            interesting = true;
        }
        if (evt instanceof DirectoryLookupStartEvent) {
            try {
                pw.print("Looking up [" + ((DirectoryLookupStartEvent)evt).getDirectory().getCanonicalPath() + "]");
            }
            catch (IOException e) {
                pw.print("Looking up [" + ((DirectoryLookupStartEvent)evt).getDirectory().getAbsolutePath() + "]");
            }
            finally {
                interesting = true;
            }
        }
        if (evt instanceof DirectoryLookupEndEvent) {
            try {
                pw.print("Finished looking up [" + ((DirectoryLookupEndEvent)evt).getDirectory().getCanonicalPath() + "]");
            }
            catch (IOException e) {
                pw.print("Finished looking up [" + ((DirectoryLookupEndEvent)evt).getDirectory().getAbsolutePath() + "]");
            }
            finally {
                interesting = true;
            }
        }
        if (interesting) {
            this.logger.log(Level.INFO, sw.toString());
        }
    }

    static {
        $assertionsDisabled = !LoggerHistoryPollManager.class.desiredAssertionStatus();
    }
}

