/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.polling.pollmanagers;

import com.deltax.util.TimeInterval;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.sadun.util.polling.BasePollerEvent;
import org.sadun.util.polling.CycleEndEvent;
import org.sadun.util.polling.CycleStartEvent;
import org.sadun.util.polling.DirectoryLookupEndEvent;
import org.sadun.util.polling.DirectoryLookupStartEvent;
import org.sadun.util.polling.FileFoundEvent;
import org.sadun.util.polling.FileSetFoundEvent;
import org.sadun.util.polling.pollmanagers.HistoryPollManager;

public class FileHistoryPollManager
extends HistoryPollManager {
    private File file;
    private PrintWriter writer;
    private SimpleDateFormat sdf;
    private boolean firstWrite;
    private long startTime = -1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FileHistoryPollManager() throws IOException {
        this(new File(".", "pollmanager.journal.txt"));
    }

    public FileHistoryPollManager(File file) throws IOException {
        this.file = file;
        this.sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    }

    private void open() throws IOException {
        try {
            this.writer = new PrintWriter(new BufferedWriter(new FileWriter(this.file, false)));
        }
        catch (IOException e) {
            this.writer = null;
            throw e;
        }
        finally {
            this.firstWrite = true;
        }
    }

    protected void storeAutomoveException(Exception e, File target) {
        if (!($assertionsDisabled || "delete".equals(e.getMessage()) || "move".equals(e.getMessage()))) {
            throw new AssertionError();
        }
        boolean isDelete = "delete".equals(e.getMessage());
        try {
            this.log("FAILURE: " + e.getMessage() + " operation failed for file " + target.getCanonicalPath());
        }
        catch (IOException e1) {
            this.log("FAILURE: " + e.getMessage() + " operation failed for file " + target.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeEvent(BasePollerEvent evt) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        boolean interesting = false;
        if (this.startTime == -1L && evt instanceof CycleStartEvent) {
            this.startTime = evt.getTime();
        }
        pw.print(this.sdf.format(new Date(evt.getTime())) + "\t(" + TimeInterval.describe((long)(evt.getTime() - this.startTime)) + ")\t" + evt.getPoller().getName() + "\t");
        if (evt.getPoller().isSendSingleFileEvent()) {
            if (evt instanceof FileFoundEvent) {
                pw.print("Found file: [" + ((FileFoundEvent)evt).getFile().getName());
                pw.print("]");
                interesting = true;
            }
        } else if (evt instanceof FileSetFoundEvent) {
            try {
                pw.println("Found files in " + ((FileSetFoundEvent)evt).getDirectory().getCanonicalPath() + ": [");
            }
            catch (IOException e1) {
                pw.println("Found files in " + ((FileSetFoundEvent)evt).getDirectory().getAbsolutePath() + ": [");
            }
            File[] files = ((FileSetFoundEvent)evt).getFiles();
            for (int i = 0; i < files.length; ++i) {
                pw.println("  " + files[i].getName());
            }
            pw.print("]");
            interesting = true;
        }
        if (evt instanceof DirectoryLookupStartEvent) {
            try {
                pw.print("Looking up [" + ((DirectoryLookupStartEvent)evt).getDirectory().getCanonicalPath() + "]");
            }
            catch (IOException e) {
                pw.print("Looking up [" + ((DirectoryLookupStartEvent)evt).getDirectory().getAbsolutePath() + "]");
            }
            finally {
                interesting = true;
            }
        }
        if (evt instanceof DirectoryLookupEndEvent) {
            try {
                pw.print("Finished looking up [" + ((DirectoryLookupEndEvent)evt).getDirectory().getCanonicalPath() + "]");
            }
            catch (IOException e) {
                pw.print("Finished looking up [" + ((DirectoryLookupEndEvent)evt).getDirectory().getAbsolutePath() + "]");
            }
            finally {
                interesting = true;
            }
        }
        if (evt instanceof CycleEndEvent) {
            this.newLine();
        }
        if (interesting) {
            this.log(sw.toString());
        }
    }

    private synchronized void newLine() {
        this.log(System.getProperty("line.separator"), false);
    }

    private synchronized void log(String msg) {
        this.log(msg, true);
    }

    private synchronized void log(String msg, boolean considerFirstWrite) {
        if (this.writer == null) {
            try {
                this.open();
            }
            catch (IOException e1) {
                e1.printStackTrace();
                return;
            }
        }
        if (considerFirstWrite) {
            if (!this.firstWrite) {
                this.writer.println();
            } else {
                this.firstWrite = false;
            }
        }
        this.writer.print(msg);
        this.writer.flush();
        if (this.writer.checkError()) {
            try {
                this.open();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        $assertionsDisabled = !FileHistoryPollManager.class.desiredAssertionStatus();
    }
}

