/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.polling;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import org.sadun.util.EnvironmentVariables;
import org.sadun.util.polling.BasePollManager;
import org.sadun.util.polling.CycleEndEvent;
import org.sadun.util.polling.CycleStartEvent;
import org.sadun.util.polling.DirectoryLookupEndEvent;
import org.sadun.util.polling.DirectoryLookupStartEvent;
import org.sadun.util.polling.DirectoryPoller;
import org.sadun.util.polling.FileFoundEvent;
import org.sadun.util.polling.FileMovedEvent;
import org.sadun.util.polling.FileSetFoundEvent;

public class ScriptedPollManager
extends BasePollManager {
    private String[] shellCmd;
    private String scriptPath;
    private DirectoryPoller poller;

    public ScriptedPollManager(DirectoryPoller poller, String[] shellCmd, String scriptPath) {
        this.poller = poller;
        this.shellCmd = shellCmd;
        this.scriptPath = scriptPath;
    }

    public ScriptedPollManager(DirectoryPoller poller, String scriptPath) throws UnsupportedOperationException {
        this.poller = poller;
        this.scriptPath = scriptPath;
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            String comSpec = EnvironmentVariables.getInstance().getEnv("ComSpec");
            if (comSpec == null) {
                throw new UnsupportedOperationException("ComSpec environment variable not defined");
            }
            this.shellCmd = new String[2];
            this.shellCmd[0] = comSpec;
            this.shellCmd[1] = "/C";
        } else if (osName.equals("Linux") || osName.equals("Solaris") || osName.equals("HP-UX") || osName.equals("Aix") || osName.equals("FreeBSD")) {
            this.shellCmd = new String[1];
            this.shellCmd[0] = "/bin/sh";
        }
        if (this.shellCmd == null) {
            throw new UnsupportedOperationException("The scripted poll manager doesn't recognize the operating system \"" + osName + "\" and cannot determine the shell command to use");
        }
    }

    private String composeCmdString(String[] params) {
        String[] params2 = new String[params.length + this.shellCmd.length + 1];
        System.arraycopy(this.shellCmd, 0, params2, 0, this.shellCmd.length);
        params2[this.shellCmd.length] = this.scriptPath;
        System.arraycopy(params, 0, params2, this.shellCmd.length + 1, params.length);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (int i = 0; i < params2.length; ++i) {
            pw.print(params2[i]);
            pw.print(" ");
        }
        pw.print(this.scriptPath);
        return sw.toString();
    }

    private void invoke(String[] params) {
        if (this.poller.isShuttingDown()) {
            return;
        }
        String[] params2 = new String[params.length + this.shellCmd.length + 1];
        System.arraycopy(this.shellCmd, 0, params2, 0, this.shellCmd.length);
        params2[this.shellCmd.length] = this.scriptPath;
        System.arraycopy(params, 0, params2, this.shellCmd.length + 1, params.length);
        try {
            int c;
            if (this.poller.isVerbose()) {
                System.err.println("Attempting to run " + this.composeCmdString(params));
            }
            Process p = Runtime.getRuntime().exec(params2);
            InputStream os = p.getInputStream();
            InputStream os2 = p.getErrorStream();
            try {
                while ((c = os.read()) != -1) {
                    System.out.write(c);
                }
            }
            catch (IOException e) {
                System.err.println("Problem reading script output for " + this.composeCmdString(params));
            }
            try {
                while ((c = os2.read()) != -1) {
                    System.err.write(c);
                }
            }
            catch (IOException e) {
                System.err.println("Problem reading script error output for " + this.composeCmdString(params));
            }
            try {
                int result = p.waitFor();
                if (result != 0) {
                    System.err.println(this.composeCmdString(params) + " returned nonzero");
                }
            }
            catch (InterruptedException e) {
                System.err.println("ScriptedPollManager interrupted while waiting for child process " + this.composeCmdString(params));
            }
        }
        catch (IOException e) {
            System.err.println("Problem invoking " + this.composeCmdString(params));
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print("Scripted pollManager running ");
        for (int i = 0; i < this.shellCmd.length; ++i) {
            pw.print(this.shellCmd[i]);
            pw.print(" ");
        }
        pw.print(this.scriptPath);
        return sw.toString();
    }

    public void cycleEnded(CycleEndEvent evt) {
        this.invoke(new String[]{"CycleEnded", String.valueOf(evt.getTime())});
    }

    public void cycleStarted(CycleStartEvent evt) {
        this.invoke(new String[]{"CycleStarted", String.valueOf(evt.getTime())});
    }

    public void directoryLookupEnded(DirectoryLookupEndEvent evt) {
        try {
            this.invoke(new String[]{"DirectoryLookupEnded", DateFormat.getDateTimeInstance().format(new Date(evt.getTime())), evt.getDirectory().getCanonicalPath()});
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.err.println("Problem in getting the canonical path for <directory lookup end> event");
        }
    }

    public void directoryLookupStarted(DirectoryLookupStartEvent evt) {
        try {
            this.invoke(new String[]{"DirectoryLookupStarted", DateFormat.getDateTimeInstance().format(new Date(evt.getTime())), evt.getDirectory().getCanonicalPath()});
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.err.println("Problem in getting the canonical path for <directory lookup start> event");
        }
    }

    public void exceptionDeletingTargetFile(File target) {
        try {
            this.invoke(new String[]{"ExceptionDeletingTargetFile", target.getCanonicalPath()});
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.err.println("Problem in getting the canonical path for <exception deleting target file> event");
        }
    }

    public void exceptionMovingFile(File file, File dest) {
        try {
            this.invoke(new String[]{"ExceptionMovingTargetFile", file.getCanonicalPath(), dest.getCanonicalPath()});
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.err.println("Problem in getting the canonical path for <exception moving target file> event");
        }
    }

    public void fileFound(FileFoundEvent evt) {
        try {
            this.invoke(new String[]{"FileFound", DateFormat.getDateTimeInstance().format(new Date(evt.getTime())), evt.getDirectory().getCanonicalPath(), evt.getFile().getCanonicalPath()});
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.err.println("Problem in getting the canonical path for <file found> event");
        }
    }

    public void fileMoved(FileMovedEvent evt) {
        try {
            this.invoke(new String[]{"FileMoved", DateFormat.getDateTimeInstance().format(new Date(evt.getTime())), evt.getOriginalPath().getCanonicalPath(), evt.getMovedFile().getDestinationPath().getCanonicalPath()});
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.err.println("Problem in getting the canonical path for <file moved> event");
        }
    }

    public void fileSetFound(FileSetFoundEvent evt) {
        try {
            File[] files = evt.getFiles();
            if (files.length == 0) {
                return;
            }
            String[] params = new String[files.length + 3];
            params[0] = "FileSetFound";
            params[1] = DateFormat.getDateTimeInstance().format(new Date(evt.getTime()));
            params[2] = evt.getDirectory().getCanonicalPath();
            for (int i = 0; i < files.length; ++i) {
                params[i + 3] = files[i].getCanonicalPath();
            }
            this.invoke(params);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.err.println("Problem in getting the canonical path for <file moved> event");
        }
    }

    public static void main(String[] args) throws Exception {
        DirectoryPoller poller = new DirectoryPoller(new File("c:\\temp"));
        ScriptedPollManager pm = new ScriptedPollManager(poller, "c:\\test.bat");
        poller.addPollManager(pm);
        poller.setAutoMove(true);
        poller.setPollInterval(1000L);
        poller.start();
    }
}

