/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.polling;

import com.deltax.util.JPanelOutputStream;
import java.awt.BorderLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JFrame;
import org.sadun.util.CmdLineOptions;
import org.sadun.util.polling.BasePollManager;
import org.sadun.util.polling.DirectoryPoller;
import org.sadun.util.polling.FileSetFoundEvent;

public class Monitor {
    private transient CmdLineOptions co = new CmdLineOptions();
    private File[] files;
    private JPanelOutputStream jps;
    private PrintStream ps;
    private DirectoryPoller poller;

    public Monitor() {
        this.co.setOnOption("files", (Object)this, "files");
        this.co.setDescription("files", "The directories to monitor");
        this.co.setMandatory("files", true);
    }

    public void init(String[] args) throws IOException {
        this.co.parse(args);
        for (int i = 0; i < this.files.length; ++i) {
            if (!this.files[i].isDirectory()) {
                throw new Error(this.files[i].getCanonicalPath() + " is not a directory.");
            }
            if (this.files[i].exists()) continue;
            System.err.println("Warning: " + this.files[i].getCanonicalPath() + " does not exist.");
        }
        this.jps = new JPanelOutputStream();
        this.ps = new PrintStream((OutputStream)this.jps);
    }

    public void run() {
        JFrame f = new JFrame("Directory monitor");
        f.setSize(300, 300);
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add(this.jps.getPanel());
        f.addWindowListener(new WindowAdapter(){

            public void WindowClosing(WindowEvent e) {
                System.err.println("Shutting down poller");
                Monitor.this.poller.shutdown();
                System.err.println("Exiting");
                System.exit(0);
            }
        });
        this.poller = new DirectoryPoller(this.files);
        this.poller.addPollManager(new MonitorPollManager());
        f.setVisible(true);
        this.poller.start();
    }

    public static void main(String[] args) throws Exception {
        try {
            Monitor m = new Monitor();
            m.init(args);
            m.run();
        }
        catch (CmdLineOptions.OptionException e) {
            System.err.println((Object)e);
        }
    }

    private class MonitorPollManager
    extends BasePollManager {
        private MonitorPollManager() {
        }

        public void fileSetFound(FileSetFoundEvent evt) {
            File[] polledFiles = evt.getFiles();
            for (int i = 0; i < polledFiles.length; ++i) {
                Monitor.this.ps.println("Polled " + polledFiles[i].getAbsolutePath());
            }
        }
    }
}

