/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.polling;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.sadun.util.RegexpFilenameFilter;
import org.sadun.util.polling.BaseJMXNotification;
import org.sadun.util.polling.CoreSequenceNumberGenerator;
import org.sadun.util.polling.DirectoryPoller;
import org.sadun.util.polling.FilenameFilterFactory;
import org.sadun.util.polling.GenericFileComparator;
import org.sadun.util.polling.JMXNotificationsPollManager;
import org.sadun.util.polling.ManagedDirectoryPollerMBean;
import org.sadun.util.polling.PollManager;
import org.sadun.util.polling.PollManagerFactory;
import org.sadun.util.polling.SequenceNumberGenerator;

public class ManagedDirectoryPoller
extends DirectoryPoller
implements ManagedDirectoryPollerMBean,
MBeanRegistration,
NotificationListener,
NotificationBroadcaster {
    private Thread managedThread;
    private boolean usingJMXTimer;
    private String JMXTimerObjectName;
    private ObjectName pollerMBeanName;
    private boolean isListeningToTimingEvents;
    private String pollManagerFactoryClsName;
    private PollManagerFactory pollManagerFactory;
    private String filenameFilterFactoryClsName;
    private FilenameFilterFactory filenameFilterFactory;
    private String currentPattern;
    private SequenceNumberGenerator sqg;
    private String JMXsequenceNumberGeneratorClass = CoreSequenceNumberGenerator.class.getName();
    private JMXNotificationsPollManager jmxNotificationsPollManager;

    public ManagedDirectoryPoller(File[] dirs, FilenameFilter filter) {
        super(dirs, filter);
    }

    public ManagedDirectoryPoller(File[] dirs) {
        super(dirs);
    }

    public ManagedDirectoryPoller(File directory, FilenameFilter filter) {
        super(directory, filter);
    }

    public ManagedDirectoryPoller(File directory) {
        super(directory);
    }

    public ManagedDirectoryPoller(FilenameFilter filter) {
        super(filter);
    }

    public ManagedDirectoryPoller() {
    }

    public ManagedDirectoryPoller(File[] dirs, FilenameFilter filter, boolean timeBased) {
        super(dirs, filter, timeBased);
    }

    public ManagedDirectoryPoller(File directory, FilenameFilter filter, boolean timeBased) {
        super(directory, filter, timeBased);
    }

    public ManagedDirectoryPoller(FilenameFilter filter, boolean timeBased) {
        super(filter, timeBased);
    }

    public void postDeregister() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRegister(Boolean registrationDone) {
        block6: {
            try {
                try {
                    this.sqg = (SequenceNumberGenerator)Class.forName(this.JMXsequenceNumberGeneratorClass).newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Object var4_3 = null;
                    if (this.sqg == null) {
                        this.sqg = new CoreSequenceNumberGenerator();
                        this.JMXsequenceNumberGeneratorClass = CoreSequenceNumberGenerator.class.getName();
                    }
                }
                Object var4_2 = null;
                if (this.sqg != null) break block6;
                this.sqg = new CoreSequenceNumberGenerator();
                this.JMXsequenceNumberGeneratorClass = CoreSequenceNumberGenerator.class.getName();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (this.sqg == null) {
                    this.sqg = new CoreSequenceNumberGenerator();
                    this.JMXsequenceNumberGeneratorClass = CoreSequenceNumberGenerator.class.getName();
                }
                throw throwable;
            }
        }
        this.jmxNotificationsPollManager = new JMXNotificationsPollManager(this.pollerMBeanName, this.sqg);
        this.addPollManager(this.jmxNotificationsPollManager);
    }

    public void preDeregister() throws Exception {
        if (this.isAlive()) {
            this.shutdown();
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.pollerMBeanName = name;
        return name;
    }

    public void startUp() {
        if (this.getDirectories().length == 0) {
            throw new IllegalStateException("No directories to poll");
        }
        if (this.managedThread != null) {
            throw new IllegalStateException("the directory poller is already running");
        }
        if (this.usingJMXTimer) {
            this.isListeningToTimingEvents = true;
        } else {
            this.managedThread = new Thread((Runnable)((Object)this), "Managed directory poller");
            this.managedThread.setDaemon(true);
            this.managedThread.start();
        }
    }

    public void shutDown() {
        if (this.usingJMXTimer) {
            this.isListeningToTimingEvents = false;
        } else {
            if (this.managedThread == null) {
                throw new IllegalStateException("Directory poller is not started");
            }
            super.shutdown();
            this.managedThread = null;
        }
    }

    public String getAutoMoveDirectoryPath(String directory) {
        if (directory == null) {
            throw new IllegalArgumentException("No directory specified");
        }
        if ("".equals(directory.trim())) {
            throw new IllegalArgumentException("No directory specified");
        }
        try {
            return this.getAutoMoveDirectory(new File(directory)).getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeControlledDirectory(String dir) {
        super.removeDirectory(new File(dir));
    }

    public void addControlledDirectory(String dir) {
        super.addDirectory(new File(dir));
    }

    public int countControlledDirectories() {
        return this.getDirectories().length;
    }

    public boolean isRunning() {
        if (this.managedThread == null) {
            return false;
        }
        if (this.usingJMXTimer) {
            return this.isListeningToTimingEvents;
        }
        return this.managedThread.isAlive();
    }

    public String getControlledDirectory(int i) {
        if (i < 0 || i >= this.getDirectories().length) {
            throw new IllegalArgumentException("Index out of range");
        }
        try {
            return this.getDirectories()[i].getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setBaseTime(String directory, long time) {
        File dir = new File(directory);
        super.setBaseTime(dir, time);
    }

    public long getBaseTime(String directory) {
        File dir = new File(directory);
        return super.getBaseTime(dir);
    }

    public String listControlledDirectories() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        File[] dirs = this.getDirectories();
        pw.println("Total of " + dirs.length + " controlled directories");
        pw.println();
        for (int i = 0; i < dirs.length; ++i) {
            pw.print("[" + i + "] ");
            pw.println(dirs[i]);
        }
        return sw.toString();
    }

    public String getControlledDirectories() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        File[] dirs = this.getDirectories();
        for (int i = 0; i < dirs.length; ++i) {
            pw.print(dirs[i]);
            if (i >= dirs.length - 1) continue;
            pw.print(",");
        }
        return sw.toString();
    }

    public void setControlledDirectories(String dirList) {
        StringTokenizer st = new StringTokenizer(dirList, ",");
        while (st.hasMoreTokens()) {
            this.addControlledDirectory(st.nextToken());
        }
    }

    public String listInstalledPollManagers() {
        if (this.pollManagersList.size() == 0) {
            return "No poll managers installed";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Iterator i = this.pollManagersList.iterator();
        while (i.hasNext()) {
            PollManager pm = (PollManager)i.next();
            if (pm instanceof JMXNotificationsPollManager) continue;
            pw.println(pm.toString());
        }
        return sw.toString();
    }

    public void addPollManager(PollManager pm) {
        if (pm instanceof JMXNotificationsPollManager) {
            Iterator i = this.pollManagersList.iterator();
            while (i.hasNext()) {
                if (!(i.next() instanceof JMXNotificationsPollManager)) continue;
                throw new RuntimeException("JMXNotificationsPollManager is an internal-use only PollManager");
            }
        }
        super.addPollManager(pm);
        if (this.isVerbose()) {
            System.out.println("Added PollManager: " + pm);
        }
    }

    public String getPollManagerFactoryClass() {
        if (this.pollManagerFactoryClsName == null) {
            return "";
        }
        return this.pollManagerFactoryClsName;
    }

    public void setPollManagerFactoryClass(String newFactoryClsName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (this.isRunning()) {
            throw new RuntimeException("The directory poller is already running");
        }
        if (this.pollManagerFactoryClsName != null) {
            if (this.pollManagerFactoryClsName.equals(newFactoryClsName)) {
                return;
            }
            this.pollManagersList.clear();
            this.pollManagerFactory = null;
            this.pollManagerFactoryClsName = null;
        }
        if (newFactoryClsName == null) {
            return;
        }
        if ("".equals("newFactoryClsName")) {
            this.pollManagerFactory = null;
            this.pollManagerFactoryClsName = null;
            return;
        }
        this.pollManagerFactory = (PollManagerFactory)Class.forName(newFactoryClsName).newInstance();
        this.pollManagerFactoryClsName = newFactoryClsName;
        if (this.pollerMBeanName == null) {
            throw new RuntimeException("PreRegister hasn't been called on this bean - poller bean name is null");
        }
        PollManager[] set = this.pollManagerFactory.createPollManagers(this.pollerMBeanName.getCanonicalName());
        for (int i = 0; i < set.length; ++i) {
            this.addPollManager(set[i]);
        }
    }

    public String getPollManagerFactory() {
        if (this.pollManagerFactory == null) {
            return "(No PollManagerFactory set)";
        }
        return this.pollManagerFactory.getDescription();
    }

    public boolean isUsingJMXTimer() {
        return this.usingJMXTimer;
    }

    public void setUsingJMXTimer(boolean usingJMXTimer_NewValue) {
        if (this.usingJMXTimer) {
            if (usingJMXTimer_NewValue) {
                // empty if block
            }
        } else if (!usingJMXTimer_NewValue && this.isAlive()) {
            throw new IllegalStateException("Can't set the use of JMX timer while the poller is running. Please shut it down first.");
        }
        this.usingJMXTimer = usingJMXTimer_NewValue;
    }

    public String getJMXTimerObjectName() {
        if (this.JMXTimerObjectName == null) {
            return "";
        }
        return this.JMXTimerObjectName;
    }

    public void setJMXTimerObjectName(String jMXTimerObjectName) {
        if ("".equals(jMXTimerObjectName)) {
            jMXTimerObjectName = null;
        }
        this.JMXTimerObjectName = jMXTimerObjectName;
    }

    public void handleNotification(Notification arg0, Object arg1) {
    }

    public void setFilenameFilterFactoryClass(String newFilenameFilterFactoryClsName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (this.isRunning()) {
            throw new RuntimeException("The directory poller is already running");
        }
        if (newFilenameFilterFactoryClsName == null) {
            return;
        }
        if (newFilenameFilterFactoryClsName == null || "".equals(newFilenameFilterFactoryClsName)) {
            this.setFilter(new DirectoryPoller.NullFilenameFilter());
            this.filenameFilterFactoryClsName = null;
            return;
        }
        this.filenameFilterFactory = (FilenameFilterFactory)Class.forName(newFilenameFilterFactoryClsName).newInstance();
        this.filenameFilterFactoryClsName = newFilenameFilterFactoryClsName;
        if (this.pollerMBeanName == null) {
            throw new RuntimeException("PreRegister hasn't been called on this bean - poller bean name is null");
        }
        this.setFilter(this.filenameFilterFactory.createFilenameFilter(this.pollerMBeanName.getCanonicalName()));
    }

    public String getFilenameFilterFactory() {
        if (this.filenameFilterFactory == null) {
            return "(No FilenameFilterFactory set)";
        }
        return this.filenameFilterFactory.getDescription();
    }

    public String getFilenameFilterFactoryClass() {
        if (this.filenameFilterFactoryClsName == null) {
            return "";
        }
        return this.filenameFilterFactoryClsName;
    }

    public void setAcceptedFilenamePattern(String filenamePattern) {
        if (this.filenameFilterFactoryClsName != null && !"".equals(filenamePattern)) {
            try {
                this.setFilenameFilterFactoryClass("");
            }
            catch (InstantiationException e) {
                throw new RuntimeException("This shouldn't happen (" + e.getClass().getName() + ":" + e.getMessage() + ") - please report", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("This shouldn't happen (" + e.getClass().getName() + ":" + e.getMessage() + ") - please report", e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("This shouldn't happen (" + e.getClass().getName() + ":" + e.getMessage() + ") - please report", e);
            }
        }
        if ("".equals(filenamePattern)) {
            this.setFilter(new DirectoryPoller.NullFilenameFilter());
        } else {
            this.setFilter(new RegexpFilenameFilter(filenamePattern));
        }
    }

    public void setFilter(FilenameFilter filter) {
        this.currentPattern = filter instanceof RegexpFilenameFilter ? ((RegexpFilenameFilter)filter).getPatternString() : null;
        super.setFilter(filter);
    }

    public String getAcceptedFilenamePattern() {
        if (this.currentPattern == null) {
            return "";
        }
        return this.currentPattern;
    }

    public void setAutoMoveDirectoryPath(String directory, String automoveDirectory) {
        this.setAutoMoveDirectory(new File(directory), new File(automoveDirectory));
    }

    public String getFilesSortComparatorClass() {
        if (this.getFilesSortComparator() != null) {
            return this.getFilesSortComparator().getClass().getName();
        }
        return "";
    }

    public void setFilesSortComparatorClass(String fileComparatorClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if ("".equals(fileComparatorClassName)) {
            this.setFilesSortComparator(null);
        } else if (!fileComparatorClassName.equals(GenericFileComparator.class.getName())) {
            Class<?> cls = Class.forName(fileComparatorClassName);
            try {
                Constructor<?> ctor = cls.getConstructor(new Class[0]);
                if (!Modifier.isPublic(ctor.getModifiers())) {
                    throw new RuntimeException("The specified file comparator class " + fileComparatorClassName + " has a zero-parameters constructor, but it is not public");
                }
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("The specified file comparator class " + fileComparatorClassName + " does not have a default constructor");
            }
            this.setFilesSortComparator((Comparator)cls.newInstance());
        }
    }

    public void setEventsOrdering(String expr) {
        if ("by comparator class".equals(expr.trim().toLowerCase())) {
            return;
        }
        if ("-".equals(expr.trim()) || "none".equals(expr.trim().toLowerCase()) || "".equals(expr.trim())) {
            this.setFilesSortComparator(null);
            return;
        }
        GenericFileComparator c = new GenericFileComparator(expr);
        this.setFilesSortComparator(c);
    }

    public String getEventsOrdering() {
        Comparator c = this.getFilesSortComparator();
        if (c == null) {
            return "none";
        }
        if (c instanceof GenericFileComparator) {
            return ((GenericFileComparator)c).getSpecification();
        }
        return "by comparator class";
    }

    public String getJMXSequenceNumberGeneratorClass() {
        return this.JMXsequenceNumberGeneratorClass;
    }

    public void setJMXSequenceNumberGeneratorClass(String sequenceNumberGeneratorClass) throws MBeanException {
        try {
            this.sqg = (SequenceNumberGenerator)Class.forName(sequenceNumberGeneratorClass).newInstance();
            this.JMXsequenceNumberGeneratorClass = sequenceNumberGeneratorClass;
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] mbv = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"org.sadun.polling.jmx.cycle.start", "org.sadun.polling.jmx.cycle.end", "org.sadun.polling.jmx.directory.lookup.start", "org.sadun.polling.jmx.directory.lookup.end", "org.sadun.polling.jmx.file.set.found", "org.sadun.polling.jmx.file.moved", "org.sadun.polling.jmx.file.moved", "org.sadun.polling.jmx.exception.file.moving", "org.sadun.polling.jmx.exception.file.deleting"}, BaseJMXNotification.class.getName(), "Poller notification events")};
        return mbv;
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.jmxNotificationsPollManager.addListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.jmxNotificationsPollManager.removeListener(listener);
    }

    public void addNotificationListener(ObjectName listenerMBeanName) throws InstanceNotFoundException {
        this.addNotificationListener(null, listenerMBeanName);
    }

    public void addNotificationListener(String mbeanServerName, ObjectName listenerMBeanName) throws InstanceNotFoundException {
        MBeanServer srv = this.getMBeanServer(mbeanServerName);
        if (this.isVerbose()) {
            System.out.println("Adding notification listener " + listenerMBeanName + " to " + this.pollerMBeanName + " on server " + srv);
        }
        srv.addNotificationListener(this.pollerMBeanName, listenerMBeanName, null, null);
        if (this.isVerbose()) {
            System.out.println("Added notification listener " + listenerMBeanName + " to " + this.pollerMBeanName + " on server " + srv);
        }
    }

    public void removeNotificationListener(ObjectName listenerMBeanName) throws InstanceNotFoundException, ListenerNotFoundException {
        this.removeNotificationListener(null, listenerMBeanName);
    }

    public void removeNotificationListener(String mbeanServerName, ObjectName listenerMBeanName) throws InstanceNotFoundException, ListenerNotFoundException {
        MBeanServer srv = this.getMBeanServer(mbeanServerName);
        if (this.isVerbose()) {
            System.out.println("Removing notification listener " + listenerMBeanName + " to " + this.pollerMBeanName + " on server " + srv);
        }
        srv.removeNotificationListener(this.pollerMBeanName, listenerMBeanName);
        if (this.isVerbose()) {
            System.out.println("Removed notification listener " + listenerMBeanName + " to " + this.pollerMBeanName + " on server " + srv);
        }
    }

    private MBeanServer getMBeanServer(String mbeanServerName) {
        MBeanServer srv = null;
        ArrayList<MBeanServer> al = MBeanServerFactory.findMBeanServer(mbeanServerName);
        if (al.isEmpty()) {
            throw new RuntimeException("Could not find any MBean server" + mbeanServerName != null ? " named \"" + mbeanServerName + "\"" : "");
        }
        if (al.size() != 1) {
            throw new RuntimeException("More than one MBean server " + (mbeanServerName != null ? "named \"" + mbeanServerName + "\" " : "") + "registered?");
        }
        srv = al.get(0);
        return srv;
    }
}

