/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.polling;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.sadun.util.BidirectionalComparator;
import org.sadun.util.ChainedComparator;

class GenericFileComparator
implements Comparator {
    private static Map properties = new HashMap();
    private Comparator cc;
    private String specification;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;

    public GenericFileComparator(String specification) {
        this.specification = specification;
        StringTokenizer st = new StringTokenizer(specification, ";");
        ArrayList<SingleExprComparator> comparators = new ArrayList<SingleExprComparator>();
        while (st.hasMoreTokens()) {
            String spec2 = st.nextToken();
            comparators.add(new SingleExprComparator(spec2));
        }
        if (comparators.size() == 1) {
            this.cc = (Comparator)comparators.get(0);
        } else {
            this.cc = (Comparator)comparators.get(comparators.size() - 1);
            for (int i = comparators.size() - 2; i >= 0; --i) {
                Comparator cc1 = (Comparator)comparators.get(i);
                this.cc = new ChainedComparator(cc1, this.cc);
            }
        }
    }

    public int compare(Object o1, Object o2) {
        return this.cc.compare(o1, o2);
    }

    public String toString() {
        return this.cc.toString();
    }

    public String getSpecification() {
        return this.specification;
    }

    static {
        List<String> toAvoid = Arrays.asList("class", "canonicalFile", "absolute", "file", "canonicalPath", "parentFile", "path", "absolutePath", "parent", "absoluteFile");
        try {
            PropertyDescriptor[] descr = Introspector.getBeanInfo(File.class).getPropertyDescriptors();
            for (int i = 0; i < descr.length; ++i) {
                if (descr[i].getReadMethod() == null || toAvoid.contains(descr[i].getName())) continue;
                properties.put(descr[i].getName(), descr[i].getReadMethod());
            }
            try {
                properties.put("lastmodified", File.class.getMethod("lastModified", new Class[0]));
                Method mt = File.class.getMethod("length", new Class[0]);
                properties.put("size", mt);
                properties.put("length", mt);
                mt = File.class.getMethod("canRead", new Class[0]);
                properties.put("canRead", mt);
                mt = File.class.getMethod("canWrite", new Class[0]);
                properties.put("canWrite", mt);
            }
            catch (NoSuchMethodException e1) {
                throw new Error("The current " + GenericFileComparator.class + "  is not compatible with the version of JDK in use", e1);
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    private class SingleExprComparator
    extends BidirectionalComparator {
        private Method methodToUse;
        private Class returnType;

        public SingleExprComparator(String spec) {
            super(true);
            this.methodToUse = null;
            this.parseSpec(spec);
        }

        private void parseSpec(String spec) {
            StringTokenizer st = new StringTokenizer(spec, " ");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim().toLowerCase();
                if ("ascending".equals(token)) {
                    this.ascending = true;
                    continue;
                }
                if ("descending".equals(token)) {
                    this.ascending = false;
                    continue;
                }
                Method readMethod = (Method)properties.get(token);
                if (readMethod == null) {
                    throw new IllegalArgumentException("'" + token + "' is not a readable property for the File object. Available properties are: " + this.listProperties());
                }
                if (this.methodToUse != null) {
                    throw new IllegalArgumentException("method to use specified twice:'" + this.methodToUse.getName() + "' and '" + readMethod.getName());
                }
                this.methodToUse = readMethod;
                this.returnType = this.methodToUse.getReturnType();
                this.checkSupportedType(this.methodToUse.getName(), this.returnType);
            }
        }

        private String listProperties() {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            Iterator i = properties.keySet().iterator();
            while (i.hasNext()) {
                pw.print(i.next());
                if (!i.hasNext()) continue;
                pw.print(", ");
            }
            return sw.toString();
        }

        private void checkSupportedType(String name, Class returnType) {
            if (returnType == Boolean.TYPE || this.isNumeric(returnType) || returnType == (class$java$lang$String == null ? (class$java$lang$String = GenericFileComparator.class$("java.lang.String")) : class$java$lang$String)) {
                return;
            }
            throw new IllegalArgumentException("Unsupported type for readable property '" + name + "': " + returnType.getName());
        }

        private boolean isNumeric(Class returnType) {
            return returnType == Short.TYPE || returnType == (class$java$lang$Short == null ? (class$java$lang$Short = GenericFileComparator.class$("java.lang.Short")) : class$java$lang$Short) || returnType == Byte.TYPE || returnType == (class$java$lang$Byte == null ? (class$java$lang$Byte = GenericFileComparator.class$("java.lang.Byte")) : class$java$lang$Byte) || returnType == Character.TYPE || returnType == (class$java$lang$Character == null ? (class$java$lang$Character = GenericFileComparator.class$("java.lang.Character")) : class$java$lang$Character) || returnType == Long.TYPE || returnType == (class$java$lang$Long == null ? (class$java$lang$Long = GenericFileComparator.class$("java.lang.Long")) : class$java$lang$Long) || returnType == Integer.TYPE || returnType == (class$java$lang$Integer == null ? (class$java$lang$Integer = GenericFileComparator.class$("java.lang.Integer")) : class$java$lang$Integer) || returnType == Float.TYPE || returnType == (class$java$lang$Float == null ? (class$java$lang$Float = GenericFileComparator.class$("java.lang.Float")) : class$java$lang$Float) || returnType == Double.TYPE || returnType == (class$java$lang$Double == null ? (class$java$lang$Double = GenericFileComparator.class$("java.lang.Double")) : class$java$lang$Double);
        }

        protected long getComparisonValue(File f1, File f2) {
            try {
                Object value1 = this.methodToUse.invoke((Object)f1, new Object[0]);
                Object value2 = this.methodToUse.invoke((Object)f2, new Object[0]);
                if (this.isNumeric(this.returnType)) {
                    double l1 = Double.valueOf(value1.toString());
                    double l2 = Double.valueOf(value2.toString());
                    return new Double(l1 - l2).longValue();
                }
                if (this.returnType == (class$java$lang$String == null ? (class$java$lang$String = GenericFileComparator.class$("java.lang.String")) : class$java$lang$String)) {
                    String s1 = (String)value1;
                    String s2 = (String)value2;
                    return s2.compareTo(s1);
                }
                if (this.returnType == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = GenericFileComparator.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                    int b1 = (Boolean)value1 != false ? 1 : 0;
                    int b2 = (Boolean)value1 != false ? 1 : 0;
                    return b1 - b2;
                }
                throw new RuntimeException("Unsupported type " + this.returnType);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return 0L;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                return 0L;
            }
        }

        public String toString() {
            return "using file's " + this.methodToUse.getName() + " property (" + (this.ascending ? "ascending" : "descending") + ")";
        }
    }
}

