/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.polling;

import com.deltax.util.listener.BaseSignalSourceThread;
import com.deltax.util.listener.ExceptionSignal;
import com.deltax.util.listener.Listener;
import com.deltax.util.listener.Signal;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sadun.util.BidirectionalComparator;
import org.sadun.util.PathNormalizer;
import org.sadun.util.Terminable;
import org.sadun.util.polling.CycleEndEvent;
import org.sadun.util.polling.CycleStartEvent;
import org.sadun.util.polling.DefaultListener;
import org.sadun.util.polling.DirectoryLookupEndEvent;
import org.sadun.util.polling.DirectoryLookupStartEvent;
import org.sadun.util.polling.FileFoundEvent;
import org.sadun.util.polling.FileMovedEvent;
import org.sadun.util.polling.FileSetFoundEvent;
import org.sadun.util.polling.PollManager;

public class DirectoryPoller
extends BaseSignalSourceThread
implements Terminable {
    public static final String DEFAULT_AUTOMOVE_DIRECTORY = "received";
    private static int counter = 0;
    private volatile boolean shutdownRequested = false;
    private FilenameFilter filter;
    private File[] dirs;
    private long[] baseTime;
    private boolean verbose = System.getProperty("org.sadun.verbose") != null;
    private boolean timeBasedOnLastLookup = true;
    protected List pollManagersList = new ArrayList();
    private boolean autoMove = false;
    private Map autoMoveDirs = new HashMap();
    private FilenameFilter originalFilter;
    private long pollInterval = 10000L;
    private boolean startBySleeping = false;
    private boolean sendSingleFileEvent = false;
    private int currentDir = -1;
    private Comparator filesSortComparator = null;
    private boolean bypassLockedFiles = false;

    public DirectoryPoller(File[] dirs, FilenameFilter filter) {
        this(dirs, filter, false);
    }

    public DirectoryPoller(File[] dirs) {
        this(dirs, (FilenameFilter)new NullFilenameFilter());
    }

    public DirectoryPoller(File directory, FilenameFilter filter) {
        this(new File[]{directory}, filter);
    }

    public DirectoryPoller(File directory) {
        this(new File[]{directory});
    }

    public DirectoryPoller(FilenameFilter filter) {
        this(filter, false);
    }

    public DirectoryPoller() {
        this(new NullFilenameFilter());
    }

    public DirectoryPoller(File[] dirs, FilenameFilter filter, boolean timeBased) {
        this.setName("directory-poller-" + counter++);
        this.setDirectories(dirs);
        this.originalFilter = new DirectoryFilter(filter);
        this.setTimeBased(timeBased);
        this.baseTime = new long[dirs.length];
    }

    public DirectoryPoller(File directory, FilenameFilter filter, boolean timeBased) {
        this(new File[]{directory}, filter, timeBased);
    }

    public DirectoryPoller(FilenameFilter filter, boolean timeBased) {
        this(new File[0], filter, timeBased);
    }

    public void addDirectory(File dir) {
        File[] originalDirs = this.getDirectories();
        for (int i = 0; i < originalDirs.length; ++i) {
            if (!originalDirs[i].getAbsoluteFile().equals(dir.getAbsoluteFile())) continue;
            return;
        }
        File[] dirs = new File[this.getDirectories().length + 1];
        System.arraycopy(originalDirs, 0, dirs, 0, originalDirs.length);
        dirs[originalDirs.length] = dir;
        this.setDirectories(dirs);
    }

    public void removeDirectory(File dir) {
        File[] originalDirs = this.getDirectories();
        File[] dirs = new File[originalDirs.length - 1];
        boolean removed = false;
        int c = 0;
        for (int i = 0; i < originalDirs.length; ++i) {
            if (originalDirs[i].equals(dir)) {
                removed = true;
                continue;
            }
            dirs[c++] = originalDirs[i];
        }
        if (!removed) {
            throw new IllegalArgumentException(dir + " is not a controlled directory");
        }
        this.setDirectories(dirs);
    }

    public void setDirectories(File[] dirs) {
        if (this.isAlive()) {
            throw new IllegalStateException("Can't call setDirectories when the poller has already started");
        }
        if (dirs != null) {
            for (int i = 0; i < dirs.length; ++i) {
                if (dirs[i].isDirectory()) continue;
                throw new IllegalArgumentException(dirs[i] + " is not a directory");
            }
        }
        this.dirs = dirs;
        this.baseTime = new long[dirs.length];
    }

    public File[] getDirectories() {
        return this.dirs;
    }

    public void setAutoMove(boolean v) {
        this.autoMove = v;
    }

    public boolean getAutoMove() {
        return this.autoMove;
    }

    public File getAutoMoveDirectory(File directory) throws IllegalArgumentException {
        File f = (File)this.autoMoveDirs.get(directory = PathNormalizer.normalize((File)directory));
        if (f == null) {
            f = new File(directory, DEFAULT_AUTOMOVE_DIRECTORY);
            this.setAutoMoveDirectory0(directory, f);
        }
        return f;
    }

    public void setAutoMoveDirectory(File directory, File autoMoveDirectory) throws IllegalArgumentException, IllegalStateException {
        if (this.isAlive()) {
            throw new IllegalStateException("auto-move directories cannot be set once the poller has started");
        }
        this.setAutoMoveDirectory0(directory, autoMoveDirectory);
    }

    private void setAutoMoveDirectory0(File directory, File autoMoveDirectory) throws IllegalArgumentException {
        directory = PathNormalizer.normalize((File)directory);
        this.checkIfManaged(directory);
        File file = directory;
        directory = PathNormalizer.normalize((File)autoMoveDirectory);
        this.autoMoveDirs.put(file, directory);
    }

    protected void checkIfManaged(File directory) {
        for (int i = 0; i < this.dirs.length; ++i) {
            if (!PathNormalizer.normalize((File)this.dirs[i]).equals(directory)) continue;
            return;
        }
        throw new IllegalArgumentException("The directory " + directory + " is not under control of the directory poller");
    }

    public void setVerbose(boolean v) {
        this.verbose = v;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setTimeBased(boolean v) {
        if (v) {
            if (this.filter != null && this.isTimeBased()) {
                return;
            }
            this.filter = new TimeFilter(this.originalFilter);
        } else {
            if (this.filter != null && !this.isTimeBased()) {
                return;
            }
            this.filter = this.originalFilter;
        }
    }

    public boolean isTimeBased() {
        return this.filter instanceof TimeFilter;
    }

    public void setBaseTime(File directory, long time) {
        for (int i = 0; i < this.dirs.length; ++i) {
            if (!this.dirs[i].getAbsolutePath().equals(directory.getAbsolutePath())) continue;
            this.baseTime[i] = time;
            return;
        }
        throw new IllegalArgumentException("'" + directory + "' is not under control of the poller");
    }

    public void setBaseTime(long time) {
        for (int i = 0; i < this.dirs.length; ++i) {
            this.setBaseTime(this.dirs[i], time);
        }
    }

    public long getBaseTime(File directory) {
        for (int i = 0; i < this.dirs.length; ++i) {
            if (!this.dirs[i].getAbsolutePath().equals(directory.getAbsolutePath())) continue;
            return this.baseTime[i];
        }
        throw new IllegalArgumentException("'" + directory + "' is not under control of the poller");
    }

    public boolean isPollingTimeBased() {
        return this.isTimeBased() && this.timeBasedOnLastLookup;
    }

    public void setPollingTimeBased(boolean v) {
        this.timeBasedOnLastLookup = v;
    }

    public void setSendSingleFileEvent(boolean v) {
        this.sendSingleFileEvent = v;
    }

    public boolean isSendSingleFileEvent() {
        return this.sendSingleFileEvent;
    }

    public long getPollInterval() {
        return this.pollInterval;
    }

    public void setPollInterval(long pollInterval) {
        this.pollInterval = pollInterval;
    }

    public void setStartBySleeping(boolean v) {
        this.startBySleeping = v;
    }

    public boolean isStartBySleeping() {
        return this.startBySleeping;
    }

    public void addPollManager(PollManager pm) {
        this.pollManagersList.add(pm);
        this.addListener((Listener)new DefaultListener(this, pm));
    }

    public void shutdown() {
        this.shutdownRequested = true;
        this.interrupt();
        if (this.verbose) {
            System.out.println("Polling shutdown requested");
        }
    }

    public boolean isShuttingDown() {
        return this.shutdownRequested;
    }

    public synchronized void run() {
        System.out.println("******************************************************");
        System.out.println("* DirectoryPoller 1.5 (C) Cristiano Sadun under LGPL *");
        System.out.println("******************************************************");
        this.shutdownRequested = false;
        if (this.dirs == null) {
            throw new IllegalStateException("Programming error: no directories to poll specified");
        }
        if (this.verbose) {
            System.out.println("Polling started, interval is " + this.pollInterval + "ms");
        }
        if (this.autoMove) {
            for (int j = 0; j < this.dirs.length; ++j) {
                File automoveDir = PathNormalizer.normalize((File)this.getAutoMoveDirectory(this.dirs[j]));
                if (automoveDir.exists()) continue;
                if (this.verbose) {
                    System.out.println("Automove directory " + automoveDir + " does not exist, attempting to create.");
                }
                if (!automoveDir.mkdirs()) {
                    throw new RuntimeException("Could not create the directory " + automoveDir.getAbsolutePath());
                }
                if (!this.verbose) continue;
                System.out.println("Automove directory " + automoveDir + " created successfully.");
            }
        }
        do {
            if (this.startBySleeping) {
                this.startBySleeping = false;
            } else {
                this.runCycle();
            }
            if (this.shutdownRequested) continue;
            try {
                DirectoryPoller.sleep((long)this.pollInterval);
                if (!this.verbose) continue;
                System.out.println("Poller waking up");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!this.shutdownRequested);
        if (this.verbose) {
            System.out.println("Poller terminated.");
        }
    }

    private void runCycle() {
        if (!this.shutdownRequested) {
            this.notify((Signal)new CycleStartEvent(this));
        }
        if (!this.shutdownRequested) {
            this.currentDir = 0;
            while (this.currentDir < this.dirs.length) {
                File dir;
                File originalDir = dir = PathNormalizer.normalize((File)this.dirs[this.currentDir]);
                this.notify((Signal)new DirectoryLookupStartEvent(this, dir));
                if (this.shutdownRequested) {
                    return;
                }
                long filesLookupTime = System.currentTimeMillis();
                File[] fls = dir.listFiles(this.filter);
                if (this.filesSortComparator != null) {
                    if (this.verbose) {
                        System.out.println("Sorting files by  " + this.filesSortComparator);
                    }
                    Arrays.sort(fls, this.filesSortComparator);
                }
                String[] files = new String[fls.length];
                for (int i = 0; i < files.length; ++i) {
                    files[i] = fls[i].getName();
                }
                String[] movedFiles = new String[files.length];
                int failedToMoveCount = 0;
                if (this.autoMove) {
                    File autoMoveDir = this.getAutoMoveDirectory(dir);
                    for (int j = 0; j < files.length; ++j) {
                        File orig = new File(dir, files[j]);
                        File dest = new File(autoMoveDir, files[j]);
                        if (dest.exists()) {
                            if (this.verbose) {
                                System.out.println("[Automove] Attempting to delete existing " + dest.getAbsolutePath());
                            }
                            if (!dest.delete()) {
                                this.notify((Signal)new ExceptionSignal((Exception)new AutomoveDeleteException(orig, dest, "Could not delete " + dest.getAbsolutePath()), (Object)this));
                                ++failedToMoveCount;
                                continue;
                            }
                            if (this.verbose) {
                                System.out.println("[Automove] Deleted " + dest.getAbsolutePath());
                            }
                        }
                        if (this.verbose) {
                            System.out.println("[Automove] Moving " + orig.getAbsolutePath() + " to " + autoMoveDir.getAbsolutePath() + File.separator);
                        }
                        autoMoveDir.mkdirs();
                        try {
                            boolean proceed;
                            if (this.bypassLockedFiles) {
                                RandomAccessFile raf = new RandomAccessFile(orig, "rw");
                                FileChannel channel = raf.getChannel();
                                if (channel.tryLock() == null) {
                                    if (this.verbose) {
                                        System.out.println("[Automove] File " + orig.getAbsolutePath() + " is locked, ignoring");
                                    }
                                    ++failedToMoveCount;
                                    proceed = false;
                                } else {
                                    proceed = true;
                                }
                                channel.close();
                            } else {
                                proceed = true;
                            }
                            if (!proceed) continue;
                            if (!orig.renameTo(dest)) {
                                this.notify((Signal)new ExceptionSignal((Exception)new AutomoveException(orig, dest, "Could not move " + orig.getName() + " to " + dest.getAbsolutePath()), (Object)this));
                                ++failedToMoveCount;
                                continue;
                            }
                            this.notify((Signal)new FileMovedEvent(this, orig, dest));
                            movedFiles[j] = dest.getName();
                            if (j + 1 == files.length) {
                                dir = autoMoveDir;
                            }
                            if (!this.verbose) continue;
                            System.out.println("[Automove] Moved " + orig.getAbsolutePath() + " to " + autoMoveDir.getAbsolutePath() + File.separator);
                            continue;
                        }
                        catch (FileNotFoundException e) {
                            this.notify((Signal)new ExceptionSignal((Exception)new AutomoveException(orig, dest, "Could not verify lock on " + orig.getName()), (Object)this));
                            ++failedToMoveCount;
                            continue;
                        }
                        catch (IOException e) {
                            this.notify((Signal)new ExceptionSignal((Exception)new AutomoveException(orig, dest, "Tentative lock attempt failed on " + orig.getName()), (Object)this));
                            ++failedToMoveCount;
                        }
                    }
                }
                if (this.autoMove) {
                    String[] tmp = new String[files.length - failedToMoveCount];
                    int c = 0;
                    for (int i = 0; i < movedFiles.length; ++i) {
                        if (movedFiles[i] == null) continue;
                        tmp[c++] = movedFiles[i];
                    }
                    files = tmp;
                }
                if (files.length > 0) {
                    this.notify((Signal)new FileSetFoundEvent(this, dir, files));
                }
                if (this.shutdownRequested) {
                    return;
                }
                if (this.sendSingleFileEvent) {
                    for (int j = 0; j < files.length; ++j) {
                        File file = new File(dir, files[j]);
                        this.notify((Signal)new FileFoundEvent(this, file));
                        if (!this.shutdownRequested) continue;
                        return;
                    }
                    if (this.shutdownRequested) {
                        return;
                    }
                }
                if (this.isTimeBased()) {
                    if (this.verbose) {
                        System.out.println("Computing new base time");
                    }
                    if (this.timeBasedOnLastLookup) {
                        this.baseTime[this.currentDir] = filesLookupTime;
                    } else {
                        for (int j = 0; j < files.length; ++j) {
                            File file = new File(dir, files[j]);
                            long lastModifiedTime = file.lastModified();
                            if (lastModifiedTime <= this.baseTime[this.currentDir]) continue;
                            this.baseTime[this.currentDir] = lastModifiedTime;
                        }
                        if (this.verbose) {
                            System.out.println("Basetime for " + this.dirs[this.currentDir] + " is " + this.baseTime[this.currentDir]);
                        }
                    }
                }
                this.notify((Signal)new DirectoryLookupEndEvent(this, originalDir));
                ++this.currentDir;
            }
        }
        if (!this.shutdownRequested) {
            this.notify((Signal)new CycleEndEvent(this, this.baseTime));
        }
    }

    public FilenameFilter getFilter() {
        return this.filter;
    }

    public void setFilter(FilenameFilter filter) {
        if (this.isAlive()) {
            throw new IllegalStateException("Can't call setFilter when the poller has already started");
        }
        this.filter = filter;
    }

    public Comparator getFilesSortComparator() {
        return this.filesSortComparator;
    }

    public void setFilesSortComparator(Comparator filesSortComparator) {
        this.filesSortComparator = filesSortComparator;
    }

    public boolean isBypassLockedFiles() {
        return this.bypassLockedFiles;
    }

    public void setBypassLockedFiles(boolean supportSlowTransfer) {
        this.bypassLockedFiles = supportSlowTransfer;
    }

    public static class FileSizeComparator
    extends BidirectionalComparator {
        public FileSizeComparator(boolean ascending) {
            super(ascending);
        }

        protected final long getComparisonValue(File f1, File f2) {
            return f1.length() - f2.length();
        }
    }

    public static class ModificationTimeComparator
    extends BidirectionalComparator {
        public ModificationTimeComparator(boolean ascending) {
            super(ascending);
        }

        protected final long getComparisonValue(File f1, File f2) {
            return f1.lastModified() - f2.lastModified();
        }
    }

    public static final class NullFilenameFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return true;
        }

        public String toString() {
            return "null filter";
        }
    }

    private class TimeFilter
    implements FilenameFilter {
        private FilenameFilter additionalFilter;

        public TimeFilter(FilenameFilter additionalFilter) {
            this.additionalFilter = additionalFilter;
        }

        public boolean accept(File dir, String name) {
            File f = new File(dir, name);
            if (f.isDirectory()) {
                return false;
            }
            if (f.lastModified() <= DirectoryPoller.this.baseTime[DirectoryPoller.this.currentDir]) {
                if (DirectoryPoller.this.verbose) {
                    System.out.println(name + "(" + f.lastModified() + "): out of base time (" + DirectoryPoller.this.baseTime[DirectoryPoller.this.currentDir] + "), ignoring");
                }
                return false;
            }
            if (DirectoryPoller.this.verbose) {
                System.out.println(name + "(" + f.lastModified() + "): older than base time (" + DirectoryPoller.this.baseTime[DirectoryPoller.this.currentDir] + "), accepted");
            }
            return this.additionalFilter.accept(dir, name);
        }
    }

    private static class DirectoryFilter
    implements FilenameFilter {
        FilenameFilter additionalFilter;

        DirectoryFilter(FilenameFilter additionalFilter) {
            this.additionalFilter = additionalFilter;
        }

        public boolean accept(File dir, String name) {
            if (new File(dir, name).isDirectory()) {
                return false;
            }
            return this.additionalFilter.accept(dir, name);
        }

        public String toString() {
            return "Directory filter over a " + this.additionalFilter;
        }

        FilenameFilter getAdditionalFilter() {
            return this.additionalFilter;
        }
    }

    public class AutomoveDeleteException
    extends AutomoveException {
        AutomoveDeleteException(File origin, File dest, String msg) {
            super(origin, dest, msg);
        }
    }

    public class AutomoveException
    extends Exception {
        private File origin;
        private File dest;

        AutomoveException(File origin, File dest, String msg) {
            super(msg);
            this.origin = origin;
            this.dest = dest;
            if (DirectoryPoller.this.verbose) {
                System.out.println("[Automove] Exception: " + msg);
            }
        }

        public DirectoryPoller getPoller() {
            return DirectoryPoller.this;
        }

        public File getOrigin() {
            return this.origin;
        }

        public File getDestination() {
            return this.dest;
        }
    }
}

