/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.polling;

import com.deltax.util.listener.ExceptionListener;
import com.deltax.util.listener.ExceptionSignal;
import com.deltax.util.listener.Signal;
import org.sadun.util.polling.CycleEndEvent;
import org.sadun.util.polling.CycleStartEvent;
import org.sadun.util.polling.DirectoryLookupEndEvent;
import org.sadun.util.polling.DirectoryLookupStartEvent;
import org.sadun.util.polling.DirectoryPoller;
import org.sadun.util.polling.FileFoundEvent;
import org.sadun.util.polling.FileMovedEvent;
import org.sadun.util.polling.FileSetFoundEvent;
import org.sadun.util.polling.PollManager;

class DefaultListener
implements ExceptionListener {
    private PollManager mgt;
    DirectoryPoller poller;

    DefaultListener(DirectoryPoller poller, PollManager mgt) {
        this.poller = poller;
        this.mgt = mgt;
    }

    public void receive(Signal evt) {
        if (this.poller.isShuttingDown()) {
            return;
        }
        if (evt instanceof CycleStartEvent) {
            this.mgt.cycleStarted((CycleStartEvent)evt);
            return;
        }
        if (evt instanceof CycleEndEvent) {
            this.mgt.cycleEnded((CycleEndEvent)evt);
            return;
        }
        if (evt instanceof DirectoryLookupStartEvent) {
            this.mgt.directoryLookupStarted((DirectoryLookupStartEvent)evt);
            return;
        }
        if (evt instanceof DirectoryLookupEndEvent) {
            this.mgt.directoryLookupEnded((DirectoryLookupEndEvent)evt);
            return;
        }
        if (evt instanceof FileMovedEvent) {
            this.mgt.fileMoved((FileMovedEvent)evt);
            return;
        }
        if (evt instanceof FileSetFoundEvent) {
            this.mgt.fileSetFound((FileSetFoundEvent)evt);
            return;
        }
        if (evt instanceof FileFoundEvent) {
            this.mgt.fileFound((FileFoundEvent)evt);
            return;
        }
        throw new RuntimeException("Unexpected signal " + evt);
    }

    public void receiveException(ExceptionSignal evt) {
        if (evt.getException() instanceof DirectoryPoller.AutomoveDeleteException) {
            DirectoryPoller.AutomoveException e = (DirectoryPoller.AutomoveException)evt.getException();
            this.mgt.exceptionDeletingTargetFile(e.getDestination());
        } else if (evt.getException() instanceof DirectoryPoller.AutomoveException) {
            DirectoryPoller.AutomoveException e = (DirectoryPoller.AutomoveException)evt.getException();
            this.mgt.exceptionMovingFile(e.getOrigin(), e.getDestination());
        } else {
            throw new RuntimeException("Unexpected exception " + evt.getException());
        }
    }
}

