/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util.polling;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.management.Notification;
import javax.management.ObjectName;
import org.sadun.util.MovedFile;
import org.sadun.util.polling.BasePollerEvent;
import org.sadun.util.polling.SequenceNumberGenerator;

abstract class BaseJMXNotification
extends Notification {
    protected BasePollerEvent event;

    protected BaseJMXNotification(String notificationType, ObjectName pollerName, SequenceNumberGenerator sqg, long timestamp) {
        super(notificationType, (Object)pollerName, sqg.getNextSequenceNumber(), timestamp);
    }

    protected BaseJMXNotification(String notificationType, ObjectName pollerName, SequenceNumberGenerator sqg, BasePollerEvent evt) {
        super(notificationType, (Object)pollerName, sqg.getNextSequenceNumber(), evt.getTime());
        this.commonInit(evt);
    }

    protected BaseJMXNotification(String notificationType, ObjectName pollerName, SequenceNumberGenerator sqg, BasePollerEvent evt, String message) {
        super(notificationType, pollerName, sqg.getNextSequenceNumber(), evt.getTime(), message);
        this.commonInit(evt);
    }

    private void commonInit(BasePollerEvent evt) {
        this.event = evt;
    }

    protected BasePollerEvent getEvent() {
        return this.event;
    }

    /*
     * WARNING - void declaration
     */
    protected static String mkMsg(BasePollerEvent evt, String propertyName) {
        try {
            void var4_5;
            File file;
            Method m = ((Object)((Object)evt)).getClass().getMethod("get" + propertyName, new Class[0]);
            Object obj = m.invoke((Object)evt, new Object[0]);
            if (obj instanceof File) {
                file = (File)obj;
            } else if (obj instanceof MovedFile) {
                file = ((MovedFile)obj).getDestinationPath().getCanonicalFile();
            } else {
                throw new RuntimeException("Internal error: only File or MovedFile objects are expected by this method");
            }
            try {
                return var4_5.getCanonicalPath();
            }
            catch (IOException e) {
                return var4_5.getAbsolutePath();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Internal error: only events with a get" + propertyName + "() method should be passed to this class. The passed event has class " + ((Object)((Object)evt)).getClass(), e);
        }
    }

    public long getPollerEventTime() {
        return this.event.getTime();
    }
}

