/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.util;

import java.io.File;

public class MovedFile {
    private File original;
    private File destination;
    private boolean isOriginal;
    private boolean autoSync;

    public MovedFile(File original, File destination, boolean isOriginal) {
        this.original = original;
        this.destination = destination;
        this.isOriginal = isOriginal;
    }

    public MovedFile(File original, File destination) {
        this(original, destination, MovedFile.detectIsOriginal(original, destination));
    }

    public void setAutosync(boolean v) {
        this.autoSync = v;
    }

    public boolean getAutosync() {
        return this.autoSync;
    }

    public synchronized boolean invert() {
        if (this.autoSync) {
            this.sync();
        }
        return this.invert();
    }

    private boolean invert0() {
        File f1 = this.isOriginal ? this.original : this.destination;
        File f2 = this.isOriginal ? this.destination : this.original;
        return f1.renameTo(f2);
    }

    public synchronized boolean revert() {
        if (this.autoSync) {
            this.sync();
        }
        if (this.isOriginal) {
            throw new RuntimeException("File already reverted:" + this.original.getAbsolutePath());
        }
        return this.invert0();
    }

    public synchronized boolean moveAgain() {
        if (this.autoSync) {
            this.sync();
        }
        if (!this.isOriginal) {
            throw new RuntimeException("File already moved:" + this.destination.getAbsolutePath());
        }
        return this.invert0();
    }

    public void sync() {
        this.isOriginal = MovedFile.detectIsOriginal(this.original, this.destination);
    }

    public boolean isMoved() {
        if (this.autoSync) {
            this.sync();
        }
        return !this.isOriginal;
    }

    public File getOriginalPath() {
        return this.original;
    }

    public File getDestinationPath() {
        return this.destination;
    }

    private static boolean detectIsOriginal(File original, File destination) {
        boolean e2;
        boolean e1 = original.exists();
        if (e1 && (e2 = destination.exists())) {
            throw new RuntimeException("Both " + original.getAbsolutePath() + " and " + destination.getAbsolutePath() + " exist. Can't auto detect state for MovedFile object");
        }
        return e1;
    }
}

