/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.tag;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.el.LegacyValueBinding;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributeException;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagException;
import com.sun.facelets.tag.TagHandler;
import java.io.IOException;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.el.ValueBinding;
import org.ajax4jsf.framework.ajax.AjaxListener;
import org.ajax4jsf.framework.ajax.AjaxListenerHelper;
import org.ajax4jsf.framework.ajax.AjaxSource;
import org.ajax4jsf.framework.util.message.Messages;

public final class AjaxListenerHandler
extends TagHandler {
    private Class listenerType;
    private final TagAttribute type;
    private final TagAttribute binding = this.getAttribute("binding");

    public AjaxListenerHandler(TagConfig config) {
        super(config);
        this.type = this.getRequiredAttribute("type");
        if (this.type != null) {
            if (!this.type.isLiteral()) {
                throw new TagAttributeException(this.tag, this.type, Messages.getMessage(Messages.MUST_BE_LITERAL_ERROR));
            }
            try {
                this.listenerType = Class.forName(this.type.getValue());
            }
            catch (Exception e) {
                throw new TagAttributeException(this.tag, this.type, (Throwable)e);
            }
        }
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (parent instanceof AjaxSource) {
            if (parent.getParent() == null) {
                AjaxSource src = (AjaxSource)parent;
                AjaxListener listener = null;
                ValueExpression ve = null;
                if (this.binding != null) {
                    ve = this.binding.getValueExpression(ctx, AjaxListener.class);
                    listener = new AjaxListenerHelper((ValueBinding)new LegacyValueBinding(ve));
                }
                if (listener == null) {
                    try {
                        listener = (AjaxListener)this.listenerType.newInstance();
                    }
                    catch (Exception e) {
                        throw new TagAttributeException(this.tag, this.type, e.getCause());
                    }
                    if (ve != null) {
                        ve.setValue((ELContext)ctx, (Object)ve);
                    }
                }
                src.addAjaxListener(listener);
            }
        } else {
            throw new TagException(this.tag, Messages.getMessage(Messages.NOT_PARENT_AJAX_CONTAINER_ERROR, parent));
        }
    }
}

