/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.Constants;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.java2d.FontMetricsMapper;
import org.apache.fop.render.java2d.RendererState;

public class Java2DGraphicsState
implements Constants,
RendererState {
    private Graphics2D currentGraphics;
    private BasicStroke currentStroke;
    private float currentStrokeWidth;
    private int currentStrokeStyle;
    private List stateStack = new ArrayList();
    private FontInfo fontInfo;
    private AffineTransform initialTransform;

    public Java2DGraphicsState(Graphics2D graphics, FontInfo fontInfo, AffineTransform at) {
        this.fontInfo = fontInfo;
        this.currentGraphics = graphics;
        this.initialTransform = at;
        this.currentGraphics.setTransform(at);
    }

    public Graphics2D getGraph() {
        return this.currentGraphics;
    }

    public void push() {
        Graphics2D tmpGraphics = (Graphics2D)this.currentGraphics.create();
        this.stateStack.add(tmpGraphics);
    }

    public Graphics2D pop() {
        if (this.getStackLevel() > 0) {
            Graphics2D popped;
            this.currentGraphics = popped = (Graphics2D)this.stateStack.remove(this.stateStack.size() - 1);
            return popped;
        }
        return null;
    }

    public int getStackLevel() {
        return this.stateStack.size();
    }

    public boolean updateColor(Color col) {
        if (!col.equals(this.getGraph().getColor())) {
            this.getGraph().setColor(col);
            return true;
        }
        return false;
    }

    public Color toColor(ColorType col) {
        return new Color(col.getRed(), col.getGreen(), col.getBlue());
    }

    public boolean updateColor(ColorType col, boolean fill, StringBuffer pdf) {
        if (col == null) {
            return false;
        }
        Color newCol = this.toColor(col);
        return this.updateColor(newCol);
    }

    public void updateColor(ColorType col) {
        if (col == null) {
            return;
        }
        Color newCol = this.toColor(col);
        this.updateColor(newCol);
    }

    public Color getColor() {
        return this.currentGraphics.getColor();
    }

    public boolean updateFont(String name, int size, StringBuffer pdf) {
        boolean updateSize;
        boolean updateName = !name.equals(this.getGraph().getFont().getFontName());
        boolean bl = updateSize = size != this.getGraph().getFont().getSize();
        if (updateName || updateSize) {
            FontMetricsMapper mapper = (FontMetricsMapper)this.fontInfo.getMetricsFor(name);
            Font font = mapper.getFont(size);
            this.currentGraphics.setFont(font);
            return true;
        }
        return false;
    }

    public Font getFont() {
        return this.currentGraphics.getFont();
    }

    public boolean updateStroke(float width, int style) {
        boolean update = false;
        if (width != this.currentStrokeWidth || style != this.currentStrokeStyle) {
            update = true;
            switch (style) {
                case 36: {
                    this.currentStroke = new BasicStroke(width, 0, 2, 0.0f, new float[]{2.0f}, 0.0f);
                    this.currentGraphics.setStroke(this.currentStroke);
                    this.currentStrokeWidth = width;
                    this.currentStrokeStyle = style;
                    break;
                }
                case 31: {
                    this.currentStroke = new BasicStroke(width, 0, 2, 0.0f, new float[]{8.0f, 2.0f}, 0.0f);
                    this.currentGraphics.setStroke(this.currentStroke);
                    this.currentStrokeWidth = width;
                    this.currentStrokeStyle = style;
                    break;
                }
                default: {
                    this.currentStroke = new BasicStroke(width);
                    this.currentGraphics.setStroke(this.currentStroke);
                    this.currentStrokeWidth = width;
                    this.currentStrokeStyle = style;
                }
            }
        }
        return update;
    }

    public BasicStroke getStroke() {
        return (BasicStroke)this.currentGraphics.getStroke();
    }

    public boolean updatePaint(Paint p) {
        if (this.getGraph().getPaint() == null) {
            if (p != null) {
                this.getGraph().setPaint(p);
                return true;
            }
        } else if (p.equals(this.getGraph().getPaint())) {
            this.getGraph().setPaint(p);
            return true;
        }
        return false;
    }

    public boolean checkClip(Shape cl) {
        return this.getGraph().getClip() == null ? cl != null : cl.equals(this.getGraph().getClip());
    }

    public boolean updateClip(Shape cl) {
        if (this.getGraph().getClip() != null) {
            Area newClip = new Area(this.getGraph().getClip());
            newClip.intersect(new Area(cl));
            this.getGraph().setClip(new GeneralPath(newClip));
        } else {
            this.getGraph().setClip(cl);
        }
        return true;
    }

    public boolean checkTransform(AffineTransform tf) {
        return !tf.equals(this.getGraph().getTransform());
    }

    public void setTransform(AffineTransform tf) {
        this.getGraph().setTransform(this.initialTransform);
        this.getGraph().transform(tf);
    }

    public void transform(AffineTransform tf) {
        this.getGraph().transform(tf);
    }

    public AffineTransform getTransform() {
        return this.getGraph().getTransform();
    }

    public String toString() {
        String s = "AWTGraphicsState " + this.currentGraphics.toString() + ", Stroke (width: " + this.currentStrokeWidth + " style: " + this.currentStrokeStyle + "), " + this.getTransform() + ", StackLevel: " + this.getStackLevel();
        return s;
    }
}

