/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.scanner;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.deployment.IncompleteDeploymentException;
import org.jboss.deployment.NetBootFile;
import org.jboss.deployment.NetBootHelper;
import org.jboss.deployment.scanner.HttpURLDeploymentScannerMBean;
import org.jboss.deployment.scanner.URLDeploymentScanner;
import org.jboss.util.NullArgumentException;

public class HttpURLDeploymentScanner
extends URLDeploymentScanner
implements HttpURLDeploymentScannerMBean {
    protected String defaultHttpDirectoryListerUrl = null;
    protected String httpDirectoryDownload = null;
    protected HttpLister defaultHttpLister = null;
    protected HashMap scannedHttpUrls = new HashMap();

    public String getDefaultHttpDirectoryListerUrl() {
        if (this.defaultHttpDirectoryListerUrl == null) {
            this.defaultHttpDirectoryListerUrl = NetBootHelper.getDefaultListUrl();
        }
        return this.defaultHttpDirectoryListerUrl;
    }

    public void setDefaultHttpDirectoryListerUrl(String url) {
        this.defaultHttpDirectoryListerUrl = url;
    }

    public String getDefaultHttpDirectoryDownloadUrl() {
        if (this.httpDirectoryDownload == null) {
            this.httpDirectoryDownload = NetBootHelper.getDefaultDownloadUrl();
        }
        return this.httpDirectoryDownload;
    }

    public void setDefaultHttpDirectoryDownloadUrl(String url) {
        this.httpDirectoryDownload = url;
    }

    public void setURLList(List list) {
    }

    public void setURLs(String listspec) throws MalformedURLException {
        if (listspec == null) {
            throw new NullArgumentException("listspec");
        }
        boolean debug = this.log.isDebugEnabled();
        LinkedList<URL> fileList = new LinkedList<URL>();
        StringTokenizer stok = new StringTokenizer(listspec, ",");
        while (stok.hasMoreTokens()) {
            URL url;
            String urlspec = stok.nextToken().trim();
            if (debug) {
                this.log.debug((Object)("Adding URL from spec: " + urlspec));
            }
            if (urlspec.startsWith("file:") || urlspec.startsWith("http:")) {
                url = this.makeURL(urlspec);
                if (debug) {
                    this.log.debug((Object)("File URL: " + url));
                }
                fileList.add(url);
                continue;
            }
            url = this.makeURL(urlspec);
            if (debug) {
                this.log.debug((Object)("HTTP URL: " + url));
            }
            this.addHttpDeployment(urlspec, this.getDefaultHttpDirectoryLister());
        }
        super.setURLList(fileList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void scan() throws Exception {
        DeployedRemoteURL du;
        super.scan();
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)"Scanning for new http deployments");
        }
        HashMap hashMap = this.scannedHttpUrls;
        synchronized (hashMap) {
            Iterator listers = this.getAllDeploymentListers().iterator();
            while (listers.hasNext()) {
                HttpLister lister = (HttpLister)listers.next();
                Iterator deployments = this.getHttpDeploymentsForLister(lister).iterator();
                while (deployments.hasNext()) {
                    HttpDeploymentFolder deploymentFolder = (HttpDeploymentFolder)deployments.next();
                    this.scanRemoteDirectory(deploymentFolder);
                }
            }
        }
        if (trace) {
            this.log.trace((Object)"Scanning existing deployments for removal or modification");
        }
        LinkedList<DeployedRemoteURL> removed = new LinkedList<DeployedRemoteURL>();
        LinkedList<DeployedRemoteURL> modified = new LinkedList<DeployedRemoteURL>();
        Iterator listers = this.getAllDeploymentListers().iterator();
        while (listers.hasNext()) {
            HttpLister lister = (HttpLister)listers.next();
            Iterator deployments = this.getHttpDeploymentsForLister(lister).iterator();
            while (deployments.hasNext()) {
                HttpDeploymentFolder deploymentFolder = (HttpDeploymentFolder)deployments.next();
                NetBootFile[] remoteFiles = NetBootHelper.listFilesFromDirectory(deploymentFolder.getCompleteListingUrl());
                Iterator deployedFiles = deploymentFolder.getDeployedFiles().iterator();
                while (deployedFiles.hasNext()) {
                    DeployedRemoteURL deployed = (DeployedRemoteURL)deployedFiles.next();
                    NetBootFile alreadyDeployed = this.findFileWithName(deployed.getFile().getName(), remoteFiles);
                    if (alreadyDeployed == null) {
                        removed.add(deployed);
                        continue;
                    }
                    if (alreadyDeployed.LastModified() <= deployed.getFile().LastModified()) continue;
                    deployed.updateFile(alreadyDeployed);
                    modified.add(deployed);
                }
            }
        }
        Iterator iter = removed.iterator();
        while (iter.hasNext()) {
            du = (DeployedRemoteURL)iter.next();
            this.undeploy(du);
        }
        iter = modified.iterator();
        while (iter.hasNext()) {
            du = (DeployedRemoteURL)iter.next();
            this.undeploy(du);
            this.deploy(du);
        }
        if (this.lastIncompleteDeploymentException != null) {
            try {
                Object[] args = new Object[]{};
                String[] sig = new String[]{};
                Object o = this.getServer().invoke(this.getDeployer(), "checkIncompleteDeployments", args, sig);
            }
            catch (Exception e) {
                this.log.error((Object)e);
            }
        }
    }

    protected void scanRemoteDirectory(HttpDeploymentFolder httpFolder) throws Exception {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("Scanning directory: " + httpFolder.getRelativeFolder()));
        }
        NetBootFile[] content = null;
        try {
            content = NetBootHelper.listFilesFromDirectory(httpFolder.getCompleteListingUrl());
        }
        catch (Exception e) {
            this.log.trace((Object)e);
            return;
        }
        LinkedList<URL> list = new LinkedList<URL>();
        HashMap<URL, NetBootFile> linkNameToObjects = new HashMap<URL, NetBootFile>();
        for (int i = 0; i < content.length; ++i) {
            NetBootFile found;
            if (trace) {
                this.log.trace((Object)("Checking deployment file: " + content[i]));
            }
            if ((found = this.findFileWithName(content[i].getName(), httpFolder.getDeployedFiles())) != null) continue;
            URL target = httpFolder.getUrlForFile(content[i]);
            list.add(target);
            linkNameToObjects.put(target, content[i]);
        }
        if (this.sorter != null) {
            this.updateSorter();
            Collections.sort(list, this.sorter);
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            URL url = (URL)iter.next();
            NetBootFile dep = (NetBootFile)linkNameToObjects.get(url);
            this.deploy(new DeployedRemoteURL(httpFolder, dep));
            iter.remove();
            if (this.sorter == null || !iter.hasNext() || !this.updateSorter()) continue;
            Collections.sort(list, this.sorter);
            iter = list.iterator();
        }
    }

    protected void undeploy(DeployedRemoteURL deployedUrl) {
        URL url = null;
        try {
            url = deployedUrl.getFolder().getUrlForFile(deployedUrl.getFile());
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Undeploying: " + url));
            }
            this.deployer.undeploy(url);
            deployedUrl.getFolder().removeDeployedFile(deployedUrl);
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to undeploy: " + url), (Throwable)e);
        }
    }

    protected void deploy(DeployedRemoteURL deployedUrl) throws MalformedURLException {
        URL url = deployedUrl.getFolder().getUrlForFile(deployedUrl.getFile());
        if (url == null) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Deploying: " + url));
        }
        try {
            this.deployer.deploy(url);
        }
        catch (IncompleteDeploymentException e) {
            this.lastIncompleteDeploymentException = e;
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to deploy: " + url), (Throwable)e);
        }
        deployedUrl.getFolder().addDeployedFile(deployedUrl);
    }

    protected NetBootFile findFileWithName(String name, NetBootFile[] files) {
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].getName().equals(name)) continue;
            return files[i];
        }
        return null;
    }

    protected NetBootFile findFileWithName(String name, List deployedRemoteURL) {
        NetBootFile[] tmp = new NetBootFile[deployedRemoteURL.size()];
        Iterator iter = deployedRemoteURL.iterator();
        int i = 0;
        while (iter.hasNext()) {
            DeployedRemoteURL url = (DeployedRemoteURL)iter.next();
            tmp[i] = url.getFile();
            ++i;
        }
        return this.findFileWithName(name, tmp);
    }

    protected synchronized void addHttpDeployment(String relativeName, HttpLister lister) {
        ArrayList<HttpDeploymentFolder> deps = (ArrayList<HttpDeploymentFolder>)this.scannedHttpUrls.get(lister);
        if (deps == null) {
            deps = new ArrayList<HttpDeploymentFolder>();
            this.scannedHttpUrls.put(lister, deps);
        }
        deps.add(new HttpDeploymentFolder(relativeName, lister));
    }

    protected List getHttpDeploymentsForLister(HttpLister lister) {
        ArrayList deps = (ArrayList)this.scannedHttpUrls.get(lister);
        if (deps == null) {
            deps = new ArrayList();
        }
        return deps;
    }

    protected Set getAllDeploymentListers() {
        return this.scannedHttpUrls.keySet();
    }

    protected HttpLister getDefaultHttpDirectoryLister() {
        if (this.defaultHttpLister == null) {
            this.defaultHttpLister = new HttpLister(this.getDefaultHttpDirectoryDownloadUrl(), this.getDefaultHttpDirectoryListerUrl());
        }
        return this.defaultHttpLister;
    }

    protected class DeployedRemoteURL {
        HttpDeploymentFolder folder = null;
        NetBootFile file = null;

        public DeployedRemoteURL(HttpDeploymentFolder folder, NetBootFile file) {
            this.folder = folder;
            this.file = file;
        }

        public HttpDeploymentFolder getFolder() {
            return this.folder;
        }

        public NetBootFile getFile() {
            return this.file;
        }

        public void updateFile(NetBootFile newer) {
            this.file = newer;
        }
    }

    protected class HttpDeploymentFolder {
        public String folder = null;
        public HttpLister myLister = null;
        public ArrayList deployedFiles = new ArrayList();

        public HttpDeploymentFolder(String folder, HttpLister accessor) {
            this.folder = folder;
            this.myLister = accessor;
        }

        public String getRelativeFolder() {
            return this.folder;
        }

        public HttpLister getAssociatedLister() {
            return this.myLister;
        }

        public void addDeployedFile(DeployedRemoteURL file) {
            this.deployedFiles.add(file);
        }

        public void removeDeployedFile(DeployedRemoteURL file) {
            this.deployedFiles.remove(file);
        }

        public List getDeployedFiles() {
            return this.deployedFiles;
        }

        public String getCompleteListingUrl() throws UnsupportedEncodingException {
            return NetBootHelper.buildListUrlForFolder(this.myLister.getHttpListerUrl(), this.folder);
        }

        public URL getUrlForFile(NetBootFile file) throws MalformedURLException {
            return new URL(NetBootHelper.buildDownloadUrlForFile(this.myLister.getDownloadUrl(), this.folder, file.getName()));
        }
    }

    protected class HttpLister {
        public String downloadUrl = null;
        public String httpListerUrl = null;

        public HttpLister(String download, String list) {
            this.downloadUrl = download;
            this.httpListerUrl = list;
        }

        public String getDownloadUrl() {
            return this.downloadUrl;
        }

        public String getHttpListerUrl() {
            return this.httpListerUrl;
        }

        public int hashCode() {
            return this.httpListerUrl.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof HttpLister) {
                return ((HttpLister)obj).httpListerUrl.equals(this.httpListerUrl);
            }
            return false;
        }
    }
}

