/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.threadpool;

import EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.Heap;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.util.Collections;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.util.collection.WeakValueHashMap;
import org.jboss.util.threadpool.BasicTaskWrapper;
import org.jboss.util.threadpool.BasicThreadPoolMBean;
import org.jboss.util.threadpool.BlockingMode;
import org.jboss.util.threadpool.MinPooledExecutor;
import org.jboss.util.threadpool.RunnableTaskWrapper;
import org.jboss.util.threadpool.Task;
import org.jboss.util.threadpool.TaskWrapper;
import org.jboss.util.threadpool.ThreadPool;
import org.jboss.util.threadpool.ThreadPoolFullException;
import org.jboss.util.threadpool.ThreadPoolStoppedException;

public class BasicThreadPool
implements ThreadPool,
BasicThreadPoolMBean {
    private static final ThreadGroup JBOSS_THREAD_GROUP = new ThreadGroup("JBoss Pooled Threads");
    private static final Map threadGroups = Collections.synchronizedMap(new WeakValueHashMap());
    private static final SynchronizedInt lastPoolNumber = new SynchronizedInt(0);
    private static Logger log = Logger.getLogger(BasicThreadPool.class);
    private String name;
    private int poolNumber;
    private BlockingMode blockingMode = BlockingMode.ABORT;
    private MinPooledExecutor executor;
    private BoundedLinkedQueue queue;
    private ThreadGroup threadGroup;
    private SynchronizedInt lastThreadNumber = new SynchronizedInt(0);
    private SynchronizedBoolean stopped = new SynchronizedBoolean(false);
    private Heap tasksWithTimeouts = new Heap(13);
    private TimeoutMonitor timeoutTask;
    private boolean trace = log.isTraceEnabled();

    public BasicThreadPool() {
        this("ThreadPool");
    }

    public BasicThreadPool(String name) {
        this(name, JBOSS_THREAD_GROUP);
    }

    public BasicThreadPool(String name, ThreadGroup threadGroup) {
        ThreadPoolThreadFactory factory = new ThreadPoolThreadFactory();
        this.queue = new BoundedLinkedQueue(1024);
        this.executor = new MinPooledExecutor((Channel)this.queue, 100);
        this.executor.setMinimumPoolSize(4);
        this.executor.setKeepAliveTime(60000L);
        this.executor.setThreadFactory(factory);
        this.executor.abortWhenBlocked();
        this.poolNumber = lastPoolNumber.increment();
        this.setName(name);
        this.threadGroup = threadGroup;
    }

    public void stop(boolean immediate) {
        log.debug("stop, immediate=" + immediate);
        this.stopped.set(true);
        if (immediate) {
            this.executor.shutdownNow();
        } else {
            this.executor.shutdownAfterProcessingCurrentlyQueuedTasks();
        }
    }

    public void waitForTasks() throws InterruptedException {
        this.executor.awaitTerminationAfterShutdown();
    }

    public void waitForTasks(long maxWaitTime) throws InterruptedException {
        this.executor.awaitTerminationAfterShutdown(maxWaitTime);
    }

    public void runTaskWrapper(TaskWrapper wrapper) {
        if (this.trace) {
            log.trace("runTaskWrapper, wrapper=" + wrapper);
        }
        if (this.stopped.get()) {
            wrapper.rejectTask(new ThreadPoolStoppedException("Thread pool has been stopped"));
            return;
        }
        wrapper.acceptTask();
        long completionTimeout = wrapper.getTaskCompletionTimeout();
        TimeoutInfo info = null;
        if (completionTimeout > 0L) {
            this.checkTimeoutMonitor();
            info = new TimeoutInfo(wrapper, completionTimeout);
            this.tasksWithTimeouts.insert((Object)info);
        }
        int waitType = wrapper.getTaskWaitType();
        switch (waitType) {
            case 2: {
                this.executeOnThread(wrapper);
                break;
            }
            default: {
                this.execute(wrapper);
            }
        }
        this.waitForTask(wrapper);
    }

    public void runTask(Task task) {
        BasicTaskWrapper wrapper = new BasicTaskWrapper(task);
        this.runTaskWrapper(wrapper);
    }

    public void run(Runnable runnable) {
        this.run(runnable, 0L, 0L);
    }

    public void run(Runnable runnable, long startTimeout, long completeTimeout) {
        RunnableTaskWrapper wrapper = new RunnableTaskWrapper(runnable, startTimeout, completeTimeout);
        this.runTaskWrapper(wrapper);
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPoolNumber() {
        return this.poolNumber;
    }

    public String getThreadGroupName() {
        return this.threadGroup.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadGroupName(String threadGroupName) {
        ThreadGroup group;
        Map map = threadGroups;
        synchronized (map) {
            group = (ThreadGroup)threadGroups.get(threadGroupName);
            if (group == null) {
                group = new ThreadGroup(JBOSS_THREAD_GROUP, threadGroupName);
                threadGroups.put(threadGroupName, group);
            }
        }
        this.threadGroup = group;
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public int getMaximumQueueSize() {
        return this.queue.capacity();
    }

    public void setMaximumQueueSize(int size) {
        this.queue.setCapacity(size);
    }

    public int getPoolSize() {
        return this.executor.getPoolSize();
    }

    public int getMinimumPoolSize() {
        return this.executor.getMinimumPoolSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinimumPoolSize(int size) {
        MinPooledExecutor minPooledExecutor = this.executor;
        synchronized (minPooledExecutor) {
            this.executor.setKeepAliveSize(size);
            if (this.executor.getMaximumPoolSize() < size) {
                this.executor.setMinimumPoolSize(size);
                this.executor.setMaximumPoolSize(size);
            }
        }
    }

    public int getMaximumPoolSize() {
        return this.executor.getMaximumPoolSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumPoolSize(int size) {
        MinPooledExecutor minPooledExecutor = this.executor;
        synchronized (minPooledExecutor) {
            this.executor.setMinimumPoolSize(size);
            this.executor.setMaximumPoolSize(size);
            if (this.executor.getKeepAliveSize() > size) {
                this.executor.setKeepAliveSize(size);
            }
        }
    }

    public long getKeepAliveTime() {
        return this.executor.getKeepAliveTime();
    }

    public void setKeepAliveTime(long time) {
        this.executor.setKeepAliveTime(time);
    }

    public BlockingMode getBlockingMode() {
        return this.blockingMode;
    }

    public void setBlockingMode(BlockingMode mode) {
        this.blockingMode = mode;
        if (this.blockingMode == BlockingMode.RUN) {
            this.executor.runWhenBlocked();
        } else if (this.blockingMode == BlockingMode.WAIT) {
            this.executor.waitWhenBlocked();
        } else if (this.blockingMode == BlockingMode.DISCARD) {
            this.executor.discardWhenBlocked();
        } else if (this.blockingMode == BlockingMode.DISCARD_OLDEST) {
            this.executor.discardOldestWhenBlocked();
        } else if (this.blockingMode == BlockingMode.ABORT) {
            this.executor.abortWhenBlocked();
        } else {
            throw new IllegalArgumentException("Failed to recognize mode: " + mode);
        }
    }

    public void setBlockingMode(String name) {
        this.blockingMode = BlockingMode.toBlockingMode(name);
        if (this.blockingMode == null) {
            this.blockingMode = BlockingMode.ABORT;
        }
    }

    public void setBlockingModeString(String name) {
        this.blockingMode = BlockingMode.toBlockingMode(name);
        if (this.blockingMode == null) {
            this.blockingMode = BlockingMode.ABORT;
        }
    }

    public ThreadPool getInstance() {
        return this;
    }

    public void stop() {
        this.stop(false);
    }

    public String toString() {
        return this.name + '(' + this.poolNumber + ')';
    }

    protected void executeOnThread(TaskWrapper wrapper) {
        if (this.trace) {
            log.trace("executeOnThread, wrapper=" + wrapper);
        }
        wrapper.run();
    }

    protected void execute(TaskWrapper wrapper) {
        if (this.trace) {
            log.trace("execute, wrapper=" + wrapper);
        }
        try {
            this.executor.execute(wrapper);
        }
        catch (Throwable t) {
            wrapper.rejectTask(new ThreadPoolFullException(t.toString()));
        }
    }

    protected void waitForTask(TaskWrapper wrapper) {
        wrapper.waitForTask();
    }

    protected synchronized void checkTimeoutMonitor() {
        if (this.timeoutTask == null) {
            this.timeoutTask = new TimeoutMonitor(this.name, log);
        }
    }

    protected TimeoutInfo getNextTimeout() {
        TimeoutInfo info = (TimeoutInfo)this.tasksWithTimeouts.extract();
        return info;
    }

    private class TimeoutMonitor
    implements Runnable {
        final Logger log;

        TimeoutMonitor(String name, Logger log) {
            this.log = log;
            Thread t = new Thread((Runnable)this, name + " TimeoutMonitor");
            t.setDaemon(true);
            t.start();
        }

        public void run() {
            boolean isStopped = BasicThreadPool.this.stopped.get();
            while (!isStopped) {
                boolean trace = this.log.isTraceEnabled();
                try {
                    TimeoutInfo info = BasicThreadPool.this.getNextTimeout();
                    if (info != null) {
                        TaskWrapper wrapper;
                        long now = System.currentTimeMillis();
                        long timeToTimeout = info.getTaskCompletionTimeout(now);
                        if (timeToTimeout > 0L) {
                            if (trace) {
                                this.log.trace("Will check wrapper=" + info.getTaskWrapper() + " after " + timeToTimeout);
                            }
                            Thread.sleep(timeToTimeout);
                        }
                        if (!(wrapper = info.getTaskWrapper()).isComplete()) {
                            if (trace) {
                                this.log.trace("Failed completion check for wrapper=" + wrapper);
                            }
                            if (info.stopTask()) {
                                info.setTimeout(1000L);
                                BasicThreadPool.this.tasksWithTimeouts.insert((Object)info);
                                if (trace) {
                                    this.log.trace("Rescheduled completion check for wrapper=" + wrapper);
                                }
                            }
                        }
                    } else {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    this.log.debug("Timeout monitor has been interrupted", e);
                }
                catch (Throwable e) {
                    this.log.debug("Timeout monitor saw unexpected error", e);
                }
                isStopped = BasicThreadPool.this.stopped.get();
            }
        }
    }

    private static class TimeoutInfo
    implements Comparable {
        long start = System.currentTimeMillis();
        long timeoutMS;
        TaskWrapper wrapper;
        boolean firstStop;

        TimeoutInfo(TaskWrapper wrapper, long timeout) {
            this.timeoutMS = this.start + timeout;
            this.wrapper = wrapper;
        }

        public void setTimeout(long timeout) {
            this.start = System.currentTimeMillis();
            this.timeoutMS = this.start + timeout;
        }

        public int compareTo(Object o) {
            TimeoutInfo ti = (TimeoutInfo)o;
            long to0 = this.timeoutMS;
            long to1 = ti.timeoutMS;
            int diff = (int)(to0 - to1);
            return diff;
        }

        TaskWrapper getTaskWrapper() {
            return this.wrapper;
        }

        public long getTaskCompletionTimeout() {
            return this.wrapper.getTaskCompletionTimeout();
        }

        public long getTaskCompletionTimeout(long now) {
            return this.timeoutMS - now;
        }

        public boolean stopTask() {
            this.wrapper.stopTask();
            boolean wasFirstStop = !this.firstStop;
            this.firstStop = true;
            return wasFirstStop;
        }
    }

    private class ThreadPoolThreadFactory
    implements ThreadFactory {
        private ThreadPoolThreadFactory() {
        }

        public Thread newThread(Runnable runnable) {
            String threadName = BasicThreadPool.this.toString() + "-" + BasicThreadPool.this.lastThreadNumber.increment();
            Thread thread = new Thread(BasicThreadPool.this.threadGroup, runnable, threadName);
            thread.setDaemon(true);
            return thread;
        }
    }
}

