/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.Permission;
import java.security.Principal;
import java.util.Hashtable;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.plugins.AuthorizationManagerServiceMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.CachePolicy;
import org.jboss.util.TimedCachePolicy;

public class AuthorizationManagerService
extends ServiceMBeanSupport
implements AuthorizationManagerServiceMBean {
    private static Logger log = Logger.getLogger(AuthorizationManagerService.class);
    private static String authorizationMgrClassName = "org.jboss.security.plugins.AuthorizationManager";
    private static Class authorizationMgrClass;
    private static Hashtable authorizationManagersMap;
    private static int defaultCacheTimeout;
    private static int defaultCacheResolution;

    public void setAuthorizationManagerClassName(String className) throws ClassNotFoundException, ClassCastException {
        ClassLoader loader;
        authorizationMgrClassName = className;
        if (!AuthorizationManager.class.isAssignableFrom(authorizationMgrClass = (loader = Thread.currentThread().getContextClassLoader()).loadClass(authorizationMgrClassName))) {
            throw new ClassCastException(authorizationMgrClass + " does not implement " + AuthorizationManager.class);
        }
    }

    public String getAuthorizationManagerClassName() {
        return authorizationMgrClassName;
    }

    public boolean hasPermission(Permission perm, Principal principal) {
        return false;
    }

    public boolean doesUserHaveRole(String roleName) {
        return false;
    }

    protected void startService() throws Exception {
        super.startService();
    }

    protected void stopService() throws Exception {
        super.stopService();
    }

    public Set getUserRoles(Principal principal) {
        String str = "Use getAuthorizationManager method and then call getUserRoles";
        throw new IllegalStateException(str);
    }

    public Principal getPrincipal(Principal principal) {
        String str = "Use getAuthorizationManager method and then call getPrincipal";
        throw new IllegalStateException(str);
    }

    public AuthorizationManager getAuthorizationManager(String securityDomain) {
        AuthorizationManager amanager = (AuthorizationManager)authorizationManagersMap.get(securityDomain);
        if (amanager == null) {
            amanager = AuthorizationManagerService.newAuthorizationManager(securityDomain);
            authorizationManagersMap.put(securityDomain, amanager);
            log.debug("Added " + securityDomain + ", " + amanager + " to map");
        }
        return amanager;
    }

    private static AuthorizationManager newAuthorizationManager(String securityDomain) {
        AuthorizationManager securityMgr = null;
        try {
            Class[] parameterTypes = new Class[]{String.class};
            Constructor ctor = authorizationMgrClass.getConstructor(parameterTypes);
            Object[] args = new Object[]{securityDomain};
            securityMgr = (AuthorizationManager)ctor.newInstance(args);
            log.debug("Created AuthorizationManager=" + securityMgr);
            TimedCachePolicy cachePolicy = new TimedCachePolicy(defaultCacheTimeout, true, defaultCacheResolution);
            cachePolicy.create();
            cachePolicy.start();
            AuthorizationManagerService.setSecurityDomainCache(securityMgr, cachePolicy);
        }
        catch (Exception e2) {
            String msg = "Failed to create authz mgr('" + securityDomain + "'), authorizationMgrClass=" + authorizationMgrClass;
            log.error(msg, e2);
        }
        return securityMgr;
    }

    private static void setSecurityDomainCache(AuthorizationManager securityMgr, CachePolicy cachePolicy) {
        try {
            Class[] setCachePolicyTypes = new Class[]{CachePolicy.class};
            Method m = authorizationMgrClass.getMethod("setCachePolicy", setCachePolicyTypes);
            Object[] setCachePolicyArgs = new Object[]{cachePolicy};
            m.invoke((Object)securityMgr, setCachePolicyArgs);
            log.debug("setCachePolicy, c=" + setCachePolicyArgs[0]);
        }
        catch (Exception e2) {
            log.debug("setCachePolicy failed", e2);
        }
    }

    static {
        authorizationManagersMap = new Hashtable();
        defaultCacheTimeout = 1800;
        defaultCacheResolution = 60;
    }
}

