/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.login;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.security.auth.container.config.AuthModuleEntry;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.auth.login.LoginModuleStackHolder;

public class JASPIAuthenticationInfo
extends BaseAuthenticationInfo {
    Map loginModuleStack = Collections.synchronizedMap(new HashMap());

    public JASPIAuthenticationInfo() {
    }

    public JASPIAuthenticationInfo(String name) {
        super(name);
    }

    public void add(LoginModuleStackHolder lmsHolder) {
        this.loginModuleStack.put(lmsHolder.getName(), lmsHolder);
    }

    public void add(AuthModuleEntry ame) {
        this.modules.add(ame);
    }

    public AuthModuleEntry[] getAuthModuleEntry() {
        AuthModuleEntry[] entries = new AuthModuleEntry[this.modules.size()];
        this.modules.toArray(entries);
        return entries;
    }

    public LoginModuleStackHolder getLoginModuleStackHolder(String name) {
        LoginModuleStackHolder info = (LoginModuleStackHolder)this.loginModuleStack.get(name);
        return info;
    }

    public LoginModuleStackHolder removeLoginModuleStackHolder(String name) {
        LoginModuleStackHolder info = (LoginModuleStackHolder)this.loginModuleStack.remove(name);
        return info;
    }

    public void copy(JASPIAuthenticationInfo pc) {
        this.loginModuleStack.putAll(pc.loginModuleStack);
        this.modules.addAll(pc.modules);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("AuthModuleEntry[]:\n");
        for (int i = 0; i < this.modules.size(); ++i) {
            AuthModuleEntry entry = (AuthModuleEntry)this.modules.get(i);
            buffer.append("[" + i + "]");
            buffer.append("\nAuthModule Class: " + entry.getAuthModuleName());
            buffer.append("\nOptions:");
            Map options = entry.getOptions();
            Iterator iter = options.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry e = iter.next();
                buffer.append("name=" + e.getKey());
                buffer.append(", value=" + e.getValue());
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }
}

