/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployment.ds;

import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.resource.deployment.ds.metadata.AbstractConnectionFactoryDefinitionMetaData;
import org.jboss.resource.deployment.ds.metadata.AvailabilitySupport;
import org.jboss.resource.deployment.ds.metadata.AvailabilitySupportFactory;
import org.jboss.resource.deployment.ds.metadata.ConnectionFactoryMetaDataFactory;
import org.jboss.resource.deployment.ds.metadata.ConnectionPoolMetaData;
import org.jboss.resource.deployment.ds.metadata.DataSourceDefinitionMetaData;
import org.jboss.resource.deployment.ds.metadata.DataSourceMetaData;
import org.jboss.resource.deployment.ds.metadata.PreparedStatementMetaData;
import org.jboss.resource.deployment.ds.metadata.SqlSupportMetaData;
import org.jboss.resource.deployment.ds.metadata.TransactionSupport;
import org.jboss.resource.deployment.ds.metadata.TransactionSupportFactory;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class DsObjectModelFactory
implements ObjectModelFactory {
    private static final Logger log = Logger.getLogger(DsObjectModelFactory.class);
    private static final List preparedStatementElementNames = new ArrayList();
    private static final List connectionPoolElementNames = new ArrayList();
    private static final List sqlSupportElementNames = new ArrayList();
    private static final List connectionFactoryElementNames = new ArrayList();
    private boolean trace = log.isTraceEnabled();

    public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if (!localName.equals("datasources") && !localName.equals("connection-factories")) {
            throw new IllegalStateException("Unexpected root element: was expecting 'datasources' or 'connection-factories' but got '" + localName + "'");
        }
        AbstractConnectionFactoryDefinitionMetaData cfmd = ConnectionFactoryMetaDataFactory.getConnectionFactoryMetaData(localName);
        return cfmd;
    }

    public Object newChild(DataSourceDefinitionMetaData dsdmd, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        DataSourceMetaData dsmd = new DataSourceMetaData();
        TransactionSupport txnSupport = TransactionSupportFactory.getTransactionSupport(localName);
        AvailabilitySupport haSupport = AvailabilitySupportFactory.getAvailabilitySupport(localName);
        dsmd.setTxnSupport(txnSupport);
        dsmd.setAvailability(haSupport);
        dsdmd.addDataSourceDefintion(dsmd);
        return dsmd;
    }

    public void setValue(PreparedStatementMetaData psmd, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("prepared-statement-cache-size")) {
            psmd.setPreparedStatementCacheSize(new Integer(value));
        } else if (localName.equals("share-prepared-statements")) {
            psmd.setShareStatements(Boolean.valueOf(value));
        } else if (localName.equals("track-statements")) {
            psmd.setTrackStatements(Boolean.valueOf(value));
        }
    }

    public void setValue(ConnectionPoolMetaData cpmd, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("min-pool-size")) {
            cpmd.setMinPoolSize(Integer.valueOf(value));
        } else if (localName.equals("max-pool-size")) {
            cpmd.setMaxPoolSize(Integer.valueOf(value));
        } else if (localName.equals("blocking-timeout-millis")) {
            cpmd.setBlockingTimeoutMilliseconds(Long.valueOf(value));
        } else {
            throw new IllegalArgumentException("Unknown connection pool setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
        }
    }

    public void setValue(SqlSupportMetaData sqlmd, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("new-connection-sql")) {
            sqlmd.setNewConnectionSql(value);
        } else if (localName.equals("check-valid-connection-sql")) {
            sqlmd.setCheckValidConnectionSql(value);
        } else if (localName.equals("valid-connection-checker-class-name")) {
            sqlmd.setValidConnectionCheckerClassName(value);
        } else if (localName.equals("exception-sorter-class-name")) {
            sqlmd.setExceptionSorterClassName(value);
        }
    }

    public Object newChild(DataSourceMetaData dsmd, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if (preparedStatementElementNames.contains(localName)) {
            PreparedStatementMetaData psmd = null;
            psmd = dsmd.getPreparedStatementMetaData();
            if (psmd == null) {
                psmd = new PreparedStatementMetaData();
                dsmd.setPreparedStatementMetaData(psmd);
            }
            return psmd;
        }
        if (connectionPoolElementNames.contains(localName)) {
            ConnectionPoolMetaData pmd = dsmd.getPoolMetaData();
            if (pmd == null) {
                pmd = new ConnectionPoolMetaData();
                dsmd.setPoolMetaData(pmd);
            }
            return pmd;
        }
        if (sqlSupportElementNames.contains(localName)) {
            SqlSupportMetaData sqlmd = dsmd.getSqlSupportMetaData();
            if (sqlmd == null) {
                sqlmd = new SqlSupportMetaData();
                dsmd.setSqlSupportMetaData(sqlmd);
            }
            return sqlmd;
        }
        if (localName.equals("connection-property")) {
            Object cpmdc = null;
        }
        return null;
    }

    public void setValue(DataSourceMetaData dsmd, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("jndi-name") || localName.equals("connection-url") || localName.equals("driver-class") || localName.equals("user-name") || localName.equals("password")) {
            if (localName.equals("jndi-name")) {
                dsmd.setJndiName(value);
            } else if (localName.equals("connection-url")) {
                dsmd.setConnectionUrl(value);
            } else if (localName.equals("driver-class")) {
                dsmd.setDriverClass(value);
            } else if (localName.equals("user-name")) {
                dsmd.setUserName(value);
            } else if (localName.equals("password")) {
                dsmd.setPassWord(value);
            }
        }
    }

    public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name) {
        return root;
    }

    static {
        connectionFactoryElementNames.add("");
        preparedStatementElementNames.add("prepared-statement-cache-size");
        preparedStatementElementNames.add("share-prepared-statements");
        preparedStatementElementNames.add("track-statements");
        connectionPoolElementNames.add("min-pool-size");
        connectionPoolElementNames.add("max-pool-size");
        connectionPoolElementNames.add("blocking-timeout-millis");
        connectionPoolElementNames.add("idle-timeout-minutes");
        sqlSupportElementNames.add("new-connection-sql");
        sqlSupportElementNames.add("check-valid-connection-sql");
        sqlSupportElementNames.add("valid-connection-checker-class-name");
        sqlSupportElementNames.add("exception-sorter-class-name");
    }
}

