/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.coyote.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.tomcat.util.net.SSLSupport;

public class RemotingSSLSupport
implements SSLSupport {
    private SSLSocket sslSocket;

    public RemotingSSLSupport(SSLSocket socket) {
        this.sslSocket = socket;
    }

    public String getCipherSuite() throws IOException {
        SSLSession session = this.sslSocket.getSession();
        if (session == null) {
            return null;
        }
        return session.getCipherSuite();
    }

    public Object[] getPeerCertificateChain() throws IOException {
        return this.getPeerCertificateChain(false);
    }

    public Object[] getPeerCertificateChain(boolean force) throws IOException {
        SSLSession session = this.sslSocket.getSession();
        if (session == null) {
            return null;
        }
        javax.security.cert.X509Certificate[] jsseCerts = null;
        try {
            jsseCerts = session.getPeerCertificateChain();
        }
        catch (Exception bex) {
            // empty catch block
        }
        if (jsseCerts == null) {
            jsseCerts = new javax.security.cert.X509Certificate[]{};
        }
        if (jsseCerts.length <= 0 && force) {
            session.invalidate();
            this.handShake();
            session = this.sslSocket.getSession();
        }
        return this.getX509Certificates(session);
    }

    protected void handShake() throws IOException {
        this.sslSocket.setNeedClientAuth(true);
        this.sslSocket.startHandshake();
    }

    protected X509Certificate[] getX509Certificates(SSLSession session) throws IOException {
        javax.security.cert.X509Certificate[] jsseCerts = null;
        try {
            jsseCerts = session.getPeerCertificateChain();
        }
        catch (Throwable ex) {
            // empty catch block
        }
        if (jsseCerts == null) {
            jsseCerts = new javax.security.cert.X509Certificate[]{};
        }
        X509Certificate[] x509Certs = new X509Certificate[jsseCerts.length];
        for (int i = 0; i < x509Certs.length; ++i) {
            try {
                byte[] buffer = jsseCerts[i].getEncoded();
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                x509Certs[i] = (X509Certificate)cf.generateCertificate(stream);
                continue;
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (x509Certs.length < 1) {
            return null;
        }
        return x509Certs;
    }

    public Integer getKeySize() throws IOException {
        SSLSession session = this.sslSocket.getSession();
        SSLSupport.CipherData[] c_aux = SSLSupport.ciphers;
        if (session == null) {
            return null;
        }
        Integer keySize = (Integer)session.getValue("javax.servlet.request.key_size");
        if (keySize == null) {
            int size = 0;
            String cipherSuite = session.getCipherSuite();
            for (int i = 0; i < c_aux.length; ++i) {
                if (cipherSuite.indexOf(c_aux[i].phrase) < 0) continue;
                size = c_aux[i].keySize;
                break;
            }
            keySize = new Integer(size);
            session.putValue("javax.servlet.request.key_size", keySize);
        }
        return keySize;
    }

    public String getSessionId() throws IOException {
        SSLSession session = this.sslSocket.getSession();
        if (session == null) {
            return null;
        }
        byte[] ssl_session = session.getId();
        if (ssl_session == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer("");
        for (int x = 0; x < ssl_session.length; ++x) {
            String digit = Integer.toHexString(ssl_session[x]);
            if (digit.length() < 2) {
                buf.append('0');
            }
            if (digit.length() > 2) {
                digit = digit.substring(digit.length() - 2);
            }
            buf.append(digit);
        }
        return buf.toString();
    }
}

