/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.chat.client;

import java.net.MalformedURLException;
import java.util.ArrayList;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.invocation.RemoteInvocation;
import org.jboss.remoting.samples.chat.client.ChatInfo;
import org.jboss.remoting.samples.chat.client.ChatMember;
import org.jboss.remoting.samples.chat.client.ChatMessage;
import org.jboss.remoting.samples.chat.client.ChatReceiverHandler;
import org.jboss.remoting.samples.chat.client.RemoteStrategy;
import org.jboss.remoting.samples.chat.client.TalkFrame;
import org.jboss.remoting.samples.chat.exceptions.NameInUseException;
import org.jboss.remoting.samples.chat.exceptions.RemoteConnectionException;
import org.jboss.remoting.samples.chat.exceptions.ShuttingDownException;
import org.jboss.remoting.samples.chat.server.ChatServer;
import org.jboss.remoting.samples.chat.utility.Parameters;
import org.jboss.remoting.samples.chat.utility.ReadWriteArrayList;
import org.jboss.remoting.transport.Connector;

public class RemoteStrategyRemoting
implements RemoteStrategy {
    protected static final Logger log = Logger.getLogger(class$org$jboss$remoting$samples$chat$client$RemoteStrategyRemoting == null ? (class$org$jboss$remoting$samples$chat$client$RemoteStrategyRemoting = RemoteStrategyRemoting.class$("org.jboss.remoting.samples.chat.client.RemoteStrategyRemoting")) : class$org$jboss$remoting$samples$chat$client$RemoteStrategyRemoting);
    private static String chatClientLocatorDefault = "socket://localhost:0";
    private static String chatManagerLocatorDefault = "socket://localhost:1969";
    private Client managerClient;
    private Connector receiverConnector;
    private boolean locallyShuttingDown = false;
    private boolean remotelyShuttingDown = false;
    static /* synthetic */ Class class$org$jboss$remoting$samples$chat$client$RemoteStrategyRemoting;

    public RemoteStrategyRemoting() throws Exception {
        String chatManagerUriString = Parameters.getParameter("chatManagerUri");
        if (chatManagerUriString == null) {
            chatManagerUriString = chatManagerLocatorDefault;
        }
        InvokerLocator chatManagerLocator = new InvokerLocator(chatManagerUriString);
        this.managerClient = new Client(chatManagerLocator);
        this.managerClient.connect();
    }

    public ArrayList list() throws RemoteConnectionException, ShuttingDownException {
        RemoteInvocation invocation = new RemoteInvocation("list", null);
        try {
            return (ArrayList)this.managerClient.invoke(invocation);
        }
        catch (Throwable t) {
            log.error(t);
            t.printStackTrace();
            throw new RemoteConnectionException();
        }
    }

    public ChatServer createChat(String description, ChatMember owner, TalkFrame talkFrame, ReadWriteArrayList outgoingLines) throws NameInUseException, RemoteConnectionException, ShuttingDownException {
        Client serverClient = null;
        try {
            Object[] args = new Object[]{description, owner};
            RemoteInvocation invocation = new RemoteInvocation("createChat", args);
            InvokerLocator serverLocator = (InvokerLocator)this.managerClient.invoke(invocation);
            serverClient = new Client(serverLocator);
            serverClient.connect();
        }
        catch (Throwable e) {
            log.error(e);
            e.printStackTrace();
            throw new RemoteConnectionException();
        }
        try {
            this.receiverConnector = new Connector();
            String receiverLocatorString = Parameters.getParameter("clientUriString", chatClientLocatorDefault);
            InvokerLocator receiverLocator = new InvokerLocator(receiverLocatorString);
            this.receiverConnector.setInvokerLocator(receiverLocator.getLocatorURI());
            log.info(receiverLocator.getLocatorURI());
            this.receiverConnector.start();
            receiverLocator = this.receiverConnector.getLocator();
            log.info(this.receiverConnector.getInvokerLocator());
            ChatReceiverHandler receiverHandler = new ChatReceiverHandler(talkFrame);
            serverClient.addListener(receiverHandler, receiverLocator, owner);
        }
        catch (MalformedURLException e) {
            log.error(e);
            e.printStackTrace();
            throw new RemoteConnectionException();
        }
        catch (Throwable e) {
            log.error(e);
            e.printStackTrace();
            throw new RemoteConnectionException();
        }
        ChatServerStub chatServer = new ChatServerStub(serverClient);
        SendThread sendThread = new SendThread(chatServer, outgoingLines);
        sendThread.start();
        return chatServer;
    }

    public ChatServer join(String key, ChatMember newMember, TalkFrame talkFrame, ReadWriteArrayList outgoingLines) throws NameInUseException, RemoteConnectionException, ShuttingDownException {
        Client serverClient = null;
        try {
            Object[] args = new Object[]{key, newMember};
            RemoteInvocation invocation = new RemoteInvocation("join", args);
            this.managerClient.invoke(invocation);
            InvokerLocator serverLocator = new InvokerLocator(key);
            serverClient = new Client(serverLocator);
            serverClient.connect();
        }
        catch (Throwable e) {
            log.error(e);
            e.printStackTrace();
            throw new RemoteConnectionException();
        }
        try {
            this.receiverConnector = new Connector();
            String receiverLocatorString = Parameters.getParameter("clientUriString", chatClientLocatorDefault);
            InvokerLocator receiverLocator = new InvokerLocator(receiverLocatorString);
            this.receiverConnector.setInvokerLocator(receiverLocator.getLocatorURI());
            log.info(receiverLocator.getLocatorURI());
            this.receiverConnector.start();
            receiverLocator = this.receiverConnector.getLocator();
            ChatReceiverHandler receiverHandler = new ChatReceiverHandler(talkFrame);
            serverClient.addListener(receiverHandler, receiverLocator, newMember);
        }
        catch (MalformedURLException e) {
            log.error(e);
            e.printStackTrace();
            throw new RemoteConnectionException();
        }
        catch (Throwable e) {
            log.error(e);
            e.printStackTrace();
            throw new RemoteConnectionException();
        }
        ChatServerStub chatServer = new ChatServerStub(serverClient);
        SendThread sendThread = new SendThread(chatServer, outgoingLines);
        sendThread.start();
        return chatServer;
    }

    public void setShuttingDown() {
        this.locallyShuttingDown = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ChatServerStub
    implements ChatServer {
        private Client serverClient;

        public ChatServerStub(Client serverClient) {
            this.serverClient = serverClient;
        }

        public ArrayList getBackChat() throws RemoteConnectionException, ShuttingDownException {
            RemoteInvocation invocation = new RemoteInvocation("getBackChat", null);
            try {
                return (ArrayList)this.serverClient.invoke(invocation);
            }
            catch (Throwable e) {
                log.error(e);
                throw new RemoteConnectionException();
            }
        }

        public ChatInfo getChatInfo() throws RemoteConnectionException, ShuttingDownException {
            RemoteInvocation invocation = new RemoteInvocation("getChatInfo", null);
            try {
                return (ChatInfo)this.serverClient.invoke(invocation);
            }
            catch (Throwable e) {
                log.error(e);
                throw new RemoteConnectionException();
            }
        }

        public void leave(ChatMember member) throws RemoteConnectionException, ShuttingDownException {
            RemoteInvocation invocation = new RemoteInvocation("leave", new Object[]{member});
            try {
                this.serverClient.invoke(invocation);
            }
            catch (Throwable e) {
                log.error(e);
                throw new RemoteConnectionException();
            }
        }

        public void send(ChatMessage mesg) throws RemoteConnectionException, ShuttingDownException {
            RemoteInvocation invocation = new RemoteInvocation("send", new Object[]{mesg});
            try {
                this.serverClient.invoke(invocation);
            }
            catch (Throwable e) {
                log.error(e);
                throw new RemoteConnectionException();
            }
        }
    }

    class SendThread
    extends Thread {
        private ChatServer chatServer;
        private ReadWriteArrayList outgoingLines;

        SendThread(ChatServer chatServer, ReadWriteArrayList outgoingLines) {
            this.chatServer = chatServer;
            this.outgoingLines = outgoingLines;
        }

        public void run() {
            while (!RemoteStrategyRemoting.this.locallyShuttingDown && !RemoteStrategyRemoting.this.remotelyShuttingDown) {
                try {
                    this.chatServer.send((ChatMessage)this.outgoingLines.firstElement());
                    this.outgoingLines.remove(0);
                }
                catch (RemoteConnectionException re) {
                    System.out.println("RemoteStrategyImpl.createChat(): unable to send next line:");
                }
                catch (ShuttingDownException sde) {
                    System.out.println("RemoteStrategyImpl.createChat(): ChatServer is shutting down");
                    RemoteStrategyRemoting.this.remotelyShuttingDown = true;
                }
            }
        }
    }
}

