/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.jboss.reflect.plugins.ValueConvertor;
import org.jboss.reflect.plugins.javassist.JavassistAnnotatedInfo;
import org.jboss.reflect.plugins.javassist.JavassistConstructorInfo;
import org.jboss.reflect.plugins.javassist.JavassistFieldInfo;
import org.jboss.reflect.plugins.javassist.JavassistMethodInfo;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfoFactoryImpl;
import org.jboss.reflect.plugins.javassist.SignatureKey;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.InterfaceInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.collection.CollectionsFactory;

public class JavassistTypeInfo
extends JavassistAnnotatedInfo
implements ClassInfo,
InterfaceInfo {
    private JavassistTypeInfoFactoryImpl factory;
    private CtClass ctClass;
    private Class clazz;
    private Map constructors = CollectionsFactory.createLazyMap();
    private ConstructorInfo[] constructorArray = null;
    private Map fields = CollectionsFactory.createLazyMap();
    private FieldInfo[] fieldArray = null;
    private Map methods = CollectionsFactory.createLazyMap();
    private MethodInfo[] methodArray = null;

    JavassistTypeInfo(JavassistTypeInfoFactoryImpl factory, CtClass ctClass, Class clazz) {
        this.factory = factory;
        this.ctClass = ctClass;
        this.clazz = clazz;
    }

    public String getName() {
        return this.clazz.getName();
    }

    public boolean isInterface() {
        return this.ctClass.isInterface();
    }

    public int getModifiers() {
        return this.ctClass.getModifiers();
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public Class getType() {
        return this.clazz;
    }

    public ClassInfo getSuperclass() {
        try {
            CtClass superclass = this.ctClass.getSuperclass();
            if (superclass == null) {
                return null;
            }
            return (ClassInfo)this.factory.getTypeInfo(superclass);
        }
        catch (NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseClassNotFound(this.clazz.getSuperclass().getName(), e);
        }
    }

    public InterfaceInfo[] getInterfaces() {
        try {
            CtClass[] interfaces = this.ctClass.getInterfaces();
            if (interfaces == null || interfaces.length == 0) {
                return null;
            }
            InterfaceInfo[] result = new InterfaceInfo[interfaces.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (InterfaceInfo)this.factory.getTypeInfo(interfaces[i]);
            }
            return result;
        }
        catch (NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for interfaces of " + this.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstructorInfo[] getDeclaredConstructors() {
        if (this.constructorArray == null) {
            CtConstructor[] declaredConstructors = this.ctClass.getDeclaredConstructors();
            if (declaredConstructors == null || declaredConstructors.length == 0) {
                this.constructorArray = new ConstructorInfo[0];
            } else {
                Map map = this.constructors;
                synchronized (map) {
                    for (int i = 0; i < declaredConstructors.length; ++i) {
                        this.generateConstructorInfo(declaredConstructors[i]);
                    }
                    Collection constructorCollection = this.constructors.values();
                    this.constructorArray = constructorCollection.toArray(new ConstructorInfo[constructorCollection.size()]);
                }
            }
        }
        return this.constructorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldInfo getDeclaredField(String name) {
        Map map = this.fields;
        synchronized (map) {
            FieldInfo field = (FieldInfo)this.fields.get(name);
            if (field != null) {
                return field;
            }
        }
        if (this.fieldArray != null) {
            return null;
        }
        try {
            CtField field = this.ctClass.getDeclaredField(name);
            if (field == null) {
                return null;
            }
            return this.generateFieldInfo(field);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldInfo[] getDeclaredFields() {
        if (this.fieldArray == null) {
            CtField[] declaredFields = this.ctClass.getDeclaredFields();
            if (declaredFields == null || declaredFields.length == 0) {
                this.fieldArray = new FieldInfo[0];
            } else {
                Map map = this.fields;
                synchronized (map) {
                    for (int i = 0; i < declaredFields.length; ++i) {
                        this.generateFieldInfo(declaredFields[i]);
                    }
                    Collection fieldCollection = this.fields.values();
                    this.fieldArray = fieldCollection.toArray(new FieldInfo[fieldCollection.size()]);
                }
            }
        }
        return this.fieldArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodInfo getDeclaredMethod(String name, TypeInfo[] parameters) {
        SignatureKey key = new SignatureKey(name, parameters);
        Map map = this.methods;
        synchronized (map) {
            MethodInfo method = (MethodInfo)this.methods.get(key);
            if (method != null) {
                return method;
            }
        }
        if (this.methodArray != null) {
            return null;
        }
        return this.generateMethodInfo(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodInfo[] getDeclaredMethods() {
        if (this.methodArray == null) {
            CtMethod[] declaredMethods = this.ctClass.getDeclaredMethods();
            if (declaredMethods == null || declaredMethods.length == 0) {
                this.methodArray = new MethodInfo[0];
            } else {
                Map map = this.methods;
                synchronized (map) {
                    for (int i = 0; i < declaredMethods.length; ++i) {
                        this.generateMethodInfo(declaredMethods[i]);
                    }
                    Collection methodCollection = this.methods.values();
                    this.methodArray = methodCollection.toArray(new MethodInfo[methodCollection.size()]);
                }
            }
        }
        return this.methodArray;
    }

    public boolean isArray() {
        return this.getType().isArray();
    }

    public static Class getArrayClass(Class clazz, int depth) {
        return Array.newInstance(clazz, depth).getClass();
    }

    public TypeInfo getArrayType(int depth) {
        Class arrayClass = JavassistTypeInfo.getArrayClass(this.getType(), depth);
        return this.factory.getTypeInfo(arrayClass);
    }

    public Object[] newArrayInstance(int size) throws Throwable {
        Class clazz = this.getType();
        if (!clazz.isArray()) {
            throw new ClassCastException(clazz + " is not an array.");
        }
        return (Object[])Array.newInstance(clazz.getComponentType(), size);
    }

    public Object convertValue(Object value) throws Throwable {
        return ValueConvertor.convertValue(this.getType(), value);
    }

    protected int getHashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof TypeInfo)) {
            return false;
        }
        TypeInfo other = (TypeInfo)obj;
        return this.getName().equals(other.getName());
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.getName());
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.getName());
        super.toString(buffer);
    }

    protected JavassistTypeInfoFactoryImpl getFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConstructorInfo generateConstructorInfo(CtConstructor constructor) {
        try {
            CtClass[] parameterTypes = constructor.getParameterTypes();
            String[] params = new String[parameterTypes.length];
            for (int i = 0; i < params.length; ++i) {
                params[i] = parameterTypes[i].getName();
            }
            SignatureKey key = new SignatureKey(null, params);
            JavassistConstructorInfo info = new JavassistConstructorInfo(this, constructor);
            Map map = this.constructors;
            synchronized (map) {
                this.constructors.put(key, info);
            }
            return info;
        }
        catch (NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for constructor of " + this.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FieldInfo generateFieldInfo(CtField field) {
        JavassistFieldInfo info = new JavassistFieldInfo(this, field);
        Map map = this.fields;
        synchronized (map) {
            this.fields.put(field.getName(), info);
        }
        return info;
    }

    protected MethodInfo generateMethodInfo(SignatureKey key) {
        CtClass[] params = this.getParameterTypes(key);
        try {
            CtMethod ctMethod = this.ctClass.getDeclaredMethod(key.name, params);
            return this.generateMethodInfo(key, ctMethod);
        }
        catch (NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseMethodNotFound("for method " + key.name, e);
        }
    }

    protected MethodInfo generateMethodInfo(CtMethod method) {
        try {
            CtClass[] parameterTypes = method.getParameterTypes();
            String[] params = new String[parameterTypes.length];
            for (int i = 0; i < params.length; ++i) {
                params[i] = parameterTypes[i].getName();
            }
            SignatureKey key = new SignatureKey(method.getName(), params);
            return this.generateMethodInfo(key, method);
        }
        catch (NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for method " + method.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MethodInfo generateMethodInfo(SignatureKey key, CtMethod method) {
        JavassistMethodInfo info = new JavassistMethodInfo(this, key, method);
        Map map = this.methods;
        synchronized (map) {
            this.methods.put(key, info);
        }
        return info;
    }

    protected CtClass[] getParameterTypes(SignatureKey key) {
        if (key.params == null) {
            return null;
        }
        CtClass[] result = new CtClass[key.params.length];
        for (int i = 0; i < key.params.length; ++i) {
            result[i] = this.factory.getCtClass(key.params[i]);
        }
        return result;
    }
}

