/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.util.xml.JBossEntityResolver;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlFileLoader {
    private static boolean defaultValidateDTDs = false;
    private static Logger log = Logger.getLogger(XmlFileLoader.class);
    private URLClassLoader classLoader;
    private ApplicationMetaData metaData;
    private boolean validateDTDs;

    public static boolean getDefaultValidateDTDs() {
        return defaultValidateDTDs;
    }

    public static void setDefaultValidateDTDs(boolean validate) {
        defaultValidateDTDs = validate;
    }

    public XmlFileLoader() {
        this(defaultValidateDTDs);
    }

    public XmlFileLoader(boolean validateDTDs) {
        this.validateDTDs = validateDTDs;
    }

    public ApplicationMetaData getMetaData() {
        return this.metaData;
    }

    public void setClassLoader(URLClassLoader cl) {
        this.classLoader = cl;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean getValidateDTDs() {
        return this.validateDTDs;
    }

    public void setValidateDTDs(boolean validate) {
        this.validateDTDs = validate;
    }

    public ApplicationMetaData load(URL alternativeDD) throws Exception {
        URL ejbjarUrl = null;
        if (alternativeDD != null) {
            log.debug("Using alternativeDD: " + alternativeDD);
            ejbjarUrl = alternativeDD;
        } else {
            ejbjarUrl = this.getClassLoader().getResource("META-INF/ejb-jar.xml");
        }
        if (ejbjarUrl == null) {
            throw new DeploymentException("no ejb-jar.xml found");
        }
        this.metaData = new ApplicationMetaData();
        this.metaData.setResourceClassLoader(this.classLoader);
        Document ejbjarDocument = this.getDocumentFromURL(ejbjarUrl);
        this.metaData.setUrl(ejbjarUrl);
        this.metaData.importEjbJarXml(ejbjarDocument.getDocumentElement());
        URL defaultJbossUrl = Thread.currentThread().getContextClassLoader().getResource("standardjboss.xml");
        if (defaultJbossUrl == null) {
            throw new DeploymentException("no standardjboss.xml found");
        }
        Document defaultJbossDocument = null;
        try {
            defaultJbossDocument = this.getDocumentFromURL(defaultJbossUrl);
            this.metaData.setUrl(defaultJbossUrl);
            this.metaData.importJbossXml(defaultJbossDocument.getDocumentElement());
        }
        catch (Exception ex) {
            log.error("failed to load standardjboss.xml.  There could be a syntax error.", ex);
            throw ex;
        }
        try {
            URL jbossUrl = this.getClassLoader().getResource("META-INF/jboss.xml");
            if (jbossUrl != null) {
                Document jbossDocument = this.getDocumentFromURL(jbossUrl);
                this.metaData.setUrl(jbossUrl);
                this.metaData.importJbossXml(jbossDocument.getDocumentElement());
            }
        }
        catch (Exception ex) {
            log.error("failed to load jboss.xml.  There could be a syntax error.", ex);
            throw ex;
        }
        return this.metaData;
    }

    public static Document getDocument(URL url) throws DeploymentException {
        return XmlFileLoader.getDocument(url, defaultValidateDTDs);
    }

    public static Document getDocument(URL url, boolean validateDTDs) throws DeploymentException {
        XmlFileLoader loader = new XmlFileLoader(validateDTDs);
        return loader.getDocumentFromURL(url);
    }

    public Document getDocumentFromURL(URL url) throws DeploymentException {
        InputStream is = null;
        try {
            is = url.openStream();
            return this.getDocument(is, url.toExternalForm());
        }
        catch (IOException e) {
            throw new DeploymentException("Failed to obtain xml doc from URL", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDocument(InputStream is, String inPath) throws DeploymentException {
        InputSource is2 = new InputSource(is);
        is2.setSystemId(inPath);
        Document doc = null;
        try {
            doc = this.getDocument(is2, inPath);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {}
        }
        return doc;
    }

    public Document getDocument(InputSource is, String inPath) throws DeploymentException {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setValidating(this.validateDTDs);
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            JBossEntityResolver lr = new JBossEntityResolver();
            LocalErrorHandler eh = new LocalErrorHandler(inPath, lr);
            docBuilder.setEntityResolver(lr);
            docBuilder.setErrorHandler(eh);
            Document doc = docBuilder.parse(is);
            if (this.validateDTDs && eh.hadError()) {
                throw new DeploymentException("Invalid XML: file=" + inPath, eh.getException());
            }
            return doc;
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (SAXParseException e) {
            String msg = "Invalid XML: file=" + inPath + "@" + e.getColumnNumber() + ":" + e.getLineNumber();
            throw new DeploymentException(msg, e);
        }
        catch (SAXException e) {
            throw new DeploymentException("Invalid XML: file=" + inPath, e);
        }
        catch (Exception e) {
            throw new DeploymentException("Invalid XML: file=" + inPath, e);
        }
    }

    private static class LocalErrorHandler
    implements ErrorHandler {
        private String theFileName;
        private JBossEntityResolver localResolver;
        private boolean error;
        private SAXParseException exception;

        public LocalErrorHandler(String inFileName, JBossEntityResolver localResolver) {
            this.theFileName = inFileName;
            this.localResolver = localResolver;
            this.error = false;
        }

        public void error(SAXParseException exception) {
            this.exception = exception;
            if (this.localResolver.isEntityResolved()) {
                this.error = true;
                log.error("XmlFileLoader: File " + this.theFileName + " process error. Line: " + String.valueOf(exception.getLineNumber()) + ". Error message: " + exception.getMessage());
            }
        }

        public void fatalError(SAXParseException exception) {
            this.exception = exception;
            if (this.localResolver.isEntityResolved()) {
                this.error = true;
                log.error("XmlFileLoader: File " + this.theFileName + " process fatal error. Line: " + String.valueOf(exception.getLineNumber()) + ". Error message: " + exception.getMessage());
            }
        }

        public void warning(SAXParseException exception) {
            this.exception = exception;
            if (this.localResolver.isEntityResolved()) {
                this.error = true;
                log.error("XmlFileLoader: File " + this.theFileName + " process warning. Line: " + String.valueOf(exception.getLineNumber()) + ". Error message: " + exception.getMessage());
            }
        }

        public SAXParseException getException() {
            return this.exception;
        }

        public boolean hadError() {
            return this.error;
        }
    }
}

