/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.metadata.EjbLocalRefMetaData;
import org.jboss.metadata.EjbRefMetaData;
import org.jboss.metadata.EnvEntryMetaData;
import org.jboss.metadata.MessageDestinationMetaData;
import org.jboss.metadata.MessageDestinationRefMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.ResourceEnvRefMetaData;
import org.jboss.metadata.ResourceRefMetaData;
import org.jboss.metadata.SecurityRoleMetaData;
import org.jboss.metadata.SecurityRoleRefMetaData;
import org.jboss.metadata.WebSecurityMetaData;
import org.jboss.metadata.serviceref.ServiceRefMetaData;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.security.RunAsIdentity;
import org.w3c.dom.Element;

public class WebMetaData
extends MetaData {
    private static Logger log = Logger.getLogger(WebMetaData.class);
    private HashMap servletClassNames = new HashMap();
    private HashMap servletMappings = new HashMap();
    private HashMap resourceReferences = new HashMap();
    private HashMap resourceEnvReferences = new HashMap();
    private HashMap messageDestinationReferences = new HashMap();
    private HashMap messageDestinations = new HashMap();
    private ArrayList environmentEntries = new ArrayList();
    private ArrayList securityContraints = new ArrayList();
    private HashMap securityRoles = new HashMap();
    private HashMap ejbReferences = new HashMap();
    private HashMap ejbLocalReferences = new HashMap();
    private HashMap serviceReferences = new HashMap();
    private HashMap securityRoleReferences = new HashMap();
    private HashMap runAsNames = new HashMap();
    private HashMap runAsIdentity = new HashMap();
    private boolean distributable = false;
    private boolean java2ClassLoadingCompliance = false;
    private LoaderRepositoryFactory.LoaderRepositoryConfig loaderConfig;
    private String contextRoot;
    private String jaccContextID;
    private ArrayList virtualHosts = new ArrayList();
    private String securityDomain;
    private boolean flushOnSessionInvalidation;
    private HashMap wsdlPublishLocationMap = new HashMap();
    private boolean webServiceDeployment;
    private String configName;
    private String configFile;
    private ClassLoader encLoader;
    private ClassLoader cxtLoader;
    private ArrayList depends = new ArrayList();
    public static final int SESSION_INVALIDATE_ACCESS = 0;
    public static final int SESSION_INVALIDATE_SET_AND_GET = 1;
    public static final int SESSION_INVALIDATE_SET_AND_NON_PRIMITIVE_GET = 2;
    public static final int SESSION_INVALIDATE_SET = 3;
    private int invalidateSessionPolicy = 2;
    public static final int REPLICATION_TYPE_SYNC = 0;
    public static final int REPLICATION_TYPE_ASYNC = 1;
    private int replicationType = 0;
    public static final int REPLICATION_GRANULARITY_SESSION = 0;
    public static final int REPLICATION_GRANULARITY_ATTRIBUTE = 1;
    public static final int REPLICATION_GRANULARITY_FIELD = 2;
    private int replicationGranularity = 0;
    private boolean replicationFieldBatchMode = true;
    private int sessionCookies = 0;
    public static final int SESSION_COOKIES_DEFAULT = 0;
    public static final int SESSION_COOKIES_ENABLED = 1;
    public static final int SESSION_COOKIES_DISABLED = 2;
    private URLClassLoader resourceCl;

    public void setResourceClassLoader(URLClassLoader resourceCl) {
        this.resourceCl = resourceCl;
    }

    public Iterator getEnvironmentEntries() {
        return this.environmentEntries.iterator();
    }

    public void setEnvironmentEntries(Collection environmentEntries) {
        this.environmentEntries.clear();
        this.environmentEntries.addAll(environmentEntries);
    }

    public Iterator getEjbReferences() {
        return this.ejbReferences.values().iterator();
    }

    public void setEjbReferences(Map ejbReferences) {
        this.ejbReferences.clear();
        this.ejbReferences.putAll(ejbReferences);
    }

    public Iterator getEjbLocalReferences() {
        return this.ejbLocalReferences.values().iterator();
    }

    public void setEjbLocalReferences(Map ejbReferences) {
        this.ejbLocalReferences.clear();
        this.ejbLocalReferences.putAll(ejbReferences);
    }

    public Iterator getResourceReferences() {
        return this.resourceReferences.values().iterator();
    }

    public void setResourceReferences(Map resourceReferences) {
        this.resourceReferences.clear();
        this.resourceReferences.putAll(resourceReferences);
    }

    public Iterator getResourceEnvReferences() {
        return this.resourceEnvReferences.values().iterator();
    }

    public void setResourceEnvReferences(Map resourceReferences) {
        this.resourceEnvReferences.clear();
        this.resourceEnvReferences.putAll(resourceReferences);
    }

    public Iterator getMessageDestinationReferences() {
        return this.messageDestinationReferences.values().iterator();
    }

    public void setMessageDestinationReferences(Map messageDestinationReferences) {
        this.messageDestinationReferences.clear();
        this.messageDestinationReferences.putAll(messageDestinationReferences);
    }

    public MessageDestinationMetaData getMessageDestination(String name) {
        return (MessageDestinationMetaData)this.messageDestinations.get(name);
    }

    public void setMessageDestination(Map messageDestinations) {
        this.messageDestinations.clear();
        this.messageDestinations.putAll(messageDestinations);
    }

    public Iterator getServiceReferences() {
        return this.serviceReferences.values().iterator();
    }

    public void setServiceReferences(Map serviceReferences) {
        this.serviceReferences.clear();
        this.serviceReferences.putAll(serviceReferences);
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public HashMap getWsdlPublishLocations() {
        return this.wsdlPublishLocationMap;
    }

    public String getWsdlPublishLocationByName(String name) {
        return (String)this.wsdlPublishLocationMap.get(name);
    }

    public void setWsdlPublishLocationMap(Map wsdlPublishLocationMap) {
        this.wsdlPublishLocationMap.clear();
        this.wsdlPublishLocationMap.putAll(wsdlPublishLocationMap);
    }

    public boolean isWebServiceDeployment() {
        return this.webServiceDeployment;
    }

    public void setWebServiceDeployment(boolean webServiceDeployment) {
        this.webServiceDeployment = webServiceDeployment;
    }

    public String getJaccContextID() {
        return this.jaccContextID;
    }

    public void setJaccContextID(String jaccContextID) {
        this.jaccContextID = jaccContextID;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public boolean isFlushOnSessionInvalidation() {
        return this.flushOnSessionInvalidation;
    }

    public void setFlushOnSessionInvalidation(boolean flag) {
        this.flushOnSessionInvalidation = flag;
    }

    public Iterator getSecurityContraints() {
        return this.securityContraints.iterator();
    }

    public void setSecurityConstraints(Collection securityContraints) {
        this.securityContraints.clear();
        this.securityContraints.addAll(securityContraints);
    }

    public Map getSecurityRoleRefs() {
        return this.securityRoleReferences;
    }

    public List getSecurityRoleRefs(String servletName) {
        List roles = (List)this.securityRoleReferences.get(servletName);
        return roles;
    }

    public void setSecurityRoleReferences(Map securityRoleReferences) {
        this.securityRoleReferences.clear();
        this.securityRoleReferences.putAll(securityRoleReferences);
    }

    public Set getSecurityRoleNames() {
        return new HashSet(this.securityRoles.keySet());
    }

    public Map getSecurityRoles() {
        return new HashMap(this.securityRoles);
    }

    public void setSecurityRoles(Map securityRoles) {
        this.securityRoles.clear();
        this.securityRoles.putAll(securityRoles);
    }

    public Set getSecurityRoleNamesByPrincipal(String userName) {
        HashSet<String> roleNames = new HashSet<String>();
        for (SecurityRoleMetaData srMetaData : this.securityRoles.values()) {
            if (!srMetaData.getPrincipals().contains(userName)) continue;
            roleNames.add(srMetaData.getRoleName());
        }
        return roleNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunAsIdentity getRunAsIdentity(String servletName) {
        RunAsIdentity runAs = (RunAsIdentity)this.runAsIdentity.get(servletName);
        if (runAs == null) {
            HashMap hashMap = this.runAsIdentity;
            synchronized (hashMap) {
                String roleName = (String)this.runAsNames.get(servletName);
                if (roleName != null) {
                    runAs = new RunAsIdentity(roleName, null);
                    this.runAsIdentity.put(servletName, runAs);
                }
            }
        }
        return runAs;
    }

    public Map getRunAsIdentity() {
        return this.runAsIdentity;
    }

    public void setRunAsIdentity(Map runAsIdentity) {
        this.runAsIdentity.clear();
        this.runAsIdentity.putAll(runAsIdentity);
    }

    public HashMap getServletMappings() {
        return this.servletMappings;
    }

    public void setServletMappings(Map servletMappings) {
        this.servletMappings.clear();
        this.servletMappings.putAll(servletMappings);
    }

    public Set getServletNames() {
        return new HashSet(this.servletMappings.keySet());
    }

    public Map getServletClassMap() {
        return new HashMap(this.servletClassNames);
    }

    public void mergeSecurityRoles(Map applRoles) {
        for (Map.Entry entry : applRoles.entrySet()) {
            String roleName = (String)entry.getKey();
            SecurityRoleMetaData appRole = (SecurityRoleMetaData)entry.getValue();
            SecurityRoleMetaData srMetaData = (SecurityRoleMetaData)this.securityRoles.get(roleName);
            if (srMetaData != null) {
                Set principalNames = appRole.getPrincipals();
                srMetaData.addPrincipalNames(principalNames);
                continue;
            }
            this.securityRoles.put(roleName, entry.getValue());
        }
    }

    public Iterator getVirtualHosts() {
        return this.virtualHosts.iterator();
    }

    public void setVirtualHosts(Collection virtualHosts) {
        this.virtualHosts.clear();
        this.virtualHosts.addAll(virtualHosts);
    }

    public boolean getDistributable() {
        return this.distributable;
    }

    public void setDistributable(boolean distributable) {
        this.distributable = distributable;
    }

    public Collection getDepends() {
        return this.depends;
    }

    public void setDepends(Collection depends) {
        this.depends.clear();
        this.depends.addAll(depends);
    }

    public boolean getJava2ClassLoadingCompliance() {
        return this.java2ClassLoadingCompliance;
    }

    public void setJava2ClassLoadingCompliance(boolean flag) {
        this.java2ClassLoadingCompliance = flag;
    }

    public LoaderRepositoryFactory.LoaderRepositoryConfig getLoaderConfig() {
        return this.loaderConfig;
    }

    public void setLoaderConfig(LoaderRepositoryFactory.LoaderRepositoryConfig loaderConfig) {
        this.loaderConfig = loaderConfig;
    }

    public ClassLoader getENCLoader() {
        return this.encLoader;
    }

    public void setENCLoader(ClassLoader encLoader) {
        this.encLoader = encLoader;
    }

    public ClassLoader getContextLoader() {
        return this.cxtLoader;
    }

    public void setContextLoader(ClassLoader cxtLoader) {
        this.cxtLoader = cxtLoader;
    }

    public int getSessionCookies() {
        return this.sessionCookies;
    }

    public void setSessionCookies(int sessionCookies) {
        this.sessionCookies = sessionCookies;
    }

    public int getInvalidateSessionPolicy() {
        return this.invalidateSessionPolicy;
    }

    public void setInvalidateSessionPolicy(int invalidateSessionPolicy) {
        this.invalidateSessionPolicy = invalidateSessionPolicy;
    }

    public int getReplicationType() {
        return this.replicationType;
    }

    public int getReplicationGranularity() {
        return this.replicationGranularity;
    }

    public void setReplicationGranularity(int replicationGranularity) {
        this.replicationGranularity = replicationGranularity;
    }

    public boolean getReplicationFieldBatchMode() {
        return this.replicationFieldBatchMode;
    }

    public void importXml(Element element) throws DeploymentException {
        String rootTag = element.getOwnerDocument().getDocumentElement().getTagName();
        if (rootTag.equals("web-app")) {
            this.importWebXml(element);
        } else if (rootTag.equals("jboss-web")) {
            this.importJBossWebXml(element);
        }
    }

    protected void importWebXml(Element webApp) throws DeploymentException {
        MetaData ejbRefMetaData;
        Element ejbRef;
        Object refMetaData;
        Element resourceRef;
        String servletName;
        Iterator iterator = WebMetaData.getChildrenByTagName(webApp, "servlet");
        while (iterator.hasNext()) {
            Element servlet = (Element)iterator.next();
            servletName = WebMetaData.getElementContent(WebMetaData.getUniqueChild(servlet, "servlet-name"));
            String servletClass = WebMetaData.getElementContent(WebMetaData.getOptionalChild(servlet, "servlet-class"));
            if (servletClass != null) {
                this.servletClassNames.put(servletName, servletClass);
            }
            Iterator roleRefs = WebMetaData.getChildrenByTagName(servlet, "security-role-ref");
            ArrayList<SecurityRoleRefMetaData> roleNames = new ArrayList<SecurityRoleRefMetaData>();
            while (roleRefs.hasNext()) {
                Element roleRefElem = (Element)roleRefs.next();
                SecurityRoleRefMetaData roleRef = new SecurityRoleRefMetaData();
                roleRef.importEjbJarXml(roleRefElem);
                roleNames.add(roleRef);
            }
            this.securityRoleReferences.put(servletName, roleNames);
            Element runAs = WebMetaData.getOptionalChild(servlet, "run-as");
            if (runAs == null) continue;
            String runAsName = WebMetaData.getElementContent(WebMetaData.getOptionalChild(runAs, "role-name"));
            this.runAsNames.put(servletName, runAsName);
        }
        iterator = WebMetaData.getChildrenByTagName(webApp, "servlet-mapping");
        while (iterator.hasNext()) {
            Element servletMapping = (Element)iterator.next();
            servletName = WebMetaData.getElementContent(WebMetaData.getUniqueChild(servletMapping, "servlet-name"));
            String urlPattern = WebMetaData.getElementContent(WebMetaData.getUniqueChild(servletMapping, "url-pattern"));
            this.servletMappings.put(servletName, urlPattern);
        }
        iterator = WebMetaData.getChildrenByTagName(webApp, "resource-ref");
        while (iterator.hasNext()) {
            resourceRef = (Element)iterator.next();
            ResourceRefMetaData resourceRefMetaData = new ResourceRefMetaData();
            resourceRefMetaData.importEjbJarXml(resourceRef);
            this.resourceReferences.put(resourceRefMetaData.getRefName(), resourceRefMetaData);
        }
        iterator = WebMetaData.getChildrenByTagName(webApp, "resource-env-ref");
        while (iterator.hasNext()) {
            resourceRef = (Element)iterator.next();
            refMetaData = new ResourceEnvRefMetaData();
            ((ResourceEnvRefMetaData)refMetaData).importEjbJarXml(resourceRef);
            this.resourceEnvReferences.put(((ResourceEnvRefMetaData)refMetaData).getRefName(), refMetaData);
        }
        iterator = WebMetaData.getChildrenByTagName(webApp, "message-destination-ref");
        while (iterator.hasNext()) {
            Element messageDestinationRef = (Element)iterator.next();
            MessageDestinationRefMetaData messageDestinationRefMetaData = new MessageDestinationRefMetaData();
            messageDestinationRefMetaData.importEjbJarXml(messageDestinationRef);
            this.messageDestinationReferences.put(messageDestinationRefMetaData.getRefName(), messageDestinationRefMetaData);
        }
        iterator = WebMetaData.getChildrenByTagName(webApp, "message-destination");
        while (iterator.hasNext()) {
            Element messageDestination = (Element)iterator.next();
            try {
                MessageDestinationMetaData messageDestinationMetaData = new MessageDestinationMetaData();
                messageDestinationMetaData.importEjbJarXml(messageDestination);
                this.messageDestinations.put(messageDestinationMetaData.getName(), messageDestinationMetaData);
            }
            catch (Throwable t) {
                throw new DeploymentException("Error in web.xml for message destination: " + t.getMessage());
            }
        }
        iterator = WebMetaData.getChildrenByTagName(webApp, "env-entry");
        while (iterator.hasNext()) {
            Element envEntry = (Element)iterator.next();
            EnvEntryMetaData envEntryMetaData = new EnvEntryMetaData();
            envEntryMetaData.importEjbJarXml(envEntry);
            this.environmentEntries.add(envEntryMetaData);
        }
        iterator = WebMetaData.getChildrenByTagName(webApp, "security-constraint");
        while (iterator.hasNext()) {
            Element userData;
            Element contraints = (Element)iterator.next();
            WebSecurityMetaData wsmd = new WebSecurityMetaData();
            this.securityContraints.add(wsmd);
            Iterator iter2 = WebMetaData.getChildrenByTagName(contraints, "web-resource-collection");
            while (iter2.hasNext()) {
                Element wrcElement = (Element)iter2.next();
                Element wrName = WebMetaData.getUniqueChild(wrcElement, "web-resource-name");
                String name = WebMetaData.getElementContent(wrName);
                WebSecurityMetaData.WebResourceCollection wrc = wsmd.addWebResource(name);
                Iterator iter21 = WebMetaData.getChildrenByTagName(wrcElement, "url-pattern");
                while (iter21.hasNext()) {
                    Element urlPattern = (Element)iter21.next();
                    String pattern = WebMetaData.getElementContent(urlPattern);
                    wrc.addPattern(pattern);
                }
                Iterator iter22 = WebMetaData.getChildrenByTagName(wrcElement, "http-method");
                while (iter22.hasNext()) {
                    Element httpMethod = (Element)iter22.next();
                    String method = WebMetaData.getElementContent(httpMethod);
                    wrc.addHttpMethod(method);
                }
            }
            Element authContraint = WebMetaData.getOptionalChild(contraints, "auth-constraint");
            if (authContraint != null) {
                Iterator iter3 = WebMetaData.getChildrenByTagName(authContraint, "role-name");
                while (iter3.hasNext()) {
                    Element roleName = (Element)iter3.next();
                    String name = WebMetaData.getElementContent(roleName);
                    wsmd.addRole(name);
                }
                if (wsmd.getRoles().size() == 0) {
                    wsmd.setExcluded(true);
                }
            } else {
                wsmd.setUnchecked(true);
            }
            if ((userData = WebMetaData.getOptionalChild(contraints, "user-data-constraint")) == null) continue;
            Element transport = WebMetaData.getUniqueChild(userData, "transport-guarantee");
            String type = WebMetaData.getElementContent(transport);
            wsmd.setTransportGuarantee(type);
        }
        iterator = WebMetaData.getChildrenByTagName(webApp, "security-role");
        while (iterator.hasNext()) {
            Element securityRole = (Element)iterator.next();
            String roleName = WebMetaData.getElementContent(WebMetaData.getUniqueChild(securityRole, "role-name"));
            this.securityRoles.put(roleName, new SecurityRoleMetaData(roleName));
        }
        iterator = WebMetaData.getChildrenByTagName(webApp, "ejb-ref");
        while (iterator.hasNext()) {
            ejbRef = (Element)iterator.next();
            ejbRefMetaData = new EjbRefMetaData();
            ((EjbRefMetaData)ejbRefMetaData).importEjbJarXml(ejbRef);
            this.ejbReferences.put(((EjbRefMetaData)ejbRefMetaData).getName(), ejbRefMetaData);
        }
        iterator = WebMetaData.getChildrenByTagName(webApp, "ejb-local-ref");
        while (iterator.hasNext()) {
            ejbRef = (Element)iterator.next();
            ejbRefMetaData = new EjbLocalRefMetaData();
            ((EjbLocalRefMetaData)ejbRefMetaData).importEjbJarXml(ejbRef);
            this.ejbLocalReferences.put(((EjbLocalRefMetaData)ejbRefMetaData).getName(), ejbRefMetaData);
        }
        iterator = MetaData.getChildrenByTagName(webApp, "service-ref");
        while (iterator.hasNext()) {
            Element serviceRef = (Element)iterator.next();
            refMetaData = new ServiceRefMetaData(this.resourceCl);
            ((ServiceRefMetaData)refMetaData).importStandardXml(serviceRef);
            this.serviceReferences.put(((ServiceRefMetaData)refMetaData).getServiceRefName(), refMetaData);
        }
        iterator = WebMetaData.getChildrenByTagName(webApp, "distributable");
        if (iterator.hasNext()) {
            this.distributable = true;
        }
    }

    protected void importJBossWebXml(Element jbossWeb) throws DeploymentException {
        Element classLoading;
        Element sessionReplicationRootElement;
        String principalName;
        Object refMetaData;
        String resRefName;
        Element resourceRef;
        Element securityDomainElement;
        Element contextRootElement = WebMetaData.getOptionalChild(jbossWeb, "context-root");
        if (contextRootElement != null) {
            this.contextRoot = WebMetaData.getElementContent(contextRootElement);
        }
        if ((securityDomainElement = WebMetaData.getOptionalChild(jbossWeb, "security-domain")) != null) {
            this.securityDomain = WebMetaData.getElementContent(securityDomainElement);
            Boolean flag = Boolean.valueOf(securityDomainElement.getAttribute("flushOnSessionInvalidation"));
            this.flushOnSessionInvalidation = flag;
        }
        Iterator virtualHostElements = WebMetaData.getChildrenByTagName(jbossWeb, "virtual-host");
        while (virtualHostElements.hasNext()) {
            Element virtualHostElement = (Element)virtualHostElements.next();
            String virtualHostName = WebMetaData.getElementContent(virtualHostElement);
            this.virtualHosts.add(virtualHostName);
        }
        Iterator iterator = WebMetaData.getChildrenByTagName(jbossWeb, "resource-ref");
        while (iterator.hasNext()) {
            resourceRef = (Element)iterator.next();
            resRefName = WebMetaData.getElementContent(WebMetaData.getUniqueChild(resourceRef, "res-ref-name"));
            refMetaData = (ResourceRefMetaData)this.resourceReferences.get(resRefName);
            if (refMetaData == null) {
                throw new DeploymentException("resource-ref " + resRefName + " found in jboss-web.xml but not in web.xml");
            }
            ((ResourceRefMetaData)refMetaData).importJbossXml(resourceRef);
        }
        iterator = WebMetaData.getChildrenByTagName(jbossWeb, "resource-env-ref");
        while (iterator.hasNext()) {
            resourceRef = (Element)iterator.next();
            resRefName = WebMetaData.getElementContent(WebMetaData.getUniqueChild(resourceRef, "resource-env-ref-name"));
            refMetaData = (ResourceEnvRefMetaData)this.resourceEnvReferences.get(resRefName);
            if (refMetaData == null) {
                throw new DeploymentException("resource-env-ref " + resRefName + " found in jboss-web.xml but not in web.xml");
            }
            ((ResourceEnvRefMetaData)refMetaData).importJbossXml(resourceRef);
        }
        iterator = WebMetaData.getChildrenByTagName(jbossWeb, "message-destination-ref");
        while (iterator.hasNext()) {
            Element messageDestinationRef = (Element)iterator.next();
            String messageDestinationRefName = WebMetaData.getElementContent(WebMetaData.getUniqueChild(messageDestinationRef, "message-destination-ref-name"));
            MessageDestinationRefMetaData messageDestinationRefMetaData = (MessageDestinationRefMetaData)this.messageDestinationReferences.get(messageDestinationRefName);
            if (messageDestinationRefMetaData == null) {
                throw new DeploymentException("message-destination-ref " + messageDestinationRefName + " found in jboss-web.xml but not in web.xml");
            }
            messageDestinationRefMetaData.importJbossXml(messageDestinationRef);
        }
        iterator = WebMetaData.getChildrenByTagName(jbossWeb, "message-destination");
        while (iterator.hasNext()) {
            Element messageDestination = (Element)iterator.next();
            try {
                String messageDestinationName = WebMetaData.getUniqueChildContent(messageDestination, "message-destination-name");
                MessageDestinationMetaData messageDestinationMetaData = (MessageDestinationMetaData)this.messageDestinations.get(messageDestinationName);
                if (messageDestinationMetaData == null) {
                    throw new DeploymentException("message-destination " + messageDestinationName + " found in jboss-web.xml but not in web.xml");
                }
                messageDestinationMetaData.importJbossXml(messageDestination);
            }
            catch (Throwable t) {
                throw new DeploymentException("Error in web.xml for message destination: " + t.getMessage());
            }
        }
        iterator = WebMetaData.getChildrenByTagName(jbossWeb, "security-role");
        while (iterator.hasNext()) {
            Element securityRole = (Element)iterator.next();
            String roleName = WebMetaData.getElementContent(WebMetaData.getUniqueChild(securityRole, "role-name"));
            SecurityRoleMetaData securityRoleMetaData = (SecurityRoleMetaData)this.securityRoles.get(roleName);
            if (securityRoleMetaData == null) {
                throw new DeploymentException("Security role '" + roleName + "' defined in jboss-web.xml" + " is not defined in web.xml");
            }
            Iterator itPrincipalNames = WebMetaData.getChildrenByTagName(securityRole, "principal-name");
            while (itPrincipalNames.hasNext()) {
                principalName = WebMetaData.getElementContent((Element)itPrincipalNames.next());
                securityRoleMetaData.addPrincipalName(principalName);
            }
        }
        iterator = WebMetaData.getChildrenByTagName(jbossWeb, "ejb-ref");
        while (iterator.hasNext()) {
            Element ejbRef = (Element)iterator.next();
            String ejbRefName = WebMetaData.getElementContent(WebMetaData.getUniqueChild(ejbRef, "ejb-ref-name"));
            EjbRefMetaData ejbRefMetaData = (EjbRefMetaData)this.ejbReferences.get(ejbRefName);
            if (ejbRefMetaData == null) {
                throw new DeploymentException("ejb-ref " + ejbRefName + " found in jboss-web.xml but not in web.xml");
            }
            ejbRefMetaData.importJbossXml(ejbRef);
        }
        iterator = WebMetaData.getChildrenByTagName(jbossWeb, "ejb-local-ref");
        while (iterator.hasNext()) {
            Element ejbLocalRef = (Element)iterator.next();
            String ejbLocalRefName = WebMetaData.getElementContent(WebMetaData.getUniqueChild(ejbLocalRef, "ejb-ref-name"));
            EjbLocalRefMetaData ejbLocalRefMetaData = (EjbLocalRefMetaData)this.ejbLocalReferences.get(ejbLocalRefName);
            if (ejbLocalRefMetaData == null) {
                throw new DeploymentException("ejb-local-ref " + ejbLocalRefName + " found in jboss-web.xml but not in web.xml");
            }
            ejbLocalRefMetaData.importJbossXml(ejbLocalRef);
        }
        iterator = MetaData.getChildrenByTagName(jbossWeb, "service-ref");
        while (iterator.hasNext()) {
            Element serviceRef = (Element)iterator.next();
            String serviceRefName = MetaData.getUniqueChildContent(serviceRef, "service-ref-name");
            refMetaData = (ServiceRefMetaData)this.serviceReferences.get(serviceRefName);
            if (refMetaData == null) {
                throw new DeploymentException("service-ref " + serviceRefName + " found in jboss-web.xml but not in web.xml");
            }
            ((ServiceRefMetaData)refMetaData).importJBossXml(serviceRef);
        }
        iterator = WebMetaData.getChildrenByTagName(jbossWeb, "webservice-description");
        while (iterator.hasNext()) {
            Element wsd = (Element)iterator.next();
            String wsdName = WebMetaData.getElementContent(WebMetaData.getUniqueChild(wsd, "webservice-description-name"));
            this.configName = MetaData.getOptionalChildContent(wsd, "config-name");
            this.configFile = MetaData.getOptionalChildContent(wsd, "config-file");
            String wsdlPublishLocation = WebMetaData.getOptionalChildContent(wsd, "wsdl-publish-location");
            this.wsdlPublishLocationMap.put(wsdName, wsdlPublishLocation);
        }
        Iterator dependsElements = WebMetaData.getChildrenByTagName(jbossWeb, "depends");
        while (dependsElements.hasNext()) {
            Element dependsElement = (Element)dependsElements.next();
            String dependsName = WebMetaData.getElementContent(dependsElement);
            this.depends.add(ObjectNameFactory.create(dependsName));
        }
        iterator = WebMetaData.getChildrenByTagName(jbossWeb, "use-session-cookies");
        if (iterator.hasNext()) {
            Element useCookiesElement = (Element)iterator.next();
            String useCookiesElementContent = WebMetaData.getElementContent(useCookiesElement);
            Boolean useCookies = Boolean.valueOf(useCookiesElementContent);
            this.sessionCookies = useCookies != false ? 1 : 2;
        }
        if ((sessionReplicationRootElement = WebMetaData.getOptionalChild(jbossWeb, "replication-config")) != null) {
            Element batchModeElement;
            Element replicationGranularityElement;
            Element replicationTypeElement;
            Element replicationTriggerElement = WebMetaData.getOptionalChild(sessionReplicationRootElement, "replication-trigger");
            if (replicationTriggerElement != null) {
                String repMethod = WebMetaData.getElementContent(replicationTriggerElement);
                if ("SET_AND_GET".equalsIgnoreCase(repMethod)) {
                    this.invalidateSessionPolicy = 1;
                } else if ("SET_AND_NON_PRIMITIVE_GET".equalsIgnoreCase(repMethod)) {
                    this.invalidateSessionPolicy = 2;
                } else if ("SET".equalsIgnoreCase(repMethod)) {
                    this.invalidateSessionPolicy = 3;
                } else {
                    throw new DeploymentException("replication-trigger value set to a non-valid value: '" + repMethod + "' (should be ['SET_AND_GET', 'SET_AND_NON_PRIMITIVE_GET', 'SET']) in jboss-web.xml");
                }
            }
            if ((replicationTypeElement = WebMetaData.getOptionalChild(sessionReplicationRootElement, "replication-type")) != null) {
                String repType = WebMetaData.getElementContent(replicationTypeElement);
                if ("SYNC".equalsIgnoreCase(repType)) {
                    this.replicationType = 0;
                } else if ("ASYNC".equalsIgnoreCase(repType)) {
                    this.replicationType = 1;
                } else {
                    throw new DeploymentException("replication-type value set to a non-valid value: '" + repType + "' (should be ['SYNC', 'ASYNC']) in jboss-web.xml");
                }
            }
            if ((replicationGranularityElement = MetaData.getOptionalChild(sessionReplicationRootElement, "replication-granularity")) != null) {
                String repType = MetaData.getElementContent(replicationGranularityElement);
                if ("SESSION".equalsIgnoreCase(repType)) {
                    this.replicationGranularity = 0;
                } else if ("ATTRIBUTE".equalsIgnoreCase(repType)) {
                    this.replicationGranularity = 1;
                } else if ("FIELD".equalsIgnoreCase(repType)) {
                    this.replicationGranularity = 2;
                } else {
                    throw new DeploymentException("replication-granularity value set to a non-valid value: '" + repType + "' (should be ['SESSION', 'ATTRIBUTE', or 'FIELD'']) in jboss-web.xml");
                }
            }
            if ((batchModeElement = MetaData.getOptionalChild(sessionReplicationRootElement, "replication-field-batch-mode")) != null) {
                Boolean flag = Boolean.valueOf(MetaData.getElementContent(batchModeElement));
                this.replicationFieldBatchMode = flag;
            }
        }
        if ((classLoading = MetaData.getOptionalChild(jbossWeb, "class-loading")) != null) {
            String flagString = classLoading.getAttribute("java2ClassLoadingCompliance");
            if (flagString.length() == 0) {
                flagString = "true";
            }
            boolean flag = Boolean.valueOf(flagString);
            this.setJava2ClassLoadingCompliance(flag);
            Element loader = MetaData.getOptionalChild(classLoading, "loader-repository");
            if (loader != null) {
                try {
                    this.loaderConfig = LoaderRepositoryFactory.parseRepositoryConfig(loader);
                }
                catch (MalformedObjectNameException e) {
                    throw new DeploymentException(e);
                }
            }
        }
        iterator = WebMetaData.getChildrenByTagName(jbossWeb, "servlet");
        while (iterator.hasNext()) {
            Element servlet = (Element)iterator.next();
            String servletName = WebMetaData.getElementContent(WebMetaData.getUniqueChild(servlet, "servlet-name"));
            principalName = WebMetaData.getOptionalChildContent(servlet, "run-as-principal");
            String webXmlRunAs = (String)this.runAsNames.get(servletName);
            if (principalName != null) {
                if (webXmlRunAs == null) {
                    throw new DeploymentException("run-as-principal: " + principalName + " found in jboss-web.xml but there was no run-as in web.xml");
                }
                Set extraRoles = this.getSecurityRoleNamesByPrincipal(principalName);
                RunAsIdentity runAs = new RunAsIdentity(webXmlRunAs, principalName, extraRoles);
                this.runAsIdentity.put(servletName, runAs);
                continue;
            }
            if (webXmlRunAs == null) continue;
            RunAsIdentity runAs = new RunAsIdentity(webXmlRunAs, null);
            this.runAsIdentity.put(servletName, runAs);
        }
    }
}

