/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.jboss.deployment.DeploymentException;
import org.jboss.invocation.InvocationType;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.ClusterConfigMetaData;
import org.jboss.metadata.ConfigurationMetaData;
import org.jboss.metadata.EjbLocalRefMetaData;
import org.jboss.metadata.EjbPortComponentMetaData;
import org.jboss.metadata.EjbRefMetaData;
import org.jboss.metadata.EnvEntryMetaData;
import org.jboss.metadata.IorSecurityConfigMetaData;
import org.jboss.metadata.MessageDestinationRefMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.MethodAttributes;
import org.jboss.metadata.MethodMetaData;
import org.jboss.metadata.ResourceEnvRefMetaData;
import org.jboss.metadata.ResourceRefMetaData;
import org.jboss.metadata.SecurityIdentityMetaData;
import org.jboss.metadata.SecurityRoleRefMetaData;
import org.jboss.metadata.serviceref.ServiceRefMetaData;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.security.AnybodyPrincipal;
import org.jboss.security.NobodyPrincipal;
import org.jboss.security.SimplePrincipal;
import org.w3c.dom.Element;

public abstract class BeanMetaData
extends MetaData {
    public static final char SESSION_TYPE = 'S';
    public static final char ENTITY_TYPE = 'E';
    public static final char MDB_TYPE = 'M';
    public static final String LOCAL_INVOKER_PROXY_BINDING = "LOCAL";
    private ApplicationMetaData application;
    private String ejbName;
    private String homeClass;
    private String remoteClass;
    private String localHomeClass;
    private String localClass;
    protected String serviceEndpointClass;
    private String ejbClass;
    protected char beanType;
    protected boolean containerManagedTx = true;
    private ArrayList environmentEntries = new ArrayList();
    private HashMap ejbReferences = new HashMap();
    private HashMap ejbLocalReferences = new HashMap();
    private HashMap serviceReferences = new HashMap();
    private ArrayList securityRoleReferences = new ArrayList();
    private SecurityIdentityMetaData securityIdentity = null;
    private SecurityIdentityMetaData ejbTimeoutIdentity = null;
    private HashMap resourceReferences = new HashMap();
    private HashMap resourceEnvReferences = new HashMap();
    private HashMap messageDestinationReferences = new HashMap();
    private ArrayList methodAttributes = new ArrayList();
    private ConcurrentReaderHashMap cachedMethodAttributes = new ConcurrentReaderHashMap();
    private ArrayList permissionMethods = new ArrayList();
    private ArrayList transactionMethods = new ArrayList();
    private ConcurrentReaderHashMap methodTx = new ConcurrentReaderHashMap();
    private ArrayList excludedMethods = new ArrayList();
    protected HashMap invokerBindings = null;
    private ClusterConfigMetaData clusterConfig = null;
    private String jndiName;
    private String localJndiName;
    protected String configurationName;
    private ConfigurationMetaData configuration;
    private String securityProxy;
    protected boolean clustered = false;
    protected boolean callByValue = false;
    private Collection depends = new LinkedList();
    private IorSecurityConfigMetaData iorSecurityConfig;
    protected EjbPortComponentMetaData portComponent;
    private boolean exceptionRollback = false;
    private boolean timerPersistence = true;

    public BeanMetaData(ApplicationMetaData app, char beanType) {
        this.application = app;
        this.beanType = beanType;
    }

    public void setBeanType(char beanType) {
        this.beanType = beanType;
    }

    public boolean isSession() {
        return this.beanType == 'S';
    }

    public boolean isMessageDriven() {
        return this.beanType == 'M';
    }

    public boolean isEntity() {
        return this.beanType == 'E';
    }

    public String getHome() {
        return this.homeClass;
    }

    public String getRemote() {
        return this.remoteClass;
    }

    public String getLocalHome() {
        return this.localHomeClass;
    }

    public String getLocal() {
        return this.localClass;
    }

    public String getServiceEndpoint() {
        return this.serviceEndpointClass;
    }

    public EjbPortComponentMetaData getPortComponent() {
        return this.portComponent;
    }

    public void setPortComponent(EjbPortComponentMetaData portComponent) {
        this.portComponent = portComponent;
    }

    public String getEjbClass() {
        return this.ejbClass;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public void setEjbName(String ejbName) {
        this.ejbName = ejbName;
    }

    public boolean isContainerManagedTx() {
        return this.containerManagedTx;
    }

    public boolean isBeanManagedTx() {
        return !this.containerManagedTx;
    }

    public Iterator getEjbReferences() {
        return this.ejbReferences.values().iterator();
    }

    public Iterator getEjbLocalReferences() {
        return this.ejbLocalReferences.values().iterator();
    }

    protected abstract void defaultInvokerBindings();

    public Iterator getInvokerBindings() {
        if (this.invokerBindings == null) {
            String[] defaultNames = this.configuration.getInvokers();
            if (defaultNames.length > 0) {
                this.invokerBindings = new HashMap();
                for (int count = 0; count < defaultNames.length; ++count) {
                    this.invokerBindings.put(defaultNames[count], this.getJndiName());
                }
            } else {
                this.defaultInvokerBindings();
            }
        }
        return this.invokerBindings.keySet().iterator();
    }

    public String getInvokerBinding(String invokerName) {
        if (this.invokerBindings == null) {
            this.defaultInvokerBindings();
        }
        return (String)this.invokerBindings.get(invokerName);
    }

    public EjbRefMetaData getEjbRefByName(String name) {
        return (EjbRefMetaData)this.ejbReferences.get(name);
    }

    public EjbLocalRefMetaData getEjbLocalRefByName(String name) {
        return (EjbLocalRefMetaData)this.ejbLocalReferences.get(name);
    }

    public Iterator getEnvironmentEntries() {
        return this.environmentEntries.iterator();
    }

    public Iterator getSecurityRoleReferences() {
        return this.securityRoleReferences.iterator();
    }

    public Iterator getResourceReferences() {
        return this.resourceReferences.values().iterator();
    }

    public Iterator getResourceEnvReferences() {
        return this.resourceEnvReferences.values().iterator();
    }

    public Iterator getMessageDestinationReferences() {
        return this.messageDestinationReferences.values().iterator();
    }

    public HashMap getServiceReferences() {
        return this.serviceReferences;
    }

    public String getJndiName() {
        if (this.jndiName == null) {
            this.jndiName = this.ejbName;
        }
        return this.jndiName;
    }

    public String getLocalJndiName() {
        if (this.localJndiName == null) {
            this.localJndiName = "local/" + this.ejbName + '@' + System.identityHashCode(this.ejbName);
        }
        return this.localJndiName;
    }

    public String getContainerObjectNameJndiName() {
        return this.getHome() != null ? this.getJndiName() : this.getLocalJndiName();
    }

    public String getConfigurationName() {
        if (this.configurationName == null) {
            this.configurationName = this.getDefaultConfigurationName();
        }
        return this.configurationName;
    }

    public ConfigurationMetaData getContainerConfiguration() {
        if (this.configuration == null) {
            String configName = this.getConfigurationName();
            this.configuration = this.application.getConfigurationMetaDataByName(configName);
            if (this.configuration == null) {
                throw new IllegalStateException("Container config not found " + configName);
            }
        }
        return this.configuration;
    }

    public String getSecurityProxy() {
        return this.securityProxy;
    }

    public SecurityIdentityMetaData getSecurityIdentityMetaData() {
        return this.securityIdentity;
    }

    public SecurityIdentityMetaData getEjbTimeoutIdentity() {
        return this.ejbTimeoutIdentity;
    }

    public ApplicationMetaData getApplicationMetaData() {
        return this.application;
    }

    public abstract String getDefaultConfigurationName();

    public Iterator getTransactionMethods() {
        return this.transactionMethods.iterator();
    }

    public Iterator getPermissionMethods() {
        return this.permissionMethods.iterator();
    }

    public Iterator getExcludedMethods() {
        return this.excludedMethods.iterator();
    }

    public void addTransactionMethod(MethodMetaData method) {
        this.transactionMethods.add(method);
    }

    public void addPermissionMethod(MethodMetaData method) {
        if (method.isUnchecked()) {
            this.permissionMethods.add(0, method);
        } else {
            this.permissionMethods.add(method);
        }
    }

    public void addExcludedMethod(MethodMetaData method) {
        this.excludedMethods.add(method);
    }

    public byte getMethodTransactionType(String methodName, Class[] params, InvocationType iface) {
        byte result = 6;
        MethodMetaData bestMatch = null;
        Iterator iterator = this.getTransactionMethods();
        while (iterator.hasNext()) {
            MethodMetaData m = (MethodMetaData)iterator.next();
            if (!m.patternMatches(methodName, params, iface)) continue;
            if (bestMatch == null) {
                bestMatch = m;
                continue;
            }
            if (bestMatch.getMethodName().equals("*")) {
                bestMatch = m;
            }
            if (m.getMethodParams().length <= 0) continue;
            bestMatch = m;
            break;
        }
        if (bestMatch != null) {
            result = bestMatch.getTransactionType();
        }
        return result;
    }

    public byte getTransactionMethod(Method m, InvocationType iface) {
        if (m == null) {
            return 2;
        }
        Byte b = (Byte)this.methodTx.get((Object)m);
        if (b != null) {
            return b;
        }
        byte result = this.getMethodTransactionType(m.getName(), m.getParameterTypes(), iface);
        if (result == 6) {
            result = 1;
        }
        this.methodTx.put((Object)m, (Object)new Byte(result));
        return result;
    }

    public Collection getDepends() {
        LinkedList allDepends = new LinkedList(this.depends);
        allDepends.addAll(this.getContainerConfiguration().getDepends());
        return allDepends;
    }

    private MethodAttributes methodAttributesForMethod(String methodName) {
        MethodAttributes ma;
        if (methodName == null) {
            methodName = "*null*";
        }
        if ((ma = (MethodAttributes)this.cachedMethodAttributes.get((Object)methodName)) == null) {
            Iterator iterator = this.methodAttributes.iterator();
            while (iterator.hasNext() && ma == null) {
                ma = (MethodAttributes)iterator.next();
                if (ma.patternMatches(methodName)) continue;
                ma = null;
            }
            if (ma == null) {
                ma = MethodAttributes.kDefaultMethodAttributes;
            }
            this.cachedMethodAttributes.put((Object)methodName, (Object)ma);
        }
        return ma;
    }

    public boolean isMethodReadOnly(String methodName) {
        return this.methodAttributesForMethod((String)methodName).readOnly;
    }

    public boolean isMethodReadOnly(Method method) {
        if (method == null) {
            return false;
        }
        return this.methodAttributesForMethod((String)method.getName()).readOnly;
    }

    public int getTransactionTimeout(String methodName) {
        return this.methodAttributesForMethod((String)methodName).txTimeout;
    }

    public int getTransactionTimeout(Method method) {
        if (method == null) {
            return 0;
        }
        return this.getTransactionTimeout(method.getName());
    }

    public Set getMethodPermissions(String methodName, Class[] params, InvocationType iface) {
        MethodMetaData m;
        HashSet<Object> result = new HashSet<Object>();
        Iterator iterator = this.getExcludedMethods();
        while (iterator.hasNext()) {
            m = (MethodMetaData)iterator.next();
            if (!m.patternMatches(methodName, params, iface)) continue;
            result.add(NobodyPrincipal.NOBODY_PRINCIPAL);
            return result;
        }
        iterator = this.getPermissionMethods();
        while (iterator.hasNext()) {
            m = (MethodMetaData)iterator.next();
            if (!m.patternMatches(methodName, params, iface)) continue;
            if (m.isUnchecked()) {
                result.clear();
                result.add(AnybodyPrincipal.ANYBODY_PRINCIPAL);
                break;
            }
            for (String roleName : m.getRoles()) {
                result.add(new SimplePrincipal(roleName));
            }
        }
        if (!this.isExcludeMissingMethods() && result.isEmpty()) {
            result.add(AnybodyPrincipal.ANYBODY_PRINCIPAL);
        }
        return result;
    }

    public boolean hasMethodPermission(String methodName, Class[] params, InvocationType iface) {
        MethodMetaData m;
        Iterator iterator = this.getExcludedMethods();
        while (iterator.hasNext()) {
            m = (MethodMetaData)iterator.next();
            if (!m.patternMatches(methodName, params, iface)) continue;
            return true;
        }
        iterator = this.getPermissionMethods();
        while (iterator.hasNext()) {
            m = (MethodMetaData)iterator.next();
            if (!m.patternMatches(methodName, params, iface)) continue;
            return true;
        }
        return false;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public boolean isCallByValue() {
        return this.callByValue;
    }

    public boolean isExcludeMissingMethods() {
        return this.application.isExcludeMissingMethods();
    }

    public ClusterConfigMetaData getClusterConfigMetaData() {
        if (this.clusterConfig == null) {
            this.clusterConfig = this.getContainerConfiguration().getClusterConfigMetaData();
            if (this.clusterConfig == null) {
                this.clusterConfig = new ClusterConfigMetaData();
            }
            this.clusterConfig.init(this);
        }
        return this.clusterConfig;
    }

    public IorSecurityConfigMetaData getIorSecurityConfigMetaData() {
        return this.iorSecurityConfig;
    }

    public boolean getExceptionRollback() {
        return this.exceptionRollback;
    }

    public boolean getTimerPersistence() {
        return this.timerPersistence;
    }

    public void importEjbJarXml(Element element) throws DeploymentException {
        Element resourceRef;
        this.ejbName = BeanMetaData.getElementContent(BeanMetaData.getUniqueChild(element, "ejb-name"));
        if (!this.isMessageDriven()) {
            this.homeClass = BeanMetaData.getElementContent(BeanMetaData.getOptionalChild(element, "home"));
            this.remoteClass = BeanMetaData.getElementContent(BeanMetaData.getOptionalChild(element, "remote"));
            this.localHomeClass = BeanMetaData.getElementContent(BeanMetaData.getOptionalChild(element, "local-home"));
            this.localClass = BeanMetaData.getElementContent(BeanMetaData.getOptionalChild(element, "local"));
        }
        this.ejbClass = BeanMetaData.getElementContent(BeanMetaData.getUniqueChild(element, "ejb-class"));
        Iterator iterator = BeanMetaData.getChildrenByTagName(element, "env-entry");
        while (iterator.hasNext()) {
            Element envEntry = (Element)iterator.next();
            EnvEntryMetaData envEntryMetaData = new EnvEntryMetaData();
            envEntryMetaData.importEjbJarXml(envEntry);
            this.environmentEntries.add(envEntryMetaData);
        }
        iterator = BeanMetaData.getChildrenByTagName(element, "ejb-ref");
        while (iterator.hasNext()) {
            Element ejbRef = (Element)iterator.next();
            EjbRefMetaData ejbRefMetaData = new EjbRefMetaData();
            ejbRefMetaData.importEjbJarXml(ejbRef);
            this.ejbReferences.put(ejbRefMetaData.getName(), ejbRefMetaData);
        }
        iterator = BeanMetaData.getChildrenByTagName(element, "ejb-local-ref");
        while (iterator.hasNext()) {
            Element ejbLocalRef = (Element)iterator.next();
            EjbLocalRefMetaData ejbLocalRefMetaData = new EjbLocalRefMetaData();
            ejbLocalRefMetaData.importEjbJarXml(ejbLocalRef);
            this.ejbLocalReferences.put(ejbLocalRefMetaData.getName(), ejbLocalRefMetaData);
        }
        iterator = MetaData.getChildrenByTagName(element, "service-ref");
        while (iterator.hasNext()) {
            Element serviceRef = (Element)iterator.next();
            ServiceRefMetaData refMetaData = new ServiceRefMetaData(this.application.getResourceCl());
            refMetaData.importStandardXml(serviceRef);
            this.serviceReferences.put(refMetaData.getServiceRefName(), refMetaData);
        }
        iterator = BeanMetaData.getChildrenByTagName(element, "security-role-ref");
        while (iterator.hasNext()) {
            Element secRoleRef = (Element)iterator.next();
            SecurityRoleRefMetaData securityRoleRefMetaData = new SecurityRoleRefMetaData();
            securityRoleRefMetaData.importEjbJarXml(secRoleRef);
            this.securityRoleReferences.add(securityRoleRefMetaData);
        }
        Element securityIdentityElement = BeanMetaData.getOptionalChild(element, "security-identity");
        if (securityIdentityElement != null) {
            this.securityIdentity = new SecurityIdentityMetaData();
            this.securityIdentity.importEjbJarXml(securityIdentityElement);
        }
        iterator = BeanMetaData.getChildrenByTagName(element, "resource-ref");
        while (iterator.hasNext()) {
            resourceRef = (Element)iterator.next();
            ResourceRefMetaData resourceRefMetaData = new ResourceRefMetaData();
            resourceRefMetaData.importEjbJarXml(resourceRef);
            this.resourceReferences.put(resourceRefMetaData.getRefName(), resourceRefMetaData);
        }
        iterator = BeanMetaData.getChildrenByTagName(element, "resource-env-ref");
        while (iterator.hasNext()) {
            resourceRef = (Element)iterator.next();
            ResourceEnvRefMetaData refMetaData = new ResourceEnvRefMetaData();
            refMetaData.importEjbJarXml(resourceRef);
            this.resourceEnvReferences.put(refMetaData.getRefName(), refMetaData);
        }
        iterator = BeanMetaData.getChildrenByTagName(element, "message-destination-ref");
        while (iterator.hasNext()) {
            Element messageDestinationRef = (Element)iterator.next();
            MessageDestinationRefMetaData messageDestinationRefMetaData = new MessageDestinationRefMetaData();
            messageDestinationRefMetaData.importEjbJarXml(messageDestinationRef);
            this.messageDestinationReferences.put(messageDestinationRefMetaData.getRefName(), messageDestinationRefMetaData);
        }
    }

    public void importJbossXml(Element element) throws DeploymentException {
        Element inv;
        Element mas;
        Element ejbTimeoutIdentityElement;
        Object refMetaData;
        String resRefName;
        Element resourceRef;
        this.jndiName = BeanMetaData.getElementContent(BeanMetaData.getOptionalChild(element, "jndi-name"));
        this.localJndiName = BeanMetaData.getElementContent(BeanMetaData.getOptionalChild(element, "local-jndi-name"));
        String callByValueElt = BeanMetaData.getElementContent(BeanMetaData.getOptionalChild(element, "call-by-value"), this.callByValue ? "True" : "False");
        this.callByValue = callByValueElt.equalsIgnoreCase("True");
        this.configurationName = BeanMetaData.getElementContent(BeanMetaData.getOptionalChild(element, "configuration-name"));
        if (this.configurationName != null && this.getApplicationMetaData().getConfigurationMetaDataByName(this.configurationName) == null) {
            throw new DeploymentException("configuration '" + this.configurationName + "' not found in standardjboss.xml or jboss.xml");
        }
        this.securityProxy = BeanMetaData.getElementContent(BeanMetaData.getOptionalChild(element, "security-proxy"), this.securityProxy);
        this.exceptionRollback = MetaData.getOptionalChildBooleanContent(element, "exception-on-rollback", false);
        this.timerPersistence = MetaData.getOptionalChildBooleanContent(element, "timer-persistence", true);
        Iterator iterator = BeanMetaData.getChildrenByTagName(element, "resource-ref");
        while (iterator.hasNext()) {
            resourceRef = (Element)iterator.next();
            resRefName = BeanMetaData.getElementContent(BeanMetaData.getUniqueChild(resourceRef, "res-ref-name"));
            ResourceRefMetaData resourceRefMetaData = (ResourceRefMetaData)this.resourceReferences.get(resRefName);
            if (resourceRefMetaData == null) {
                throw new DeploymentException("resource-ref " + resRefName + " found in jboss.xml but not in ejb-jar.xml");
            }
            resourceRefMetaData.importJbossXml(resourceRef);
        }
        iterator = BeanMetaData.getChildrenByTagName(element, "resource-env-ref");
        while (iterator.hasNext()) {
            resourceRef = (Element)iterator.next();
            resRefName = BeanMetaData.getElementContent(BeanMetaData.getUniqueChild(resourceRef, "resource-env-ref-name"));
            refMetaData = (ResourceEnvRefMetaData)this.resourceEnvReferences.get(resRefName);
            if (refMetaData == null) {
                throw new DeploymentException("resource-env-ref " + resRefName + " found in jboss.xml but not in ejb-jar.xml");
            }
            ((ResourceEnvRefMetaData)refMetaData).importJbossXml(resourceRef);
        }
        iterator = BeanMetaData.getChildrenByTagName(element, "message-destination-ref");
        while (iterator.hasNext()) {
            Element messageDestinationRef = (Element)iterator.next();
            String messageDestinationRefName = BeanMetaData.getElementContent(BeanMetaData.getUniqueChild(messageDestinationRef, "message-destination-ref-name"));
            MessageDestinationRefMetaData messageDestinationRefMetaData = (MessageDestinationRefMetaData)this.messageDestinationReferences.get(messageDestinationRefName);
            if (messageDestinationRefMetaData == null) {
                throw new DeploymentException("message-destination-ref " + messageDestinationRefName + " found in jboss.xml but not in ejb-jar.xml");
            }
            messageDestinationRefMetaData.importJbossXml(messageDestinationRef);
        }
        iterator = BeanMetaData.getChildrenByTagName(element, "ejb-ref");
        while (iterator.hasNext()) {
            Element ejbRef = (Element)iterator.next();
            String ejbRefName = BeanMetaData.getElementContent(BeanMetaData.getUniqueChild(ejbRef, "ejb-ref-name"));
            EjbRefMetaData ejbRefMetaData = this.getEjbRefByName(ejbRefName);
            if (ejbRefMetaData == null) {
                throw new DeploymentException("ejb-ref " + ejbRefName + " found in jboss.xml but not in ejb-jar.xml");
            }
            ejbRefMetaData.importJbossXml(ejbRef);
        }
        iterator = BeanMetaData.getChildrenByTagName(element, "ejb-local-ref");
        while (iterator.hasNext()) {
            Element ejbLocalRef = (Element)iterator.next();
            String ejbLocalRefName = BeanMetaData.getElementContent(BeanMetaData.getUniqueChild(ejbLocalRef, "ejb-ref-name"));
            EjbLocalRefMetaData ejbLocalRefMetaData = this.getEjbLocalRefByName(ejbLocalRefName);
            if (ejbLocalRefMetaData == null) {
                throw new DeploymentException("ejb-local-ref " + ejbLocalRefName + " found in jboss.xml but not in ejb-jar.xml");
            }
            ejbLocalRefMetaData.importJbossXml(ejbLocalRef);
        }
        iterator = MetaData.getChildrenByTagName(element, "service-ref");
        while (iterator.hasNext()) {
            Element serviceRef = (Element)iterator.next();
            String serviceRefName = MetaData.getUniqueChildContent(serviceRef, "service-ref-name");
            refMetaData = (ServiceRefMetaData)this.serviceReferences.get(serviceRefName);
            if (refMetaData == null) {
                throw new DeploymentException("service-ref " + serviceRefName + " found in jboss.xml but not in ejb-jar.xml");
            }
            ((ServiceRefMetaData)refMetaData).importJBossXml(serviceRef);
        }
        Element securityIdentityElement = BeanMetaData.getOptionalChild(element, "security-identity");
        if (securityIdentityElement != null) {
            if (this.securityIdentity == null) {
                throw new DeploymentException(this.ejbName + ", security-identity in jboss.xml has no match in ejb-jar.xml");
            }
            String runAsPrincipal = BeanMetaData.getElementContent(BeanMetaData.getUniqueChild(securityIdentityElement, "run-as-principal"), this.securityIdentity.getRunAsPrincipalName());
            this.securityIdentity.setRunAsPrincipalName(runAsPrincipal);
        }
        if ((ejbTimeoutIdentityElement = BeanMetaData.getOptionalChild(element, "ejb-timeout-identity")) != null) {
            this.ejbTimeoutIdentity = new SecurityIdentityMetaData();
            String runAsPrincipal = BeanMetaData.getElementContent(BeanMetaData.getUniqueChild(ejbTimeoutIdentityElement, "run-as-principal"), null);
            this.ejbTimeoutIdentity.setRunAsRoleName("ejbTimeout");
            if (runAsPrincipal != null && runAsPrincipal.length() > 0) {
                this.ejbTimeoutIdentity.setRunAsPrincipalName(runAsPrincipal);
            } else {
                this.ejbTimeoutIdentity.setUseCallerIdentity(true);
            }
        }
        if ((mas = BeanMetaData.getOptionalChild(element, "method-attributes")) != null) {
            iterator = BeanMetaData.getChildrenByTagName(mas, "method");
            while (iterator.hasNext()) {
                MethodAttributes ma = new MethodAttributes();
                Element maNode = (Element)iterator.next();
                ma.pattern = BeanMetaData.getElementContent(BeanMetaData.getUniqueChild(maNode, "method-name"));
                ma.readOnly = BeanMetaData.getOptionalChildBooleanContent(maNode, "read-only");
                ma.idempotent = BeanMetaData.getOptionalChildBooleanContent(maNode, "idempotent");
                String txTimeout = BeanMetaData.getOptionalChildContent(maNode, "transaction-timeout");
                try {
                    if (txTimeout != null && txTimeout.length() > 0) {
                        ma.txTimeout = Integer.parseInt(txTimeout);
                    }
                }
                catch (Exception ignore) {
                    log.debug("Ignoring transaction-timeout '" + txTimeout + "'", ignore);
                }
                this.methodAttributes.add(ma);
            }
        }
        if ((inv = BeanMetaData.getOptionalChild(element, "invoker-bindings")) != null) {
            iterator = BeanMetaData.getChildrenByTagName(inv, "invoker");
            this.invokerBindings = new HashMap();
            while (iterator.hasNext()) {
                Element node = (Element)iterator.next();
                String invokerBindingName = BeanMetaData.getUniqueChildContent(node, "invoker-proxy-binding-name");
                String jndiBinding = BeanMetaData.getOptionalChildContent(node, "jndi-name");
                if (jndiBinding == null) {
                    jndiBinding = this.getJndiName();
                }
                this.invokerBindings.put(invokerBindingName, jndiBinding);
                Iterator ejbrefiterator = BeanMetaData.getChildrenByTagName(node, "ejb-ref");
                while (ejbrefiterator.hasNext()) {
                    Element ejbRef = (Element)ejbrefiterator.next();
                    String ejbRefName = BeanMetaData.getElementContent(BeanMetaData.getUniqueChild(ejbRef, "ejb-ref-name"));
                    EjbRefMetaData ejbRefMetaData = this.getEjbRefByName(ejbRefName);
                    if (ejbRefMetaData == null) {
                        throw new DeploymentException("ejb-ref " + ejbRefName + " found in jboss.xml but not in ejb-jar.xml");
                    }
                    ejbRefMetaData.importJbossXml(invokerBindingName, ejbRef);
                }
            }
        }
        String clusteredElt = BeanMetaData.getElementContent(BeanMetaData.getOptionalChild(element, "clustered"), this.clustered ? "True" : "False");
        this.clustered = clusteredElt.equalsIgnoreCase("True");
        Element clusterConfigElement = BeanMetaData.getOptionalChild(element, "cluster-config");
        if (clusterConfigElement != null) {
            this.clusterConfig = new ClusterConfigMetaData();
            this.clusterConfig.init(this);
            this.clusterConfig.importJbossXml(clusterConfigElement);
        }
        Iterator dependsElements = BeanMetaData.getChildrenByTagName(element, "depends");
        while (dependsElements.hasNext()) {
            Element dependsElement = (Element)dependsElements.next();
            String dependsName = BeanMetaData.getElementContent(dependsElement);
            this.depends.add(ObjectNameFactory.create(dependsName));
        }
        Element iorSecurityConfigEl = BeanMetaData.getOptionalChild(element, "ior-security-config");
        if (iorSecurityConfigEl != null) {
            this.iorSecurityConfig = new IorSecurityConfigMetaData(iorSecurityConfigEl);
        }
    }
}

