/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.jndi;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jboss.deployment.DeploymentException;
import org.jboss.jms.jndi.JMSProviderAdapter;
import org.jboss.jms.jndi.JMSProviderLoaderMBean;
import org.jboss.system.ServiceMBeanSupport;

public class JMSProviderLoader
extends ServiceMBeanSupport
implements JMSProviderLoaderMBean {
    protected JMSProviderAdapter providerAdapter;
    protected Properties properties;
    protected String providerName;
    protected String providerAdapterClass;
    protected String factoryRef;
    protected String queueFactoryRef;
    protected String topicFactoryRef;
    protected String jndiName;

    public void setProviderName(String name) {
        this.providerName = name;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderAdapterClass(String clazz) {
        this.providerAdapterClass = clazz;
    }

    public String getProviderAdapterClass() {
        return this.providerAdapterClass;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setAdapterJNDIName(String name) {
        this.jndiName = name;
    }

    public String getAdapterJNDIName() {
        return this.jndiName;
    }

    public void setFactoryRef(String newFactoryRef) {
        this.factoryRef = newFactoryRef;
    }

    public void setQueueFactoryRef(String newQueueFactoryRef) {
        this.queueFactoryRef = newQueueFactoryRef;
    }

    public void setTopicFactoryRef(String newTopicFactoryRef) {
        this.topicFactoryRef = newTopicFactoryRef;
    }

    public String getFactoryRef() {
        return this.factoryRef;
    }

    public String getQueueFactoryRef() {
        return this.queueFactoryRef;
    }

    public String getTopicFactoryRef() {
        return this.topicFactoryRef;
    }

    public String getName() {
        return this.providerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startService() throws Exception {
        if (this.queueFactoryRef == null) {
            throw new DeploymentException("missing required attribute: QueueFactoryRef");
        }
        if (this.topicFactoryRef == null) {
            throw new DeploymentException("missing required attribute: TopicFactoryRef");
        }
        Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(this.providerAdapterClass);
        this.providerAdapter = (JMSProviderAdapter)cls.newInstance();
        this.providerAdapter.setName(this.providerName);
        this.providerAdapter.setProperties(this.properties);
        this.providerAdapter.setFactoryRef(this.factoryRef);
        this.providerAdapter.setQueueFactoryRef(this.queueFactoryRef);
        this.providerAdapter.setTopicFactoryRef(this.topicFactoryRef);
        InitialContext context = new InitialContext();
        try {
            if (this.jndiName == null) {
                String name = this.providerAdapter.getName();
                this.jndiName = "java:/" + name;
            }
            this.bind(context, this.jndiName, this.providerAdapter);
            this.log.debug("Bound adapter to " + this.jndiName);
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopService() throws Exception {
        InitialContext context = new InitialContext();
        try {
            String name = this.providerAdapter.getName();
            String jndiname = "java:/" + name;
            context.unbind(jndiname);
            this.log.debug("unbound adapter " + name + " from " + jndiname);
        }
        finally {
            context.close();
        }
    }

    private void bind(Context ctx, String name, Object val) throws NamingException {
        this.log.debug("attempting to bind " + val + " to " + name);
        Name n = ctx.getNameParser("").parse(name);
        while (n.size() > 1) {
            String ctxName = n.get(0);
            try {
                ctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException e) {
                ctx = ctx.createSubcontext(ctxName);
            }
            n = n.getSuffix(1);
        }
        ctx.bind(n.get(0), val);
    }
}

