/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.mdb;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import org.jboss.ejb3.mdb.ActivationSpec;

public class MDBConfig {
    protected int minPoolSize = 1;
    protected int maxPoolSize = 15;
    protected int keepAlive = 30000;
    protected int maxMessages = 1;
    protected String serverSessionPoolFactoryJNDI = "java:/StdJMSPool";
    protected String providerAdapterJNDI = "java:/DefaultJMSProvider";
    protected long reconnectInterval = 10000L;
    protected boolean useDLQ = true;
    protected String dlq = "queue/DLQ";
    protected int dlqMaxTimesRedelivered = 10;
    protected int dlqTimeToLive = 0;
    protected String dlqUser;
    protected String dlqPassword;
    protected String messageSelector;
    protected String destinationType;
    protected String user;
    protected String password;
    protected String destination;
    protected String acknowledgeMode;
    protected String clientID;
    protected String durability;
    protected String subscriptionName;
    protected String messagingType;
    protected String resourceAdaptorName;

    public String getDlqUser() {
        return this.dlqUser;
    }

    public void setDlqUser(String dlqUser) {
        this.dlqUser = dlqUser;
    }

    public String getDlqPassword() {
        return this.dlqPassword;
    }

    public void setDlqPassword(String dlqPassword) {
        this.dlqPassword = dlqPassword;
    }

    public boolean isUseDLQ() {
        return this.useDLQ;
    }

    public void setUseDLQ(boolean useDLQ) {
        this.useDLQ = useDLQ;
    }

    public String getDlq() {
        return this.dlq;
    }

    public void setDlq(String dlq) {
        this.dlq = dlq;
    }

    public int getDlqMaxTimesRedelivered() {
        return this.dlqMaxTimesRedelivered;
    }

    public void setDlqMaxTimesRedelivered(int dlqMaxTimesRedelivered) {
        this.dlqMaxTimesRedelivered = dlqMaxTimesRedelivered;
    }

    public int getDlqTimeToLive() {
        return this.dlqTimeToLive;
    }

    public void setDlqTimeToLive(int dlqTimeToLive) {
        this.dlqTimeToLive = dlqTimeToLive;
    }

    public String getProviderAdapterJNDI() {
        return this.providerAdapterJNDI;
    }

    public void setProviderAdapterJNDI(String providerAdapterJNDI) {
        this.providerAdapterJNDI = providerAdapterJNDI;
    }

    public String getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setAcknowledgeMode(String acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public String getDurability() {
        return this.durability;
    }

    public void setDurability(String durability) {
        this.durability = durability;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public String getMessagingType() {
        return this.messagingType;
    }

    public void setMessagingType(String messagingType) {
        this.messagingType = messagingType;
    }

    public String getResourceAdaptorName() {
        return this.resourceAdaptorName;
    }

    public void setResourceAdaptorName(String resourceAdaptorName) {
        this.resourceAdaptorName = resourceAdaptorName;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(String destinationType) {
        this.destinationType = destinationType;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(int keepAlive) {
        this.keepAlive = keepAlive;
    }

    public int getMaxMessages() {
        return this.maxMessages;
    }

    public void setMaxMessages(int maxMessages) {
        this.maxMessages = maxMessages;
    }

    public String getServerSessionPoolFactoryJNDI() {
        return this.serverSessionPoolFactoryJNDI;
    }

    public void setServerSessionPoolFactoryJNDI(String serverSessionPoolFactoryJNDI) {
        this.serverSessionPoolFactoryJNDI = serverSessionPoolFactoryJNDI;
    }

    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    public void setReconnectInterval(long reconnectInterval) {
        this.reconnectInterval = reconnectInterval;
    }

    public static MDBConfig createMDBConfig(ActivationSpec spec) {
        MDBConfig instance = new MDBConfig();
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(MDBConfig.class);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        for (String name : spec.keySet()) {
            MDBConfig.setAttribute(instance, descriptors, name, (String)spec.get(name));
        }
        return instance;
    }

    private static void setAttribute(Object instance, PropertyDescriptor[] descriptors, String attributeName, String attributeText) {
        for (int i = 0; i < descriptors.length; ++i) {
            if (!attributeName.equalsIgnoreCase(descriptors[i].getName())) continue;
            Class<?> typeClass = descriptors[i].getPropertyType();
            PropertyEditor editor = PropertyEditorManager.findEditor(typeClass);
            if (editor == null) {
                throw new RuntimeException("No property editor for attribute: " + attributeName + "; type=" + typeClass);
            }
            editor.setAsText(attributeText);
            Object value = editor.getValue();
            try {
                descriptors[i].getWriteMethod().invoke(instance, value);
                break;
            }
            catch (Exception e) {
                throw new RuntimeException("Error setting attribute '" + attributeName + "' in MDBConfig", e);
            }
        }
    }
}

