/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import org.jboss.beans.metadata.plugins.AbstractTypeMetaData;
import org.jboss.logging.Logger;
import org.jboss.reflect.spi.TypeInfo;

public class StringValueMetaData
extends AbstractTypeMetaData {
    private static final Logger log = Logger.getLogger(StringValueMetaData.class);

    public StringValueMetaData() {
    }

    public StringValueMetaData(String value) {
        super(value);
    }

    public void setValue(String value) {
        super.setValue(value);
    }

    public void setValue(Object value) {
        if (value != null && !(value instanceof String)) {
            throw new ClassCastException("value is not a String: " + value);
        }
        super.setValue(value);
    }

    public Object getValue(TypeInfo info, ClassLoader cl) throws Throwable {
        TypeInfo typeInfo;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("getValue value=" + this.value + " type=" + this.type + " info=" + info);
        }
        if ((typeInfo = this.getClassInfo(cl)) == null) {
            typeInfo = info;
        }
        if (typeInfo == null) {
            throw new IllegalArgumentException("Unable to determine type for value: " + this.value);
        }
        return typeInfo.convertValue(this.value);
    }
}

