/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.asynchronous.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Callable;
import EDU.oswego.cs.dl.util.concurrent.FutureResult;
import EDU.oswego.cs.dl.util.concurrent.TimeoutException;
import java.lang.reflect.InvocationTargetException;
import org.jboss.aspects.asynchronous.AsynchronousConstants;
import org.jboss.aspects.asynchronous.AsynchronousParameters;
import org.jboss.aspects.asynchronous.AsynchronousUserTask;
import org.jboss.aspects.asynchronous.ProcessingTime;
import org.jboss.aspects.asynchronous.ThreadManagerResponse;
import org.jboss.aspects.asynchronous.common.ThreadManagerResponseImpl;
import org.jboss.aspects.asynchronous.concurrent.AdapterTask;
import org.jboss.aspects.asynchronous.concurrent.AsynchronousTask;
import org.jboss.aspects.asynchronous.concurrent.TimedCallableImpl;

public final class AsynchronousTaskImpl
implements AsynchronousConstants,
AsynchronousTask {
    private long _timeout = 0L;
    private AsynchronousParameters _inputParametersImpl = null;
    private AsynchronousUserTask _oneInstance = null;
    private FutureResult _futureResult = null;
    private Callable _callable = null;
    private String _id = null;

    AsynchronousTaskImpl(String id, String taskImpl, AsynchronousParameters inputParametersImpl, long timeout) {
        this._id = id;
        this._futureResult = new FutureResult();
        this._timeout = timeout;
        this._inputParametersImpl = inputParametersImpl;
        try {
            Class<?> aClass = Class.forName(taskImpl);
            this._oneInstance = (AsynchronousUserTask)aClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    AsynchronousTaskImpl(String id, AsynchronousUserTask userTask, AsynchronousParameters inputParametersImpl, long timeout) {
        this._id = id;
        this._futureResult = new FutureResult();
        this._timeout = timeout;
        this._oneInstance = userTask;
        this._inputParametersImpl = inputParametersImpl;
    }

    public AsynchronousParameters getInputParameters() {
        return this._inputParametersImpl;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public AsynchronousUserTask getTask() {
        return this._oneInstance;
    }

    public ThreadManagerResponse getResponse() {
        try {
            if (this.isDone()) {
                return (ThreadManagerResponse)this._futureResult.get();
            }
            Object value = this._futureResult.get();
            if (value != null) {
                return (ThreadManagerResponse)value;
            }
            return new ThreadManagerResponseImpl(this.getId(), 40, null, null);
        }
        catch (TimeoutException e) {
            return new ThreadManagerResponseImpl(this.getId(), 10, e.getMessage(), (Object)e, this.getStartingTime(), this.getEndingTime());
        }
        catch (InterruptedException e) {
            return new ThreadManagerResponseImpl(this.getId(), 50, e.getMessage(), e, this.getStartingTime(), this.getEndingTime());
        }
        catch (InvocationTargetException e) {
            int errorCode = 30;
            if (e.getTargetException() instanceof TimeoutException) {
                errorCode = 10;
            }
            return new ThreadManagerResponseImpl(this.getId(), errorCode, e.getTargetException().getMessage(), e.getTargetException(), this.getStartingTime(), this.getEndingTime());
        }
    }

    public long getStartingTime() {
        return ((ProcessingTime)this._callable).getStartingTime();
    }

    public long getEndingTime() {
        return ((ProcessingTime)this._callable).getEndingTime();
    }

    public boolean isDone() {
        return this._futureResult.isReady();
    }

    public Runnable add() throws Exception {
        this._callable = this._timeout == 0L ? new AdapterTask(this.getId(), this._inputParametersImpl, this._oneInstance) : new TimedCallableImpl(new AdapterTask(this.getId(), this._inputParametersImpl, this._oneInstance), this._timeout);
        return this._futureResult.setter(this._callable);
    }

    public String getId() {
        return this._id;
    }
}

